/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import swim.collections.HashTrieMap;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Stage;
import swim.concurrent.Sync;
import swim.concurrent.TaskFunction;
import swim.db.Commit;
import swim.db.Compact;
import swim.db.Database;
import swim.db.FilePageLoader;
import swim.db.FileStoreAwait;
import swim.db.FileStoreClose;
import swim.db.FileStoreCommitter;
import swim.db.FileStoreCompactor;
import swim.db.FileStoreOpenDatabase;
import swim.db.FileStoreOpenZone;
import swim.db.FileStoreZoneFilter;
import swim.db.FileZone;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.Store;
import swim.db.StoreContext;
import swim.db.StoreException;
import swim.db.TreeDelegate;
import swim.db.Zone;
import swim.util.HashGenCacheSet;

public class FileStore
extends Store {
    static final int OPENING = 1;
    static final int OPENED = 2;
    static final int COMMITTING = 4;
    static final int COMPACTING = 8;
    static final AtomicReferenceFieldUpdater<FileStore, HashTrieMap<Integer, FileZone>> ZONES = AtomicReferenceFieldUpdater.newUpdater(FileStore.class, HashTrieMap.class, "zones");
    static final AtomicReferenceFieldUpdater<FileStore, FileZone> ZONE = AtomicReferenceFieldUpdater.newUpdater(FileStore.class, FileZone.class, "zone");
    static final AtomicIntegerFieldUpdater<FileStore> STATUS = AtomicIntegerFieldUpdater.newUpdater(FileStore.class, "status");
    final StoreContext context;
    final File directory;
    final String baseName;
    final String zoneFileExt;
    final Stage stage;
    final HashGenCacheSet<Page> pageCache;
    final FileStoreCommitter committer;
    final FileStoreCompactor compactor;
    final Pattern zonePattern;
    final FilenameFilter zoneFilter;
    volatile HashTrieMap<Integer, FileZone> zones;
    volatile FileZone zone;
    volatile int status;

    public FileStore(StoreContext context, File directory, String baseName, Stage stage) {
        this.context = context;
        this.directory = directory != null ? directory : new File("");
        int lastDotIndex = baseName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            this.baseName = baseName.substring(0, lastDotIndex);
            this.zoneFileExt = baseName.substring(lastDotIndex + 1);
        } else {
            this.baseName = baseName;
            this.zoneFileExt = "swimdb";
        }
        this.stage = stage;
        this.pageCache = new HashGenCacheSet(context.settings.pageCacheSize);
        this.committer = new FileStoreCommitter(this);
        stage.task((TaskFunction)this.committer);
        this.compactor = new FileStoreCompactor(this);
        stage.task((TaskFunction)this.compactor);
        this.zonePattern = Pattern.compile(Pattern.quote(this.baseName) + "-([0-9]+)\\." + Pattern.quote(this.zoneFileExt));
        this.zoneFilter = new FileStoreZoneFilter(this.zonePattern);
        this.zones = HashTrieMap.empty();
        this.status = 0;
    }

    public FileStore(StoreContext context, File basePath, Stage stage) {
        this(context, basePath.getParentFile(), basePath.getName(), stage);
    }

    public FileStore(StoreContext context, String basePath, Stage stage) {
        this(context, new File(basePath), stage);
    }

    public FileStore(File directory, String baseName, Stage stage) {
        this(new StoreContext(), directory, baseName, stage);
    }

    public FileStore(File basePath, Stage stage) {
        this(new StoreContext(), basePath, stage);
    }

    public FileStore(String basePath, Stage stage) {
        this(new StoreContext(), new File(basePath), stage);
    }

    @Override
    public final StoreContext storeContext() {
        return this.context;
    }

    @Override
    public final Database database() {
        FileZone zone = this.zone;
        if (zone != null) {
            return zone.database();
        }
        return null;
    }

    public final File directory() {
        return this.directory;
    }

    public final String baseName() {
        return this.baseName;
    }

    public final String zoneFileExt() {
        return this.zoneFileExt;
    }

    @Override
    public final Stage stage() {
        return this.stage;
    }

    public final HashGenCacheSet<Page> pageCache() {
        return this.pageCache;
    }

    @Override
    public final long size() {
        long size = 0L;
        Iterator zoneIterator = this.zones.valueIterator();
        while (zoneIterator.hasNext()) {
            size += ((FileZone)zoneIterator.next()).size();
        }
        return size;
    }

    @Override
    public final boolean isCommitting() {
        return (this.status & 4) != 0;
    }

    @Override
    public final boolean isCompacting() {
        return (this.status & 8) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void openAsync(Cont<Store> cont) {
        try {
            int oldStatus;
            while (((oldStatus = this.status) & 3) == 0) {
                int newStatus = oldStatus | 1;
                if (!STATUS.compareAndSet(this, oldStatus, newStatus)) continue;
                try {
                    int newestZone;
                    this.directory.mkdirs();
                    TreeMap<Integer, File> zoneFiles = this.zoneFiles();
                    if (!zoneFiles.isEmpty()) {
                        newestZone = zoneFiles.lastKey();
                        zoneFiles.remove(newestZone);
                    } else {
                        newestZone = 1;
                    }
                    this.openZoneAsync(newestZone, new FileStoreOpenZone(this, zoneFiles, cont));
                }
                catch (Throwable cause) {
                    try {
                        if (!Conts.isNonFatal((Throwable)cause)) throw cause;
                        this.close();
                        throw cause;
                    }
                    finally {
                        FileStore fileStore = this;
                        synchronized (fileStore) {
                            this.notifyAll();
                        }
                    }
                }
            }
            if ((oldStatus & 1) != 0) {
                FileStore fileStore = this;
                synchronized (fileStore) {
                    ForkJoinPool.managedBlock(new FileStoreAwait(this));
                }
            }
            if ((this.status & 2) == 0) throw new StoreException("failed to open store");
            cont.bind((Object)this);
            return;
        }
        catch (InterruptedException cause) {
            cont.trap((Throwable)cause);
            return;
        }
        catch (Throwable cause) {
            if (!Conts.isNonFatal((Throwable)cause)) throw cause;
            cont.trap(cause);
            return;
        }
    }

    @Override
    public FileStore open() throws InterruptedException {
        Sync syncStore = new Sync();
        this.openAsync((Cont<Store>)syncStore);
        return (FileStore)syncStore.await((long)this.settings().storeOpenTimeout);
    }

    @Override
    public void closeAsync(Cont<Store> cont) {
        try {
            Database database = this.database();
            if (database != null) {
                database.closeAsync(new FileStoreClose(this, cont));
            } else {
                this.closeZones();
                cont.bind((Object)this);
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public void close() throws InterruptedException {
        Sync syncStore = new Sync();
        this.closeAsync((Cont<Store>)syncStore);
        syncStore.await((long)this.settings().storeCloseTimeout);
    }

    public boolean delete() {
        boolean deleted = false;
        File[] files = this.directory.listFiles(this.zoneFilter);
        if (files != null) {
            deleted = true;
            for (File file : files) {
                deleted = file.delete() && deleted;
            }
        }
        return deleted;
    }

    @Override
    public FileZone zone() {
        return this.zone;
    }

    @Override
    public FileZone zone(int zoneId) {
        return (FileZone)this.zones.get((Object)zoneId);
    }

    @Override
    public void openZoneAsync(int zoneId, Cont<Zone> cont) {
        try {
            FileZone newZone;
            block8: {
                HashTrieMap<Integer, FileZone> oldZones;
                FileZone oldZone;
                newZone = null;
                while ((oldZone = (FileZone)(oldZones = this.zones).get((Object)zoneId)) == null) {
                    HashTrieMap newZones;
                    if (newZone == null) {
                        File zoneFile = this.zoneFile(zoneId);
                        FileZone zone = this.zone;
                        if (zone == null || zoneId > zone.id || zoneFile.exists()) {
                            newZone = new FileZone(this, zoneId, zoneFile, this.stage);
                        } else {
                            throw new StoreException("failed to open deleted zone " + zoneFile);
                        }
                    }
                    if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)(newZones = oldZones.updated((Object)zoneId, (Object)newZone)))) continue;
                    break block8;
                }
                if (newZone != null) {
                    newZone.close();
                }
                newZone = oldZone;
            }
            newZone.openAsync(cont);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public FileZone openZone(int zoneId) throws InterruptedException {
        Sync eventualZone = new Sync();
        this.openZoneAsync(zoneId, (Cont<Zone>)eventualZone);
        return (FileZone)eventualZone.await((long)this.settings().zoneOpenTimeout);
    }

    void closeZone(int zoneId) {
        HashTrieMap newZones;
        HashTrieMap<Integer, FileZone> oldZones;
        while ((oldZones = this.zones) != (newZones = oldZones.removed((Object)zoneId))) {
            if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)newZones)) continue;
            ((FileZone)oldZones.get((Object)zoneId)).close();
            break;
        }
    }

    void closeZones() {
        HashTrieMap newZones;
        HashTrieMap<Integer, FileZone> oldZones;
        while ((oldZones = this.zones) != (newZones = HashTrieMap.empty())) {
            if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)newZones)) continue;
            Iterator zoneIterator = oldZones.valueIterator();
            while (zoneIterator.hasNext()) {
                ((FileZone)zoneIterator.next()).close();
            }
            break block0;
        }
    }

    @Override
    public void openDatabaseAsync(Cont<Database> cont) {
        try {
            this.openAsync(new FileStoreOpenDatabase(this, cont));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public PageLoader openPageLoader(TreeDelegate treeDelegate, boolean isResident) {
        return new FilePageLoader(this, treeDelegate, isResident);
    }

    @Override
    public void commitAsync(Commit commit) {
        try {
            this.committer.commitAsync(commit);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public void compactAsync(Compact compact) {
        try {
            this.compactor.compactAsync(compact);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                compact.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public synchronized FileZone shiftZone() {
        FileZone newZone;
        block8: {
            HashTrieMap<Integer, FileZone> oldZones;
            FileZone zone;
            if ((this.status & 2) == 0) {
                try {
                    this.open();
                }
                catch (InterruptedException cause) {
                    throw new StoreException(cause);
                }
            }
            FileZone oldZone = this.zone;
            int oldZoneId = oldZone.id;
            int newZoneId = oldZoneId + 1;
            newZone = null;
            while ((zone = (FileZone)(oldZones = this.zones).get((Object)newZoneId)) == null) {
                HashTrieMap newZones;
                if (newZone == null) {
                    newZone = new FileZone(this, newZoneId, this.zoneFile(newZoneId), this.stage, oldZone.database, oldZone.germ());
                    try {
                        newZone.open();
                    }
                    catch (InterruptedException cause) {
                        throw new StoreException(cause);
                    }
                }
                if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)(newZones = oldZones.updated((Object)newZoneId, (Object)newZone)))) continue;
                ZONE.set(this, newZone);
                this.context.databaseDidShiftZone(this, newZone.database, newZone);
                break block8;
            }
            if (newZone != null) {
                newZone.close();
            }
            newZone = zone;
        }
        return newZone;
    }

    protected File zoneFile(int zone) {
        return new File(this.directory, this.baseName + "-" + zone + "." + this.zoneFileExt);
    }

    protected TreeMap<Integer, File> zoneFiles() {
        this.directory.mkdirs();
        File[] files = this.directory.listFiles(this.zoneFilter);
        if (files == null) {
            throw new StoreException("failed to access directory " + this.directory.getPath());
        }
        TreeMap<Integer, File> zoneFiles = new TreeMap<Integer, File>();
        for (File file : files) {
            String name = file.getName();
            Matcher matcher = this.zonePattern.matcher(name);
            if (!matcher.matches()) continue;
            int zone = Integer.parseInt(matcher.group(1));
            zoneFiles.put(zone, file);
        }
        return zoneFiles;
    }

    @Override
    void hitPage(Database database, Page page) {
        this.pageCache.put((Object)page);
        super.hitPage(database, page);
    }
}

