/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.File;
import java.util.TreeMap;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.FileStore;
import swim.db.FileZone;
import swim.db.Store;
import swim.db.Zone;

final class FileStoreOpenZone
implements Cont<Zone> {
    final FileStore store;
    final TreeMap<Integer, File> zoneFiles;
    final Cont<Store> andThen;

    FileStoreOpenZone(FileStore store, TreeMap<Integer, File> zoneFiles, Cont<Store> andThen) {
        this.store = store;
        this.zoneFiles = zoneFiles;
        this.andThen = andThen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(Zone zone) {
        block9: {
            try {
                FileZone fileZone = (FileZone)zone;
                if (zone.germ().seedRefValue().isDefined() || this.zoneFiles.isEmpty()) {
                    int newStatus;
                    int oldStatus22;
                    FileStore.ZONE.set(this.store, fileZone);
                    while (!FileStore.STATUS.compareAndSet(this.store, oldStatus22 = this.store.status, newStatus = oldStatus22 & 0xFFFFFFFE | 2)) {
                    }
                    this.andThen.bind((Object)this.store);
                    FileStore oldStatus22 = this.store;
                    synchronized (oldStatus22) {
                        this.store.notifyAll();
                        break block9;
                    }
                }
                this.store.closeZone(fileZone.id);
                File oldFile = fileZone.file;
                if (oldFile.exists()) {
                    String newFileName = "~" + oldFile.getName() + "-" + System.currentTimeMillis();
                    File newFile = new File(oldFile.getParent(), newFileName);
                    oldFile.renameTo(newFile);
                }
                int previousZone = this.zoneFiles.lastKey();
                this.zoneFiles.remove(previousZone);
                this.store.openZoneAsync(previousZone, new FileStoreOpenZone(this.store, this.zoneFiles, this.andThen));
            }
            catch (Throwable cause) {
                if (Conts.isNonFatal((Throwable)cause)) {
                    this.trap(cause);
                }
                throw cause;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trap(Throwable error) {
        try {
            try {
                this.store.close();
            }
            catch (InterruptedException swallow) {
                swallow.printStackTrace();
            }
            finally {
                this.andThen.trap(error);
            }
        }
        finally {
            FileStore fileStore = this.store;
            synchronized (fileStore) {
                this.store.notifyAll();
            }
        }
    }
}

