/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.db.Database;
import swim.db.FileZone;
import swim.db.Zone;

final class FileZoneOpenDatabase
implements Cont<Zone> {
    final FileZone zone;
    final Cont<Database> cont;

    FileZoneOpenDatabase(FileZone zone, Cont<Database> cont) {
        this.zone = zone;
        this.cont = cont;
    }

    public void bind(Zone zone) {
        try {
            Database newDatabase;
            block4: {
                Database oldDatabase;
                while ((oldDatabase = this.zone.database) == null) {
                    newDatabase = new Database(this.zone.store, this.zone.germ);
                    if (!FileZone.DATABASE.compareAndSet(this.zone, oldDatabase, newDatabase)) continue;
                    break block4;
                }
                newDatabase = oldDatabase;
            }
            newDatabase.openAsync(this.cont);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                this.cont.trap(cause);
            }
            throw cause;
        }
    }

    public void trap(Throwable error) {
        this.cont.trap(error);
    }
}

