/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import swim.concurrent.Conts;
import swim.db.FileZone;
import swim.db.StoreException;

abstract class FileZoneReader
implements Runnable {
    protected final FileZone zone;
    protected final FileChannel channel;
    protected final long offset;
    protected final int size;

    protected FileZoneReader(FileZone zone, FileChannel channel, long offset, int size) {
        if ((long)size < 0L) {
            throw new IllegalArgumentException("negative read size: " + size);
        }
        this.zone = zone;
        this.channel = channel;
        this.offset = offset;
        this.size = size;
    }

    protected abstract void bind(ByteBuffer var1);

    protected abstract void trap(Throwable var1);

    protected void doRead(FileChannel channel) {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.size);
            long position = this.offset;
            int k = 0;
            do {
                k = channel.read(buffer, position);
                position += (long)k;
            } while (k >= 0 && buffer.hasRemaining());
            if (buffer.hasRemaining()) {
                throw new StoreException("incomplete read from " + this.zone.file.getPath() + ":" + this.offset + "-" + position);
            }
            ((Buffer)buffer).flip();
            this.bind(buffer);
        }
        catch (IOException cause) {
            this.trap(cause);
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                this.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public void run() {
        this.doRead(this.channel);
    }
}

