/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import swim.codec.Binary;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.concurrent.Conts;
import swim.db.FileZone;
import swim.db.FileZoneReader;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Value;

abstract class FileZoneReconReader
extends FileZoneReader {
    protected FileZoneReconReader(FileZone zone, FileChannel channel, long offset, int size) {
        super(zone, channel, offset, size);
    }

    protected abstract void bind(Value var1);

    @Override
    protected void bind(ByteBuffer buffer) {
        try {
            Parser parser = Utf8.parseDecoded((Parser)Recon.structureParser().blockParser(), (Input)Binary.inputBuffer((ByteBuffer)buffer));
            if (parser.isDone()) {
                this.bind((Value)parser.bind());
            } else {
                this.trap(parser.trap());
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                this.trap(new StoreException("failed read from " + this.zone.file.getPath() + ":" + this.offset + "-" + this.size, cause));
            }
            throw cause;
        }
    }
}

