/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.TreeType;
import swim.structure.Record;
import swim.structure.Value;

public class MetaTree {
    final Value name;
    final TreeType type;
    final int stem;
    final long created;
    final long updated;

    public MetaTree(Value name, TreeType type, int stem, long created, long updated) {
        this.name = name;
        this.type = type;
        this.stem = stem;
        this.created = created;
        this.updated = updated;
    }

    public static MetaTree fromValue(Value name, Value value) {
        String tag = value.tag();
        TreeType type = TreeType.fromTag(tag);
        int stem = value.get("stem").intValue(0);
        long created = value.get("created").longValue(0L);
        long updated = value.get("updated").longValue(0L);
        return new MetaTree(name, type, stem, created, updated);
    }

    public final Value name() {
        return this.name;
    }

    public final TreeType type() {
        return this.type;
    }

    public final int stem() {
        return this.stem;
    }

    public final long created() {
        return this.created;
    }

    public final long updated() {
        return this.updated;
    }

    public Value toValue() {
        return Record.create((int)5).slot("name", this.name).slot("type", this.type.tag()).slot("stem", this.stem).slot("created", this.created).slot("updated", this.updated);
    }
}

