/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Debug;
import swim.codec.Output;

public enum PageType implements Debug
{
    NODE("node"),
    LEAF("leaf");

    final String tag;

    private PageType(String tag) {
        this.tag = tag;
    }

    public static PageType fromTag(String tag) {
        if ("node".equals(tag)) {
            return NODE;
        }
        if ("leaf".equals(tag)) {
            return LEAF;
        }
        return null;
    }

    public boolean isNode() {
        return this == NODE;
    }

    public boolean isLeaf() {
        return this == LEAF;
    }

    public String tag() {
        return this.tag;
    }

    public void debug(Output<?> output) {
        output.write("PageType").write(46).write(this.name());
    }
}

