/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.NoSuchElementException;
import swim.concurrent.Cont;
import swim.concurrent.Sync;
import swim.db.Page;
import swim.db.QTreeNode;
import swim.db.QTreePageRef;
import swim.spatial.BitInterval;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Cursor;

abstract class QTreeNodeCursor
implements Cursor<Slot> {
    final QTreeNode page;
    final long x;
    final long y;
    long index;
    int slotIndex;
    int childIndex;
    Cursor<Slot> childCursor;

    QTreeNodeCursor(QTreeNode page, long x, long y, long index, int slotIndex, int childIndex) {
        this.page = page;
        this.x = x;
        this.y = y;
        this.index = index;
        this.slotIndex = slotIndex;
        this.childIndex = childIndex;
    }

    QTreeNodeCursor(QTreeNode page, long x, long y) {
        this(page, x, y, 0L, 0, 0);
    }

    abstract Cursor<Slot> childCursor(QTreePageRef var1);

    public final boolean isEmpty() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            long yt;
            Slot slot = slots[this.slotIndex];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) continue;
            return false;
        }
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (!childCursor.isEmpty()) {
                    return false;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index += childRef.span();
            }
            this.childIndex = childIndex + 1;
        }
        return true;
    }

    public final Slot head() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            long yt;
            Slot slot = slots[this.slotIndex];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) continue;
            return slot;
        }
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (!childCursor.isEmpty()) {
                    return (Slot)childCursor.head();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index += childRef.span();
            }
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public void step() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            Slot slot = slots[this.slotIndex];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            ++this.index;
            ++this.slotIndex;
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)yt)) continue;
            return;
        }
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    childCursor.step();
                    continue;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index += childRef.span();
            }
            this.childIndex = childIndex + 1;
        }
        throw new UnsupportedOperationException();
    }

    public final void skip(long count) {
        while (count > 0L) {
            Cursor<Slot> childCursor = this.childCursor;
            if (childCursor != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    --count;
                    childCursor.next();
                    continue;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            long childSpan = childRef.span();
            this.childIndex = childIndex + 1;
            if (childSpan < count) {
                this.childCursor = this.childCursor(childRef);
                if (count <= 0L) break;
                this.index += count;
                this.childCursor.skip(count);
                count = 0L;
                break;
            }
            this.index += childSpan;
            count -= childSpan;
        }
    }

    public final boolean hasNext() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            long yt;
            Slot slot = slots[this.slotIndex];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) {
                return true;
            }
            ++this.index;
            ++this.slotIndex;
        }
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return true;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index += childRef.span();
            }
            this.childIndex = childIndex + 1;
        }
        return false;
    }

    public final long nextIndexLong() {
        return this.index;
    }

    public final Slot next() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.slotIndex < slots.length) {
            Slot slot = slots[this.slotIndex];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            ++this.index;
            ++this.slotIndex;
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)yt)) continue;
            return slot;
        }
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    return (Slot)childCursor.next();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index += childRef.span();
            }
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public final boolean hasPrevious() {
        long x = this.x;
        long y = this.y;
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    return true;
                }
                this.childCursor = null;
                continue;
            }
            QTreePageRef[] childRefs = this.page.childRefs;
            int childIndex = this.childIndex - 1;
            if (childIndex < 0) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index -= childRef.span();
            }
            this.childIndex = childIndex;
        }
        Slot[] slots = this.page.slots;
        while (this.slotIndex > 0) {
            long yt;
            Slot slot = slots[this.slotIndex - 1];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) {
                return true;
            }
            --this.index;
            --this.slotIndex;
        }
        return false;
    }

    public final long previousIndexLong() {
        return this.index - 1L;
    }

    public final Slot previous() {
        long x = this.x;
        long y = this.y;
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    --this.index;
                    return (Slot)childCursor.previous();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex - 1;
            QTreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            QTreePageRef childRef = childRefs[childIndex];
            if (BitInterval.intersects((long)x, (long)y, (long)childRef.x, (long)childRef.y)) {
                this.childCursor = this.childCursor(childRef);
            } else {
                this.index -= childRef.span();
            }
            this.childIndex = childIndex;
        }
        Slot[] slots = this.page.slots;
        while (this.slotIndex > 0) {
            Slot slot = slots[this.slotIndex - 1];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            --this.index;
            --this.slotIndex;
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)yt)) continue;
            return slot;
        }
        throw new NoSuchElementException();
    }

    public void load() throws InterruptedException {
        Sync syncPage = new Sync();
        this.page.pageRef.loadTreeAsync(false, (Cont<Page>)syncPage);
        syncPage.await((long)this.page.pageRef.settings().pageLoadTimeout);
    }
}

