/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.NoSuchElementException;
import swim.concurrent.Cont;
import swim.concurrent.Sync;
import swim.db.Page;
import swim.db.STreeNode;
import swim.db.STreePageRef;
import swim.structure.Slot;
import swim.util.Cursor;

abstract class STreeNodeCursor
implements Cursor<Slot> {
    final STreeNode page;
    long index;
    int childIndex;
    Cursor<Slot> childCursor;

    STreeNodeCursor(STreeNode page, long index, int childIndex) {
        this.page = page;
        this.index = index;
        this.childIndex = childIndex;
    }

    STreeNodeCursor(STreeNode page) {
        this(page, 0L, 0);
    }

    abstract Cursor<Slot> childCursor(STreePageRef var1);

    public final boolean isEmpty() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return false;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        return true;
    }

    public final Slot head() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return (Slot)childCursor.head();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public final void step() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    return;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new UnsupportedOperationException();
    }

    public final void skip(long count) {
        while (count > 0L) {
            Cursor<Slot> childCursor = this.childCursor;
            if (childCursor != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    --count;
                    childCursor.next();
                    continue;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            STreePageRef childRef = childRefs[childIndex];
            long childSpan = childRef.span;
            this.childIndex = childIndex + 1;
            if (childSpan < count) {
                this.childCursor = this.childCursor(childRef);
                if (count <= 0L) break;
                this.index += count;
                this.childCursor.skip(count);
                count = 0L;
                break;
            }
            this.index += childSpan;
            count -= childSpan;
        }
    }

    public final boolean hasNext() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    return true;
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        return false;
    }

    public final long nextIndexLong() {
        return this.index;
    }

    public final Slot next() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasNext()) {
                    ++this.index;
                    return (Slot)childCursor.next();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex + 1;
        }
        throw new NoSuchElementException();
    }

    public final boolean hasPrevious() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    return true;
                }
                this.childCursor = null;
                continue;
            }
            STreePageRef[] childRefs = this.page.childRefs;
            int childIndex = this.childIndex - 1;
            if (childIndex < 0) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex;
        }
        return false;
    }

    public final long previousIndexLong() {
        return this.index - 1L;
    }

    public final Slot previous() {
        while (true) {
            Cursor<Slot> childCursor;
            if ((childCursor = this.childCursor) != null) {
                if (childCursor.hasPrevious()) {
                    --this.index;
                    return (Slot)childCursor.previous();
                }
                this.childCursor = null;
                continue;
            }
            int childIndex = this.childIndex - 1;
            STreePageRef[] childRefs = this.page.childRefs;
            if (childIndex >= childRefs.length) break;
            this.childCursor = this.childCursor(childRefs[childIndex]);
            this.childIndex = childIndex;
        }
        throw new NoSuchElementException();
    }

    public void load() throws InterruptedException {
        Sync syncPage = new Sync();
        this.page.pageRef.loadTreeAsync(false, (Cont<Page>)syncPage);
        syncPage.await((long)this.page.pageRef.settings().pageLoadTimeout);
    }
}

