/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.Page;
import swim.db.PageContext;
import swim.db.STreeLeaf;
import swim.db.STreeNode;
import swim.db.STreePageRef;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public abstract class STreePage
extends Page {
    public static STreePage empty(PageContext context, int stem, long version) {
        return STreeLeaf.empty(context, stem, version);
    }

    public static STreePage fromValue(STreePageRef pageRef, Value value) {
        switch (pageRef.pageType()) {
            case LEAF: {
                return STreeLeaf.fromValue(pageRef, value);
            }
            case NODE: {
                return STreeNode.fromValue(pageRef, value);
            }
        }
        throw new IllegalArgumentException(pageRef.toString());
    }

    @Override
    public boolean isSTreePage() {
        return true;
    }

    @Override
    public abstract STreePageRef pageRef();

    public abstract boolean contains(Value var1);

    @Override
    public abstract STreePageRef getChildRef(int var1);

    @Override
    public abstract STreePage getChild(int var1);

    public abstract Slot getSlot(int var1);

    public abstract Value get(long var1);

    public abstract Slot getEntry(long var1);

    public abstract STreePage updated(long var1, Value var3, long var4);

    public abstract STreePage inserted(long var1, Value var3, Value var4, long var5);

    public STreePage appended(Value key, Value newValue, long newVersion) {
        return this.inserted(this.span(), key, newValue, newVersion);
    }

    public STreePage prepended(Value key, Value newValue, long newVersion) {
        return this.inserted(0L, key, newValue, newVersion);
    }

    public abstract STreePage removed(long var1, long var3);

    public abstract STreePage removed(Object var1, long var2);

    public abstract STreePage drop(long var1, long var3);

    public abstract STreePage take(long var1, long var3);

    public abstract long indexOf(Object var1);

    public abstract long lastIndexOf(Object var1);

    public abstract void copyToArray(Object[] var1, int var2);

    public abstract STreePage balanced(long var1);

    public abstract STreeNode split(int var1, long var2);

    public abstract STreePage splitLeft(int var1, long var2);

    public abstract STreePage splitRight(int var1, long var2);

    public abstract STreePage reduced(Value var1, CombinerFunction<? super Value, Value> var2, CombinerFunction<Value, Value> var3, long var4);

    @Override
    public abstract STreePage evacuated(int var1, long var2);

    @Override
    public abstract STreePage committed(int var1, long var2, long var4);

    @Override
    public abstract STreePage uncommitted(long var1);

    abstract void memoizeSize(STreePageRef var1);

    public abstract Cursor<Slot> cursor();

    public abstract Cursor<Slot> depthCursor(int var1);

    public abstract Cursor<Slot> deltaCursor(long var1);
}

