/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.lang.ref.WeakReference;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Sync;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.PageType;
import swim.db.STreeLeaf;
import swim.db.STreePage;
import swim.db.STreePageRefCursor;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class STreePageRef
extends PageRef {
    final PageContext context;
    final PageType pageType;
    final int stem;
    final int post;
    final int zone;
    final long base;
    final long span;
    final Value fold;
    Object page;
    int pageRefSize;
    int pageSize;
    int diffSize;
    long treeSize;

    public STreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, Value fold, Object page, int pageRefSize, int pageSize, int diffSize, long treeSize) {
        this.context = context;
        this.pageType = pageType;
        this.stem = stem;
        this.post = post;
        this.zone = zone;
        this.base = base;
        this.span = span;
        this.fold = fold;
        this.page = page;
        this.pageRefSize = pageRefSize;
        this.pageSize = pageSize;
        this.diffSize = diffSize;
        this.treeSize = treeSize;
    }

    public STreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, Value fold, Object page) {
        this(context, pageType, stem, post, zone, base, span, fold, page, -1, -1, -1, -1L);
    }

    public STreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, Value fold) {
        this(context, pageType, stem, post, zone, base, span, fold, null, -1, -1, -1, -1L);
    }

    public static STreePageRef empty(PageContext context, int stem, long version) {
        return STreeLeaf.empty(context, stem, version).pageRef();
    }

    public static STreePageRef fromValue(PageContext context, int stem, Value value) {
        Throwable cause = null;
        try {
            String tag = value.tag();
            PageType pageType = PageType.fromTag(tag);
            if (pageType == null) {
                return null;
            }
            Value header = value.header(tag);
            int zone = header.get("zone").intValue();
            int post = header.get("post").intValue(zone);
            long base = header.get("base").longValue();
            int size = header.get("size").intValue();
            long area = header.get("area").longValue();
            long span = header.get("span").longValue();
            Value fold = header.get("fold");
            if (base < 0L) {
                throw new StoreException("negative page base: " + base);
            }
            if (size < 0) {
                throw new StoreException("negative page size: " + size);
            }
            if (area < 0L) {
                throw new StoreException("negative page area: " + area);
            }
            if (span < 0L) {
                throw new StoreException("negative page span: " + span);
            }
            return new STreePageRef(context, pageType, stem, post, zone, base, span, fold, null, -1, size, 0, area);
        }
        catch (Throwable error) {
            if (!Conts.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed stree page ref: ");
            Recon.write((Item)value, (Output)message);
            throw new StoreException((String)message.bind(), cause);
        }
    }

    @Override
    public PageContext pageContext() {
        return this.context;
    }

    @Override
    public PageType pageType() {
        return this.pageType;
    }

    @Override
    public int stem() {
        return this.stem;
    }

    @Override
    public int post() {
        return this.post;
    }

    @Override
    public int zone() {
        return this.zone;
    }

    @Override
    public long base() {
        return this.base;
    }

    @Override
    public long span() {
        return this.span;
    }

    @Override
    public Value fold() {
        return this.fold;
    }

    @Override
    public STreePage page() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof STreePage) {
            this.context.hitPage((STreePage)page);
            return (STreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(false);
        try {
            Sync syncPage = new Sync();
            pageLoader.loadPageAsync(this, (Cont<Page>)syncPage);
            STreePage sTreePage = (STreePage)syncPage.await((long)this.settings().pageLoadTimeout);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return sTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException error) {
                throw new StoreException(this.toDebugString(), error);
            }
            catch (Throwable error) {
                if (Conts.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public STreePage hardPage() {
        Object page = this.page;
        if (page instanceof STreePage) {
            return (STreePage)page;
        }
        return null;
    }

    @Override
    public STreePage softPage() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof STreePage) {
            return (STreePage)page;
        }
        return null;
    }

    @Override
    public long softVersion() {
        STreePage page = this.softPage();
        if (page != null) {
            return page.version();
        }
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.span == 0L;
    }

    @Override
    public boolean isCommitted() {
        return this.zone > 0 && this.base > 0L;
    }

    @Override
    public int pageRefSize() {
        int pageRefSize = this.pageRefSize;
        if (pageRefSize < 0) {
            pageRefSize = 5;
            if (this.post != this.zone) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)Num.from((int)this.post));
            }
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.zone));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.base));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.pageSize()));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.treeSize()));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.span));
            Value fold = this.fold();
            if (fold.isDefined()) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)fold);
            }
            this.pageRefSize = ++pageRefSize;
        }
        return pageRefSize;
    }

    @Override
    public int pageSize() {
        if (this.pageSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.pageSize;
    }

    @Override
    public int diffSize() {
        if (this.diffSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.diffSize;
    }

    @Override
    public long treeSize() {
        if (this.treeSize < 0L) {
            this.page().memoizeSize(this);
        }
        return this.treeSize;
    }

    @Override
    public Value toValue() {
        Record header = Record.create((int)7);
        if (this.post != this.zone) {
            header.slot("post", this.post);
        }
        header.slot("zone", this.zone).slot("base", this.base).slot("size", this.pageSize()).slot("area", this.treeSize()).slot("span", this.span);
        Value fold = this.fold();
        if (fold.isDefined()) {
            header.slot("fold", fold);
        }
        return Record.create((int)1).attr(this.pageType.tag(), (Value)header);
    }

    public STreePageRef reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        if (!this.fold.isDefined()) {
            return this.page().reduced(identity, accumulator, combiner, newVersion).pageRef();
        }
        return this;
    }

    @Override
    public STreePageRef evacuated(int post, long version) {
        if (this.post != 0 && this.post < post) {
            return this.page().evacuated(post, version).pageRef();
        }
        return this;
    }

    @Override
    public STreePageRef committed(int zone, long base, long version) {
        STreePage page = this.hardPage();
        if (page != null) {
            return page.committed(zone, base, version).pageRef();
        }
        return this;
    }

    @Override
    public STreePageRef uncommitted(long version) {
        STreePage page = this.hardPage();
        if (page != null && page.version() >= version) {
            return page.uncommitted(version).pageRef();
        }
        return this;
    }

    @Override
    public void writePageRef(Output<?> output) {
        Recon.write((Item)this.toValue(), output);
    }

    @Override
    public void writePage(Output<?> output) {
        this.page().writePage(output);
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.page().writeDiff(output);
    }

    @Override
    public STreePage setPageValue(Value value, boolean isResident) {
        STreePage page = STreePage.fromValue(this, value);
        if (isResident) {
            this.page = page;
        } else {
            this.context.hitPage(page);
            this.page = new WeakReference<STreePage>(page);
        }
        return page;
    }

    @Override
    public void loadPageAsync(boolean isResident, Cont<Page> cont) {
        try {
            Object page = this.page;
            if (page instanceof WeakReference) {
                page = ((WeakReference)page).get();
            }
            if (page instanceof STreePage) {
                this.context.stage().execute(Conts.async(cont, (Object)((STreePage)page)));
            } else {
                PageLoader pageLoader = this.context.openPageLoader(isResident);
                pageLoader.loadPageAsync(this, new PageRef.LoadPage(pageLoader, cont));
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap((Throwable)new StoreException(this.toDebugString(), cause));
            }
            throw cause;
        }
    }

    @Override
    public void loadTreeAsync(boolean isResident, Cont<Page> cont) {
        try {
            PageLoader pageLoader = this.context.openPageLoader(isResident);
            this.loadTreeAsync(pageLoader, (Cont<Page>)new PageRef.LoadPage(pageLoader, cont));
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap((Throwable)new StoreException(this.toDebugString(), cause));
            }
            throw cause;
        }
    }

    @Override
    public void loadTreeAsync(PageLoader pageLoader, Cont<Page> cont) {
        try {
            Object page = this.page;
            if (page instanceof WeakReference) {
                page = ((WeakReference)page).get();
            }
            if (page instanceof STreePage) {
                Cont andThen = Conts.constant(cont, (Object)((STreePage)page));
                ((STreePage)page).loadTreeAsync(pageLoader, (Cont<Page>)andThen);
            } else {
                pageLoader.loadPageAsync(this, new PageRef.LoadTree(pageLoader, cont));
            }
        }
        catch (Throwable cause) {
            if (Conts.isNonFatal((Throwable)cause)) {
                cont.trap((Throwable)new StoreException(this.toDebugString(), cause));
            }
            throw cause;
        }
    }

    @Override
    public void soften(long version) {
        Object page = this.page;
        if (page instanceof STreePage) {
            if (((STreePage)page).version() <= version && this.isCommitted()) {
                this.context.hitPage((STreePage)page);
                this.page = new WeakReference<Object>(page);
            }
            ((STreePage)page).soften(version);
        }
    }

    public Cursor<Slot> cursor() {
        return this.page().cursor();
    }

    public Cursor<Slot> depthCursor(int maxDepth) {
        if (maxDepth > 0) {
            return this.page().depthCursor(maxDepth);
        }
        Value fold = this.fold();
        if (fold instanceof Record) {
            return new STreePageRefCursor(this, (Record)fold);
        }
        if (fold.isDefined()) {
            return new STreePageRefCursor(this, Record.of((Object)fold));
        }
        return new STreePageRefCursor(this, Record.empty());
    }

    public Cursor<Slot> deltaCursor(long sinceVersion) {
        return this.page().deltaCursor(sinceVersion);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)this.pageRefSize());
        this.writePageRef(output);
        return (String)output.bind();
    }
}

