/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Compact;
import swim.db.Database;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.Store;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.Zone;

public class StoreContext {
    protected final StoreSettings settings;

    public StoreContext(StoreSettings settings) {
        this.settings = settings;
    }

    public StoreContext() {
        this(StoreSettings.standard());
    }

    public static boolean autoCommit(Database database, long autoCommitSize, int autoCommitInterval, Commit commit) {
        if (autoCommitInterval > 0 && (database.diffSize() > autoCommitSize || System.currentTimeMillis() - database.germ().updated() > (long)autoCommitInterval)) {
            database.commitAsync(commit);
            return true;
        }
        return false;
    }

    public static Commit autoCommitShifted(Store store, long maxZoneSize, Commit commit) {
        if (store.zone().size() > maxZoneSize) {
            return commit.isShifted(true);
        }
        return commit;
    }

    public static boolean autoCompact(Store store, Database database, double minTreeFill, long minCompactSize, Compact compact) {
        if (!store.isCompacting()) {
            long treeSize = database.treeSize();
            long storeSize = store.size();
            double treeFill = (double)treeSize / (double)storeSize;
            if (storeSize > minCompactSize && treeFill < minTreeFill) {
                store.compactAsync(compact);
                return true;
            }
        }
        return false;
    }

    public static Compact autoCompactShifted(Store store, double minZoneFill, Compact compact) {
        long zoneSize = store.zone().size();
        long storeSize = store.size();
        double zoneFill = (double)zoneSize / (double)storeSize;
        if (zoneSize > 0L && zoneFill > minZoneFill) {
            return compact.isShifted(true);
        }
        return compact;
    }

    public final StoreSettings settings() {
        return this.settings;
    }

    public boolean pageShouldSplit(Store store, Database database, Page page) {
        return PageContext.pageShouldSplit(page, this.settings.pageSplitSize);
    }

    public boolean pageShouldMerge(Store store, Database database, Page page) {
        return PageContext.pageShouldMerge(page, this.settings.pageSplitSize);
    }

    public void hitPage(Store store, Database database, Page page) {
    }

    public void treeDidOpen(Store store, Database database, Tree tree) {
    }

    public void treeDidClose(Store store, Database database, Tree tree) {
    }

    public void treeDidChange(Store store, Database database, Tree newTree, Tree oldTree) {
        StoreContext.autoCommit(database, this.settings.autoCommitSize, this.settings.autoCommitInterval, Commit.forced());
    }

    public void databaseWillOpen(Store store, Database database) {
    }

    public void databaseDidOpen(Store store, Database database) {
    }

    public void databaseWillClose(Store store, Database database) {
    }

    public void databaseDidClose(Store store, Database database) {
    }

    public Commit databaseWillCommit(Store store, Database database, Commit commit) {
        return StoreContext.autoCommitShifted(store, this.settings.maxZoneSize, commit);
    }

    public void databaseDidCommit(Store store, Database database, Chunk chunk) {
        if (chunk != null && !chunk.commit().isClosed()) {
            StoreContext.autoCompact(store, database, this.settings.minTreeFill, this.settings.minCompactSize, Compact.forced(this.settings.deleteDelay));
        }
    }

    public void databaseCommitDidFail(Store store, Database database, Throwable error) {
        error.printStackTrace();
    }

    public Compact databaseWillCompact(Store store, Database database, Compact compact) {
        return StoreContext.autoCompactShifted(store, this.settings.minZoneFill, compact);
    }

    public void databaseDidCompact(Store store, Database database, Compact compact) {
    }

    public void databaseCompactDidFail(Store store, Database database, Throwable error) {
        error.printStackTrace();
    }

    public void databaseDidShiftZone(Store store, Database database, Zone newZone) {
    }

    public void databaseDidDeleteZone(Store store, Database database, int zoneId) {
    }
}

