/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.StoreSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class StoreSettingsForm
extends Form<StoreSettings> {
    StoreSettingsForm() {
    }

    public String tag() {
        return "store";
    }

    public StoreSettings unit() {
        return StoreSettings.standard();
    }

    public Class<?> type() {
        return StoreSettings.class;
    }

    public Item mold(StoreSettings settings) {
        if (settings != null) {
            StoreSettings standard = StoreSettings.standard();
            Record record = Record.create((int)20).attr(this.tag());
            if (settings.pageSplitSize != standard.pageSplitSize) {
                record.slot("pageSplitSize", settings.pageSplitSize);
            }
            if (settings.pageCacheSize != standard.pageCacheSize) {
                record.slot("pageCacheSize", settings.pageCacheSize);
            }
            if (settings.autoCommitInterval != standard.autoCommitInterval) {
                record.slot("autoCommitInterval", settings.autoCommitInterval);
            }
            if (settings.autoCommitSize != standard.autoCommitSize) {
                record.slot("autoCommitSize", settings.autoCommitSize);
            }
            if (settings.minCompactSize != standard.minCompactSize) {
                record.slot("minCompactSize", settings.minCompactSize);
            }
            if (settings.maxZoneSize != standard.maxZoneSize) {
                record.slot("maxZoneSize", settings.maxZoneSize);
            }
            if (settings.minZoneFill != standard.minZoneFill) {
                record.slot("minZoneFill", settings.minZoneFill);
            }
            if (settings.minTreeFill != standard.minTreeFill) {
                record.slot("minTreeFill", settings.minTreeFill);
            }
            if (settings.maxRetries != standard.maxRetries) {
                record.slot("maxRetries", settings.maxRetries);
            }
            if (settings.deleteDelay != standard.deleteDelay) {
                record.slot("deleteDelay", settings.deleteDelay);
            }
            if (settings.storeOpenTimeout != standard.storeOpenTimeout) {
                record.slot("storeOpenTimeout", settings.storeOpenTimeout);
            }
            if (settings.storeCloseTimeout != standard.storeCloseTimeout) {
                record.slot("storeCloseTimeout", settings.storeCloseTimeout);
            }
            if (settings.zoneOpenTimeout != standard.zoneOpenTimeout) {
                record.slot("zoneOpenTimeout", settings.zoneOpenTimeout);
            }
            if (settings.zoneCloseTimeout != standard.zoneCloseTimeout) {
                record.slot("zoneCloseTimeout", settings.zoneCloseTimeout);
            }
            if (settings.databaseOpenTimeout != standard.databaseOpenTimeout) {
                record.slot("databaseOpenTimeout", settings.databaseOpenTimeout);
            }
            if (settings.databaseCloseTimeout != standard.databaseCloseTimeout) {
                record.slot("databaseCloseTimeout", settings.databaseCloseTimeout);
            }
            if (settings.databaseCommitTimeout != standard.databaseCommitTimeout) {
                record.slot("databaseCommitTimeout", settings.databaseCommitTimeout);
            }
            if (settings.databaseCompactTimeout != standard.databaseCompactTimeout) {
                record.slot("databaseCompactTimeout", settings.databaseCompactTimeout);
            }
            if (settings.pageLoadTimeout != standard.pageLoadTimeout) {
                record.slot("pageLoadTimeout", settings.pageLoadTimeout);
            }
            if (settings.treeLoadTimeout != standard.treeLoadTimeout) {
                record.slot("treeLoadTimeout", settings.treeLoadTimeout);
            }
            return record;
        }
        return Item.extant();
    }

    public StoreSettings cast(Item item) {
        Value value = item.toValue();
        if (value.getAttr(this.tag()).isDefined()) {
            StoreSettings standard = StoreSettings.standard();
            int pageSplitSize = value.get("pageSplitSize").intValue(standard.pageSplitSize);
            int pageCacheSize = value.get("pageCacheSize").intValue(standard.pageCacheSize);
            int autoCommitInterval = value.get("autoCommitInterval").intValue(standard.autoCommitInterval);
            long autoCommitSize = value.get("autoCommitSize").longValue(standard.autoCommitSize);
            long minCompactSize = value.get("minCompactSize").longValue(standard.minCompactSize);
            long maxZoneSize = value.get("maxZoneSize").longValue(standard.maxZoneSize);
            double minZoneFill = value.get("minZoneFill").doubleValue(standard.minZoneFill);
            double minTreeFill = value.get("minTreeFill").doubleValue(standard.minTreeFill);
            int maxRetries = value.get("maxRetries").intValue(standard.maxRetries);
            int deleteDelay = value.get("deleteDelay").intValue(standard.deleteDelay);
            int storeOpenTimeout = value.get("storeOpenTimeout").intValue(standard.storeOpenTimeout);
            int storeCloseTimeout = value.get("storeCloseTimeout").intValue(standard.storeCloseTimeout);
            int zoneOpenTimeout = value.get("zoneOpenTimeout").intValue(standard.zoneOpenTimeout);
            int zoneCloseTimeout = value.get("zoneCloseTimeout").intValue(standard.zoneCloseTimeout);
            int databaseOpenTimeout = value.get("databaseOpenTimeout").intValue(standard.databaseOpenTimeout);
            int databaseCloseTimeout = value.get("databaseCloseTimeout").intValue(standard.databaseCloseTimeout);
            int databaseCommitTimeout = value.get("databaseCommitTimeout").intValue(standard.databaseCommitTimeout);
            int databaseCompactTimeout = value.get("databaseCompactTimeout").intValue(standard.databaseCompactTimeout);
            int pageLoadTimeout = value.get("pageLoadTimeout").intValue(standard.pageLoadTimeout);
            int treeLoadTimeout = value.get("treeLoadTimeout").intValue(standard.treeLoadTimeout);
            return new StoreSettings(pageSplitSize, pageCacheSize, autoCommitInterval, autoCommitSize, minCompactSize, maxZoneSize, minZoneFill, minTreeFill, maxRetries, deleteDelay, storeOpenTimeout, storeCloseTimeout, zoneOpenTimeout, zoneCloseTimeout, databaseOpenTimeout, databaseCloseTimeout, databaseCommitTimeout, databaseCompactTimeout, pageLoadTimeout, treeLoadTimeout);
        }
        return null;
    }
}

