/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.BTree;
import swim.db.BTreePageRef;
import swim.db.PageContext;
import swim.db.PageRef;
import swim.db.QTree;
import swim.db.QTreePageRef;
import swim.db.STree;
import swim.db.STreePageRef;
import swim.db.Seed;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.UTree;
import swim.db.UTreePageRef;
import swim.structure.Value;

public enum TreeType {
    BTREE("btree"),
    QTREE("qtree"),
    STREE("stree"),
    UTREE("utree");

    final String tag;

    private TreeType(String tag) {
        this.tag = tag;
    }

    public static TreeType fromTag(String tag) {
        if ("btree".equals(tag)) {
            return BTREE;
        }
        if ("qtree".equals(tag)) {
            return QTREE;
        }
        if ("stree".equals(tag)) {
            return STREE;
        }
        if ("utree".equals(tag)) {
            return UTREE;
        }
        return null;
    }

    public boolean isBTree() {
        return this == BTREE;
    }

    public boolean isQTree() {
        return this == QTREE;
    }

    public boolean isSTree() {
        return this == STREE;
    }

    public boolean isUTree() {
        return this == UTREE;
    }

    public String tag() {
        return this.tag;
    }

    public PageRef emptyPageRef(PageContext pageContext, int stem, long version) {
        switch (this) {
            case BTREE: {
                return BTreePageRef.empty(pageContext, stem, version);
            }
            case QTREE: {
                return QTreePageRef.empty(pageContext, stem, version);
            }
            case STREE: {
                return STreePageRef.empty(pageContext, stem, version);
            }
            case UTREE: {
                return UTreePageRef.empty(pageContext, stem, version);
            }
        }
        throw new UnsupportedOperationException();
    }

    public PageRef pageRefFromValue(PageContext pageContext, int stem, Value value) {
        switch (this) {
            case BTREE: {
                return BTreePageRef.fromValue(pageContext, stem, value);
            }
            case QTREE: {
                return QTreePageRef.fromValue(pageContext, stem, value);
            }
            case STREE: {
                return STreePageRef.fromValue(pageContext, stem, value);
            }
            case UTREE: {
                return UTreePageRef.fromValue(pageContext, stem, value);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Tree emptyTree(TreeContext treeContext, int stem, long version, boolean isResident, boolean isTransient) {
        switch (this) {
            case BTREE: {
                return new BTree(treeContext, stem, version, isResident, isTransient);
            }
            case QTREE: {
                return new QTree(treeContext, stem, version, isResident, isTransient);
            }
            case STREE: {
                return new STree(treeContext, stem, version, isResident, isTransient);
            }
            case UTREE: {
                return new UTree(treeContext, stem, version, isResident, isTransient);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Tree treeFromSeed(TreeContext treeContext, Seed seed, boolean isResident, boolean isTransient) {
        switch (this) {
            case BTREE: {
                return new BTree(treeContext, seed, isResident, isTransient);
            }
            case QTREE: {
                return new QTree(treeContext, seed, isResident, isTransient);
            }
            case STREE: {
                return new STree(treeContext, seed, isResident, isTransient);
            }
            case UTREE: {
                return new UTree(treeContext, seed, isResident, isTransient);
            }
        }
        throw new UnsupportedOperationException();
    }
}

