/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.concurrent.Cont;
import swim.concurrent.Conts;
import swim.concurrent.Sync;
import swim.db.Page;
import swim.db.Seed;
import swim.db.StoreException;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeType;
import swim.db.UTreePage;
import swim.db.UTreePageRef;
import swim.structure.Value;
import swim.util.Cursor;

public final class UTree
extends Tree {
    final TreeContext treeContext;
    final UTreePageRef rootRef;
    final Seed seed;
    final boolean isResident;
    final boolean isTransient;

    public UTree(TreeContext treeContext, UTreePageRef rootRef, Seed seed, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = rootRef;
        this.seed = seed;
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    public UTree(TreeContext treeContext, Seed seed, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = (UTreePageRef)seed.rootRef(treeContext);
        this.seed = seed;
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    public UTree(TreeContext treeContext, int stem, long version, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = UTreePageRef.empty(treeContext, stem, version);
        long time = System.currentTimeMillis();
        this.seed = new Seed(TreeType.UTREE, stem, time, time, this.rootRef.toValue());
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    @Override
    public TreeType treeType() {
        return TreeType.UTREE;
    }

    @Override
    public TreeContext treeContext() {
        return this.treeContext;
    }

    @Override
    public UTreePageRef rootRef() {
        return this.rootRef;
    }

    @Override
    public Seed seed() {
        return this.seed;
    }

    @Override
    public boolean isResident() {
        return this.isResident;
    }

    @Override
    public UTree isResident(boolean isResident) {
        if (this.isResident != isResident) {
            return new UTree(this.treeContext, this.rootRef, this.seed, isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public UTree isTransient(boolean isTransient) {
        if (this.isTransient != isTransient) {
            return new UTree(this.treeContext, this.rootRef, this.seed, this.isResident, isTransient);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.rootRef.isEmpty();
    }

    public Value get() {
        return this.rootRef.page().get();
    }

    public UTree updated(Value newValue, long newVersion, int newPost) {
        UTreePage newRoot;
        UTreePage oldRoot = this.rootRef.page();
        if (oldRoot != (newRoot = oldRoot.updated(newValue, newVersion).evacuated(newPost, newVersion))) {
            return new UTree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public int diffSize(long version) {
        if (version == this.rootRef.softVersion()) {
            return this.rootRef.diffSize();
        }
        return 0;
    }

    @Override
    public long treeSize() {
        return this.rootRef.treeSize();
    }

    @Override
    public UTree evacuated(int post, long version) {
        UTreePageRef oldRootRef = this.rootRef;
        UTreePageRef newRootRef = oldRootRef.evacuated(post, version);
        if (oldRootRef != newRootRef) {
            return new UTree(this.treeContext, newRootRef, this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public UTree committed(int zone, long base, long version, long time) {
        if (!this.rootRef.isCommitted()) {
            UTreePageRef newRootRef = this.rootRef.committed(zone, base, version);
            Seed newSeed = this.seed.committed(time, newRootRef);
            return new UTree(this.treeContext, newRootRef, newSeed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public UTree uncommitted(long version) {
        UTreePageRef oldRootRef = this.rootRef;
        UTreePageRef newRootRef = oldRootRef.uncommitted(version);
        if (oldRootRef != newRootRef) {
            Seed newSeed = this.seed.uncommitted(newRootRef);
            return new UTree(this.treeContext, newRootRef, newSeed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public void writeDiff(Output<?> output, long version) {
        if (version == this.rootRef.softVersion()) {
            this.rootRef.writeDiff(output);
        }
    }

    @Override
    public void loadAsync(Cont<Tree> cont) {
        try {
            Cont andThen = Conts.constant(cont, (Object)this);
            this.rootRef.loadTreeAsync(this.isResident, (Cont<Page>)andThen);
        }
        catch (Throwable error) {
            if (Conts.isNonFatal((Throwable)error)) {
                cont.trap((Throwable)new StoreException(this.rootRef.toDebugString(), error));
            }
            throw error;
        }
    }

    @Override
    public UTree load() throws InterruptedException {
        Sync syncTree = new Sync();
        this.loadAsync((Cont<Tree>)syncTree);
        return (UTree)syncTree.await((long)this.settings().treeLoadTimeout);
    }

    @Override
    public void soften(long version) {
        if (!this.isResident && !this.isTransient) {
            this.rootRef.soften(version);
        }
    }

    public Cursor<Value> cursor() {
        return this.rootRef.cursor();
    }
}

