/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.BTreeLeafCursor;
import swim.db.BTreeNode;
import swim.db.BTreePage;
import swim.db.BTreePageRef;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.OrderedMapCursor;

public final class BTreeLeaf
extends BTreePage {
    final BTreePageRef pageRef;
    final long version;
    final Slot[] slots;
    static final Slot[] EMPTY_SLOTS = new Slot[0];

    protected BTreeLeaf(BTreePageRef pageRef, long version, Slot[] slots) {
        this.pageRef = pageRef;
        this.version = version;
        this.slots = slots;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public BTreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.LEAF;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return this.slots.length == 0;
    }

    @Override
    public int arity() {
        return this.slots.length;
    }

    @Override
    public int childCount() {
        return 0;
    }

    @Override
    public BTreePageRef getChildRef(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public BTreePage getChild(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public Slot getSlot(int x) {
        return this.slots[x];
    }

    @Override
    public Value getKey(int x) {
        return this.slots[x].key();
    }

    @Override
    public Value minKey() {
        return this.slots[0].key();
    }

    @Override
    public Value maxKey() {
        return this.slots[this.slots.length - 1].key();
    }

    int lookup(Value key) {
        Slot[] slots = this.slots;
        int low = 0;
        int high = slots.length - 1;
        while (low <= high) {
            int order;
            int x = low + high >>> 1;
            int n = order = key != null ? key.compareTo((Item)slots[x].key()) : -1;
            if (order > 0) {
                low = x + 1;
                continue;
            }
            if (order < 0) {
                high = x - 1;
                continue;
            }
            return x;
        }
        return -(low + 1);
    }

    @Override
    public long indexOf(Value key) {
        return this.lookup(key);
    }

    @Override
    public boolean containsKey(Value key) {
        return this.lookup(key) >= 0;
    }

    @Override
    public boolean containsValue(Value value) {
        Slot[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            if (!value.equals((Object)slots[i].value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value get(Value key) {
        int x = this.lookup(key);
        if (x >= 0) {
            return this.slots[x].value();
        }
        return Value.absent();
    }

    @Override
    public Slot getEntry(Value key) {
        int x = this.lookup(key);
        if (x >= 0) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public Slot getIndex(long index) {
        if (0L <= index && index < (long)this.slots.length) {
            return this.slots[(int)index];
        }
        return null;
    }

    @Override
    public Slot firstEntry(Value key) {
        int x = this.lookup(key);
        if (x >= 0) {
            return this.slots[x];
        }
        if (0 <= (x = -(x + 1)) && x < this.slots.length) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public Slot firstEntry() {
        if (this.slots.length != 0) {
            return this.slots[0];
        }
        return null;
    }

    @Override
    public Slot lastEntry() {
        if (this.slots.length != 0) {
            return this.slots[this.slots.length - 1];
        }
        return null;
    }

    @Override
    public Slot nextEntry(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        if (0 <= x && x < this.slots.length) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public Slot previousEntry(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? --x : -(x + 2);
        if (0 <= x && x < this.slots.length) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public BTreePage updated(Value key, Value newValue, long newVersion) {
        int x = this.lookup(key);
        if (x >= 0) {
            return this.updatedSlot(x, key, newValue, newVersion);
        }
        x = -(x + 1);
        return this.insertedSlot(x, key, newValue, newVersion);
    }

    BTreeLeaf updatedSlot(int x, Value key, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot oldSlot = oldSlots[x];
        if (!newValue.equals((Object)oldSlot.value())) {
            int n = oldSlots.length;
            Slot[] newSlots = new Slot[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[x] = Slot.of((Value)key, (Value)newValue).commit();
            return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
        }
        return this;
    }

    BTreeLeaf insertedSlot(int x, Value key, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        newSlots[x] = Slot.of((Value)key, (Value)newValue).commit();
        System.arraycopy(oldSlots, x, newSlots, x + 1, n - (x + 1));
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public BTreeLeaf removed(Value key, long newVersion) {
        int x = this.lookup(key);
        if (x >= 0) {
            if (this.slots.length > 1) {
                return this.removedSlot(x, newVersion);
            }
            return BTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    BTreeLeaf removedSlot(int x, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        System.arraycopy(oldSlots, x + 1, newSlots, x, n - x);
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public BTreePage drop(long lower, long newVersion) {
        if (lower > 0L) {
            Slot[] oldSlots = this.slots;
            int k = oldSlots.length;
            if (lower < (long)k) {
                int x = (int)lower;
                int n = k - x;
                Slot[] newSlots = new Slot[n];
                System.arraycopy(oldSlots, x, newSlots, 0, n);
                return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
            }
            return BTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    @Override
    public BTreePage take(long upper, long newVersion) {
        Slot[] oldSlots = this.slots;
        if (upper < (long)oldSlots.length) {
            if (upper > 0L) {
                int n = (int)upper;
                Slot[] newSlots = new Slot[n];
                System.arraycopy(oldSlots, 0, newSlots, 0, n);
                return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
            }
            return BTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    @Override
    public BTreePage balanced(long newVersion) {
        int n = this.slots.length;
        if (n > 1 && this.pageRef.context.pageShouldSplit(this)) {
            int x = n >>> 1;
            return this.split(x, newVersion);
        }
        return this;
    }

    @Override
    public BTreeNode split(int x, long newVersion) {
        BTreePageRef[] newChildRefs = new BTreePageRef[2];
        BTreeLeaf newLeftPage = this.splitLeft(x, newVersion);
        BTreeLeaf newRightPage = this.splitRight(x, newVersion);
        newChildRefs[0] = newLeftPage.pageRef();
        newChildRefs[1] = newRightPage.pageRef();
        Value[] newKnotKeys = new Value[]{newRightPage.minKey()};
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.slots.length, Value.absent(), newChildRefs, newKnotKeys);
    }

    @Override
    public BTreeLeaf splitLeft(int x, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot[] newSlots = new Slot[x];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public BTreeLeaf splitRight(int x, long newVersion) {
        Slot[] oldSlots = this.slots;
        int y = oldSlots.length - x;
        Slot[] newSlots = new Slot[y];
        System.arraycopy(oldSlots, x, newSlots, 0, y);
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public int pageSize() {
        return this.pageRef.pageSize();
    }

    @Override
    public int diffSize() {
        return this.pageRef.diffSize();
    }

    @Override
    public long treeSize() {
        return this.pageRef.treeSize();
    }

    @Override
    void memoizeSize(BTreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        Slot[] slots = this.slots;
        int n = slots.length;
        if (n > 0) {
            ++pageSize;
            pageSize += Recon.sizeOf((Item)slots[0]);
            for (int i = 1; i < n; ++i) {
                ++pageSize;
                pageSize += Recon.sizeOf((Item)slots[i]);
            }
            ++pageSize;
        }
        pageRef.pageSize = ++pageSize;
        pageRef.diffSize = pageSize;
        pageRef.treeSize = pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("bleaf", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        Slot[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            record.add((Item)slots[i]);
        }
        return record;
    }

    @Override
    public BTreeLeaf reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        Slot[] slots = this.slots;
        Value fold = identity;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            fold = (Value)accumulator.combine((Object)fold, (Object)slots[i].value());
        }
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, fold, slots);
    }

    @Override
    public BTreeLeaf evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.fold, this.slots);
        }
        return this;
    }

    @Override
    public BTreeLeaf committed(int zone, long base, long version) {
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, zone, base, this.pageRef.fold, this.slots);
    }

    @Override
    public BTreeLeaf uncommitted(long version) {
        return BTreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.fold, this.slots);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write(output, (Item)this.toHeader());
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        Slot[] slots = this.slots;
        int n = slots.length;
        if (n > 0) {
            output.write(123);
            Recon.write(output, (Item)slots[0]);
            for (int i = 1; i < n; ++i) {
                output.write(44);
                Recon.write(output, (Item)slots[i]);
            }
            output.write(125);
        }
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.writePage(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        builder.add((Object)this);
    }

    @Override
    public BTreePage loadTree(PageLoader pageLoader) {
        return this;
    }

    @Override
    public void soften(long version) {
    }

    @Override
    public OrderedMapCursor<Value, Value> cursor() {
        return new BTreeLeafCursor(this.slots, 0, this.slots.length);
    }

    @Override
    public OrderedMapCursor<Value, Value> depthCursor(int maxDepth) {
        return this.cursor();
    }

    @Override
    public OrderedMapCursor<Value, Value> deltaCursor(long sinceVersion) {
        if (sinceVersion <= this.version) {
            return this.cursor();
        }
        return new BTreeLeafCursor(EMPTY_SLOTS, 0, 0);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Output)output, (Item)this.toHeader());
        this.writePageContent(output);
        return (String)output.bind();
    }

    public static BTreeLeaf create(PageContext context, int stem, long version, int zone, long base, Value fold, Slot[] slots) {
        BTreePageRef pageRef = new BTreePageRef(context, PageType.LEAF, stem, zone, zone, base, slots.length, fold);
        BTreeLeaf page = new BTreeLeaf(pageRef, version, slots);
        pageRef.page = page;
        return page;
    }

    public static BTreeLeaf create(PageContext context, int stem, long version, Value fold, Slot[] slots) {
        return BTreeLeaf.create(context, stem, version, 0, 0L, fold, slots);
    }

    public static BTreeLeaf empty(PageContext context, int stem, long version) {
        return BTreeLeaf.create(context, stem, version, 0, 0L, Value.absent(), EMPTY_SLOTS);
    }

    public static BTreeLeaf fromValue(BTreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("bleaf");
            long version = header.get("v").longValue();
            Record tail = value.tail();
            Object[] slots = new Slot[tail.size()];
            tail.toArray(slots);
            return new BTreeLeaf(pageRef, version, (Slot[])slots);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed bleaf: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

