/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.lang.ref.WeakReference;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.BTreeLeaf;
import swim.db.BTreePage;
import swim.db.BTreePageRefCursor;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.PageType;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.OrderedMapCursor;

public final class BTreePageRef
extends PageRef {
    final PageContext context;
    final PageType pageType;
    final int stem;
    final int post;
    final int zone;
    final long base;
    final long span;
    final Value fold;
    Object page;
    int pageRefSize;
    int pageSize;
    int diffSize;
    long treeSize;

    public BTreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, Value fold, Object page, int pageRefSize, int pageSize, int diffSize, long treeSize) {
        this.context = context;
        this.pageType = pageType;
        this.stem = stem;
        this.post = post;
        this.zone = zone;
        this.base = base;
        this.span = span;
        this.fold = fold;
        this.page = page;
        this.pageRefSize = pageRefSize;
        this.pageSize = pageSize;
        this.diffSize = diffSize;
        this.treeSize = treeSize;
    }

    public BTreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, Value fold, Object page) {
        this(context, pageType, stem, post, zone, base, span, fold, page, -1, -1, -1, -1L);
    }

    public BTreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, Value fold) {
        this(context, pageType, stem, post, zone, base, span, fold, null, -1, -1, -1, -1L);
    }

    @Override
    public PageContext pageContext() {
        return this.context;
    }

    @Override
    public PageType pageType() {
        return this.pageType;
    }

    @Override
    public int stem() {
        return this.stem;
    }

    @Override
    public int post() {
        return this.post;
    }

    @Override
    public int zone() {
        return this.zone;
    }

    @Override
    public long base() {
        return this.base;
    }

    @Override
    public long span() {
        return this.span;
    }

    @Override
    public Value fold() {
        return this.fold;
    }

    @Override
    public BTreePage page() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof BTreePage) {
            this.context.hitPage((BTreePage)page);
            return (BTreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(false);
        try {
            BTreePage bTreePage = (BTreePage)pageLoader.loadPage(this);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return bTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public BTreePage hardPage() {
        Object page = this.page;
        if (page instanceof BTreePage) {
            return (BTreePage)page;
        }
        return null;
    }

    @Override
    public BTreePage softPage() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof BTreePage) {
            return (BTreePage)page;
        }
        return null;
    }

    @Override
    public long softVersion() {
        BTreePage page = this.softPage();
        if (page != null) {
            return page.version();
        }
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.span == 0L;
    }

    @Override
    public boolean isCommitted() {
        return this.zone > 0 && this.base > 0L;
    }

    @Override
    public int pageRefSize() {
        int pageRefSize = this.pageRefSize;
        if (pageRefSize < 0) {
            pageRefSize = 5;
            if (this.post != this.zone) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)Num.from((int)this.post));
            }
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.zone));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.base));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.pageSize()));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.treeSize()));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.span));
            Value fold = this.fold();
            if (fold.isDefined()) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)fold);
            }
            this.pageRefSize = ++pageRefSize;
        }
        return pageRefSize;
    }

    @Override
    public int pageSize() {
        if (this.pageSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.pageSize;
    }

    @Override
    public int diffSize() {
        if (this.diffSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.diffSize;
    }

    @Override
    public long treeSize() {
        if (this.treeSize < 0L) {
            this.page().memoizeSize(this);
        }
        return this.treeSize;
    }

    @Override
    public Value toValue() {
        Record header = Record.create((int)7);
        if (this.post != this.zone) {
            header.slot("post", this.post);
        }
        header.slot("zone", this.zone).slot("base", this.base).slot("size", this.pageSize()).slot("area", this.treeSize()).slot("span", this.span);
        Value fold = this.fold();
        if (fold.isDefined()) {
            header.slot("fold", fold);
        }
        return Record.create((int)1).attr(this.pageType.tag(), (Value)header);
    }

    public BTreePageRef reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        if (!this.fold.isDefined()) {
            return this.page().reduced(identity, accumulator, combiner, newVersion).pageRef();
        }
        return this;
    }

    @Override
    public BTreePageRef evacuated(int post, long version) {
        if (this.post != 0 && this.post < post) {
            BTreePage page = this.page();
            try {
                return page.evacuated(post, version).pageRef();
            }
            catch (Throwable cause) {
                if (Cont.isNonFatal((Throwable)cause)) {
                    throw new StoreException(cause);
                }
                throw new StoreException(this.toDebugString(), cause);
            }
        }
        return this;
    }

    @Override
    public BTreePageRef committed(int zone, long base, long version) {
        BTreePage page = this.hardPage();
        if (page != null) {
            return page.committed(zone, base, version).pageRef();
        }
        return this;
    }

    @Override
    public BTreePageRef uncommitted(long version) {
        BTreePage page = this.hardPage();
        if (page != null && page.version() >= version) {
            return page.uncommitted(version).pageRef();
        }
        return this;
    }

    @Override
    public void writePageRef(Output<?> output) {
        Recon.write(output, (Item)this.toValue());
    }

    @Override
    public void writePage(Output<?> output) {
        this.page().writePage(output);
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.page().writeDiff(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        this.page().buildDiff(builder);
    }

    @Override
    public BTreePage setPageValue(Value value, boolean isResident) {
        try {
            BTreePage page = BTreePage.fromValue(this, value);
            if (isResident) {
                this.page = page;
            } else {
                this.context.hitPage(page);
                this.page = new WeakReference<BTreePage>(page);
            }
            return page;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public BTreePage loadPage(boolean isResident) {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof BTreePage) {
            this.context.hitPage((BTreePage)page);
            return (BTreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(isResident);
        try {
            BTreePage bTreePage = (BTreePage)pageLoader.loadPage(this);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return bTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public BTreePage loadPage(PageLoader pageLoader) {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof BTreePage) {
            this.context.hitPage((BTreePage)page);
            return (BTreePage)page;
        }
        try {
            return (BTreePage)pageLoader.loadPage(this);
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                throw new StoreException(this.toDebugString(), error);
            }
            throw error;
        }
    }

    @Override
    public BTreePage loadTree(boolean isResident) {
        try (PageLoader pageLoader = this.context.openPageLoader(isResident);){
            BTreePage bTreePage = this.loadTree(pageLoader);
            return bTreePage;
        }
    }

    @Override
    public BTreePage loadTree(PageLoader pageLoader) {
        BTreePage page = this.loadPage(pageLoader);
        return page.loadTree(pageLoader);
    }

    @Override
    public void soften(long version) {
        Object page = this.page;
        if (page instanceof BTreePage) {
            if (((BTreePage)page).version() <= version && this.isCommitted()) {
                this.context.hitPage((BTreePage)page);
                this.page = new WeakReference<Object>(page);
            }
            ((BTreePage)page).soften(version);
        }
    }

    public OrderedMapCursor<Value, Value> cursor() {
        return this.page().cursor();
    }

    public OrderedMapCursor<Value, Value> depthCursor(int maxDepth) {
        if (maxDepth > 0) {
            return this.page().depthCursor(maxDepth);
        }
        Value fold = this.fold();
        if (fold instanceof Record) {
            return new BTreePageRefCursor(this, (Record)fold);
        }
        if (fold.isDefined()) {
            return new BTreePageRefCursor(this, Record.of((Object)fold));
        }
        return new BTreePageRefCursor(this, Record.empty());
    }

    public OrderedMapCursor<Value, Value> deltaCursor(long sinceVersion) {
        return this.page().deltaCursor(sinceVersion);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)this.pageRefSize());
        this.writePageRef(output);
        return (String)output.bind();
    }

    public static BTreePageRef empty(PageContext context, int stem, long version) {
        return BTreeLeaf.empty(context, stem, version).pageRef();
    }

    public static BTreePageRef fromValue(PageContext context, int stem, Value value) {
        Throwable cause = null;
        try {
            String tag = value.tag();
            PageType pageType = PageType.fromTag(tag);
            if (pageType == null) {
                return null;
            }
            Value header = value.header(tag);
            int zone = header.get("zone").intValue();
            int post = header.get("post").intValue(zone);
            long base = header.get("base").longValue();
            int size = header.get("size").intValue();
            long area = header.get("area").longValue();
            long span = header.get("span").longValue();
            Value fold = header.get("fold");
            if (base < 0L) {
                throw new StoreException("negative page base: " + base);
            }
            if (size < 0) {
                throw new StoreException("negative page size: " + size);
            }
            if (area < 0L) {
                throw new StoreException("negative page area: " + area);
            }
            if (span < 0L) {
                throw new StoreException("negative page span: " + span);
            }
            return new BTreePageRef(context, pageType, stem, post, zone, base, span, fold, null, -1, size, 0, area);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed btree page ref: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

