/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Iterator;
import java.util.NoSuchElementException;
import swim.db.Database;
import swim.db.MetaLeaf;
import swim.db.MetaTree;
import swim.db.Tree;
import swim.db.TreeType;
import swim.db.Trunk;
import swim.structure.Item;
import swim.structure.Value;
import swim.util.Cursor;

final class DatabaseLeafIterator
implements Iterator<MetaLeaf> {
    final Database database;
    final Iterator<MetaTree> trees;
    Trunk<Tree> trunk;
    Cursor<? extends Object> leafs;

    DatabaseLeafIterator(Database database, Iterator<MetaTree> trees) {
        this.database = database;
        this.trees = trees;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.leafs != null) {
                if (this.leafs.hasNext()) {
                    return true;
                }
                this.trunk = null;
                this.leafs = null;
            }
            if (!this.trees.hasNext()) break;
            MetaTree metaTree = this.trees.next();
            Value name = metaTree.name;
            TreeType type = metaTree.type;
            this.trunk = this.database.openTrunk(name, type, false, false);
            this.leafs = Trunk.TREE.get(this.trunk).cursor();
        }
        return false;
    }

    @Override
    public MetaLeaf next() {
        while (true) {
            TreeType type;
            Value name;
            if (this.leafs != null) {
                if (this.leafs.hasNext()) {
                    Item leaf = (Item)this.leafs.next();
                    name = this.trunk.name;
                    type = Trunk.TREE.get(this.trunk).treeType();
                    Value key = leaf.key();
                    Value value = leaf.toValue();
                    return new MetaLeaf(name, type, key, value);
                }
                this.trunk = null;
                this.leafs = null;
            }
            if (!this.trees.hasNext()) break;
            MetaTree metaTree = this.trees.next();
            name = metaTree.name;
            type = metaTree.type;
            this.trunk = this.database.openTrunk(name, type, false, false);
            this.leafs = Trunk.TREE.get(this.trunk).cursor();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

