/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.QTreePage;
import swim.db.QTreePageRef;
import swim.db.Seed;
import swim.db.StoreException;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeType;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class QTree
extends Tree {
    final TreeContext treeContext;
    final QTreePageRef rootRef;
    final Seed seed;
    final boolean isResident;
    final boolean isTransient;

    public QTree(TreeContext treeContext, QTreePageRef rootRef, Seed seed, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = rootRef;
        this.seed = seed;
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    public QTree(TreeContext treeContext, Seed seed, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = (QTreePageRef)seed.rootRef(treeContext);
        this.seed = seed;
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    public QTree(TreeContext treeContext, int stem, long version, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = QTreePageRef.empty(treeContext, stem, version);
        long time = System.currentTimeMillis();
        this.seed = new Seed(TreeType.QTREE, stem, time, time, this.rootRef.toValue());
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    @Override
    public TreeType treeType() {
        return TreeType.QTREE;
    }

    @Override
    public TreeContext treeContext() {
        return this.treeContext;
    }

    @Override
    public QTreePageRef rootRef() {
        return this.rootRef;
    }

    @Override
    public QTreePage rootPage() {
        try {
            return this.rootRef.page();
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                throw new StoreException(this.seed.toString(), error);
            }
            throw error;
        }
    }

    @Override
    public Seed seed() {
        return this.seed;
    }

    @Override
    public boolean isResident() {
        return this.isResident;
    }

    @Override
    public QTree isResident(boolean isResident) {
        if (this.isResident != isResident) {
            return new QTree(this.treeContext, this.rootRef, this.seed, isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public QTree isTransient(boolean isTransient) {
        if (this.isTransient != isTransient) {
            return new QTree(this.treeContext, this.rootRef, this.seed, this.isResident, isTransient);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.rootRef.isEmpty();
    }

    public boolean containsKey(Value key, long x, long y) {
        return this.rootPage().containsKey(key, x, y);
    }

    public boolean containsKey(Value key) {
        Cursor<Slot> cursor = this.cursor();
        while (cursor.hasNext()) {
            if (!key.equals((Object)((Slot)cursor.next()).key())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Value value) {
        Cursor<Slot> cursor = this.cursor();
        while (cursor.hasNext()) {
            if (!value.equals((Object)((Slot)cursor.next()).toValue())) continue;
            return true;
        }
        return false;
    }

    public Value get(Value key, long x, long y) {
        return this.rootPage().get(key, x, y);
    }

    public Value get(Value key) {
        Cursor<Slot> cursor = this.cursor();
        while (cursor.hasNext()) {
            Slot slot = (Slot)cursor.next();
            if (!key.equals((Object)slot.key())) continue;
            return slot.toValue();
        }
        return Value.absent();
    }

    public QTree updated(Value key, long x, long y, Value newValue, long newVersion, int newPost) {
        QTreePage newRoot;
        QTreePage oldRoot = this.rootPage();
        if (oldRoot != (newRoot = oldRoot.updated(key, x, y, newValue, newVersion).balanced(newVersion).evacuated(newPost, newVersion))) {
            return new QTree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public QTree moved(Value key, long oldX, long oldY, long newX, long newY, Value newValue, long newVersion, int newPost) {
        QTreePage newRoot;
        QTreePage oldRoot = this.rootPage();
        if (oldRoot != (newRoot = oldRoot.removed(key, oldX, oldY, newVersion).balanced(newVersion).updated(key, newX, newY, newValue, newVersion).balanced(newVersion).evacuated(newPost, newVersion))) {
            return new QTree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public QTree removed(Value key, long x, long y, long newVersion, int newPost) {
        QTreePage newRoot;
        QTreePage oldRoot = this.rootPage();
        if (oldRoot != (newRoot = oldRoot.removed(key, x, y, newVersion).balanced(newVersion).evacuated(newPost, newVersion))) {
            return new QTree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public QTree cleared(long newVersion) {
        if (!this.rootRef.isEmpty()) {
            QTreePage newRoot = QTreePage.empty(this.treeContext, this.seed.stem, newVersion);
            return new QTree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public int diffSize(long version) {
        if (version == this.rootRef.softVersion()) {
            return this.rootRef.diffSize();
        }
        return 0;
    }

    @Override
    public long treeSize() {
        return this.rootRef.treeSize();
    }

    public QTree reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion, int newPost) {
        QTreePageRef oldRootRef = this.rootRef;
        QTreePageRef newRootRef = oldRootRef.reduced(identity, accumulator, combiner, newVersion).evacuated(newPost, newVersion);
        if (oldRootRef != newRootRef) {
            return new QTree(this.treeContext, newRootRef, this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public QTree evacuated(int post, long version) {
        QTreePageRef oldRootRef = this.rootRef;
        QTreePageRef newRootRef = oldRootRef.evacuated(post, version);
        if (oldRootRef != newRootRef) {
            return new QTree(this.treeContext, newRootRef, this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public QTree committed(int zone, long base, long version, long time) {
        if (!this.rootRef.isCommitted()) {
            QTreePageRef newRootRef = this.rootRef.committed(zone, base, version);
            Seed newSeed = this.seed.committed(time, newRootRef);
            return new QTree(this.treeContext, newRootRef, newSeed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public QTree uncommitted(long version) {
        QTreePageRef oldRootRef = this.rootRef;
        QTreePageRef newRootRef = oldRootRef.uncommitted(version);
        if (oldRootRef != newRootRef) {
            Seed newSeed = this.seed.uncommitted(newRootRef);
            return new QTree(this.treeContext, newRootRef, newSeed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public void writeDiff(Output<?> output, long version) {
        if (version == this.rootRef.softVersion()) {
            this.rootRef.writeDiff(output);
        }
    }

    @Override
    public void buildDiff(long version, Builder<Page, ?> builder) {
        if (version == this.rootRef.softVersion()) {
            this.rootRef.buildDiff(builder);
        }
    }

    @Override
    public QTree load() {
        this.rootRef.loadTree(this.isResident);
        return this;
    }

    @Override
    public void soften(long version) {
        if (!this.isResident && !this.isTransient) {
            this.rootRef.soften(version);
        }
    }

    public Cursor<Slot> cursor() {
        return this.rootRef.cursor();
    }

    public Cursor<Slot> cursor(long x, long y) {
        return this.rootRef.cursor(x, y);
    }

    public Cursor<Slot> depthCursor(long x, long y, int maxDepth) {
        return this.rootRef.depthCursor(x, y, maxDepth);
    }

    public Cursor<Slot> depthCursor(int maxDepth) {
        return this.rootRef.depthCursor(maxDepth);
    }

    public Cursor<Slot> deltaCursor(long x, long y, long sinceVersion) {
        return this.rootRef.deltaCursor(x, y, sinceVersion);
    }

    public Cursor<Slot> deltaCursor(long sinceVersion) {
        return this.rootRef.deltaCursor(sinceVersion);
    }
}

