/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.QTree;
import swim.db.QTreeEntryCursor;
import swim.db.QTreeShapeCursor;
import swim.db.QTreeValueCursor;
import swim.math.Z2Form;
import swim.spatial.BitInterval;
import swim.spatial.SpatialMap;
import swim.spatial.SpatialValueMap;
import swim.structure.Form;
import swim.structure.Value;
import swim.util.Cursor;

public class QTreeMapView<S>
implements SpatialMap<Value, S, Value> {
    protected final QTree tree;
    protected final Z2Form<S> shapeForm;

    public QTreeMapView(QTree tree, Z2Form<S> shapeForm) {
        this.tree = tree;
        this.shapeForm = shapeForm;
    }

    public QTree getTree() {
        return this.tree;
    }

    public Z2Form<S> shapeForm() {
        return this.shapeForm;
    }

    public QTreeMapView<S> load() {
        this.tree.load();
        return this;
    }

    public boolean isResident() {
        return this.tree.isResident();
    }

    public boolean isTransient() {
        return this.tree.isTransient();
    }

    public <K> SpatialValueMap<K, S, Value> keyForm(Form<K> keyForm) {
        return new SpatialValueMap((SpatialMap)this, keyForm, Form.forValue());
    }

    public <K> SpatialValueMap<K, S, Value> keyClass(Class<K> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public <V> SpatialValueMap<Value, S, V> valueForm(Form<V> valueForm) {
        return new SpatialValueMap((SpatialMap)this, Form.forValue(), valueForm);
    }

    public <V> SpatialValueMap<Value, S, V> valueClass(Class<V> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return (int)this.tree.span();
    }

    public boolean containsKey(Value key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        return this.tree.containsKey(key, x, y);
    }

    public boolean containsKey(Object value) {
        if (value instanceof Value) {
            return this.tree.containsKey((Value)value);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value instanceof Value) {
            return this.tree.containsValue((Value)value);
        }
        return false;
    }

    public Value get(Object key) {
        if (key instanceof Value) {
            return this.tree.get((Value)key).body();
        }
        return Value.absent();
    }

    public Value get(Value key, S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        return this.tree.get(key, x, y).body();
    }

    public Value put(Value key, S shape, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value move(Value key, S oldShape, S newShape, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public Value remove(Value key, S shape) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Cursor<SpatialMap.Entry<Value, S, Value>> iterator(S shape) {
        Z2Form<S> shapeForm = this.shapeForm;
        long x = BitInterval.span((long)shapeForm.getXMin(shape), (long)shapeForm.getXMax(shape));
        long y = BitInterval.span((long)shapeForm.getYMin(shape), (long)shapeForm.getYMax(shape));
        return new QTreeShapeCursor<S>(this.tree.cursor(x, y), shapeForm, shape);
    }

    public Cursor<SpatialMap.Entry<Value, S, Value>> iterator() {
        return new QTreeEntryCursor<S>(this.tree.cursor(), this.shapeForm);
    }

    public Cursor<Value> keyIterator() {
        return Cursor.keys(this.tree.cursor());
    }

    public Cursor<Value> valueIterator() {
        return new QTreeValueCursor(this.tree.cursor());
    }
}

