/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Comparator;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.QTreeLeaf;
import swim.db.QTreeNode;
import swim.db.QTreePageRef;
import swim.db.QTreePageRefOrdering;
import swim.db.QTreeSlotOrdering;
import swim.spatial.BitInterval;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public abstract class QTreePage
extends Page {
    static final Slot[] EMPTY_SLOTS = new Slot[0];
    static final Comparator<QTreePageRef> PAGE_REF_ORDERING = new QTreePageRefOrdering();
    static final Comparator<Slot> SLOT_ORDERING = new QTreeSlotOrdering();

    QTreePage() {
    }

    @Override
    public boolean isQTreePage() {
        return true;
    }

    @Override
    public abstract QTreePageRef pageRef();

    @Override
    public abstract QTreePageRef getChildRef(int var1);

    @Override
    public abstract QTreePage getChild(int var1);

    public long x() {
        return this.pageRef().x();
    }

    public int xRank() {
        return this.pageRef().xRank();
    }

    public long xBase() {
        return this.pageRef().xBase();
    }

    public long xMask() {
        return this.pageRef().xMask();
    }

    public long xSplit() {
        return this.pageRef().xSplit();
    }

    public long y() {
        return this.pageRef().y();
    }

    public int yRank() {
        return this.pageRef().yRank();
    }

    public long yBase() {
        return this.pageRef().yBase();
    }

    public long yMask() {
        return this.pageRef().yMask();
    }

    public long ySplit() {
        return this.pageRef().ySplit();
    }

    public abstract int slotCount();

    public abstract Slot getSlot(int var1);

    public abstract boolean containsKey(Value var1, long var2, long var4);

    public boolean containsKey(Value key, int xkRank, long xkBase, int ykRank, long ykBase) {
        return this.containsKey(key, BitInterval.from((int)xkRank, (long)xkBase), BitInterval.from((int)ykRank, (long)ykBase));
    }

    public abstract Value get(Value var1, long var2, long var4);

    public Value get(Value key, int xkRank, long xkBase, int ykRank, long ykBase) {
        return this.get(key, BitInterval.from((int)xkRank, (long)xkBase), BitInterval.from((int)ykRank, (long)ykBase));
    }

    public Record getAll(long x, long y) {
        Record record = Record.of();
        Cursor<Slot> cursor = this.cursor(x, y);
        while (cursor.hasNext()) {
            record.add((Item)cursor.next());
        }
        return record;
    }

    public Record getAll(long x0, long y0, long x1, long y1) {
        long x = BitInterval.span((long)x0, (long)x1);
        long y = BitInterval.span((long)y0, (long)y1);
        return this.getAll(x, y);
    }

    abstract QTreePage updated(Value var1, long var2, long var4, Value var6, long var7, boolean var9);

    public QTreePage updated(Value key, long xk, long yk, Value newValue, long newVersion) {
        return this.updated(key, xk, yk, newValue, newVersion, true);
    }

    public QTreePage updated(Value key, int xkRank, long xkBase, int ykRank, long ykBase, Value newValue, long newVersion) {
        long xk = BitInterval.from((int)xkRank, (long)xkBase);
        long yk = BitInterval.from((int)ykRank, (long)ykBase);
        return this.updated(key, xk, yk, newValue, newVersion);
    }

    abstract QTreePage insertedPageRef(QTreePageRef var1, long var2);

    abstract QTreePage mergedPage(QTreePage var1, long var2);

    abstract QTreePage mergedSlots(Slot[] var1, long var2);

    abstract QTreePage updatedSlot(Slot var1, long var2);

    public abstract QTreePage removed(Value var1, long var2, long var4, long var6);

    public QTreePage removed(Value key, int xkRank, long xkBase, int ykRank, long ykBase, long newVersion) {
        long xk = BitInterval.from((int)xkRank, (long)xkBase);
        long yk = BitInterval.from((int)ykRank, (long)ykBase);
        return this.removed(key, xk, yk, newVersion);
    }

    public abstract QTreePage flattened(long var1);

    public abstract QTreePage balanced(long var1);

    abstract QTreeNode split(long var1);

    public abstract QTreePage reduced(Value var1, CombinerFunction<? super Value, Value> var2, CombinerFunction<Value, Value> var3, long var4);

    @Override
    public abstract QTreePage evacuated(int var1, long var2);

    @Override
    public abstract QTreePage committed(int var1, long var2, long var4);

    @Override
    public abstract QTreePage uncommitted(long var1);

    abstract void memoizeSize(QTreePageRef var1);

    @Override
    public abstract QTreePage loadTree(PageLoader var1);

    public Cursor<Slot> cursor() {
        return this.cursor(-1L, -1L);
    }

    public abstract Cursor<Slot> cursor(long var1, long var3);

    public abstract Cursor<Slot> depthCursor(long var1, long var3, int var5);

    public Cursor<Slot> depthCursor(int maxDepth) {
        return this.depthCursor(-1L, -1L, maxDepth);
    }

    public abstract Cursor<Slot> deltaCursor(long var1, long var3, long var5);

    public Cursor<Slot> deltaCursor(long sinceVersion) {
        return this.deltaCursor(-1L, -1L, sinceVersion);
    }

    public abstract Cursor<Slot> tileCursor(long var1, long var3);

    public Cursor<Slot> tileCursor() {
        return this.tileCursor(-1L, -1L);
    }

    public static QTreePage empty(PageContext context, int stem, long version) {
        return QTreeLeaf.empty(context, stem, version);
    }

    public static QTreePage fromValue(QTreePageRef pageRef, Value value) {
        switch (pageRef.pageType()) {
            case LEAF: {
                return QTreeLeaf.fromValue(pageRef, value);
            }
            case NODE: {
                return QTreeNode.fromValue(pageRef, value);
            }
        }
        throw new IllegalArgumentException(pageRef.toString());
    }

    static Slot slot(Value key, long xk, long yk, Value value) {
        Record tile = Record.create((int)2).item((Item)Num.uint64((long)xk)).item((Item)Num.uint64((long)yk));
        return Slot.of((Value)key, (Value)Record.create((int)2).attr("tile", (Value)tile).concat((Item)value)).commit();
    }
}

