/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.math.Z2Form;
import swim.spatial.SpatialMap;
import swim.structure.Item;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Cursor;

final class QTreeShapeCursor<S>
implements Cursor<SpatialMap.Entry<Value, S, Value>> {
    final Cursor<Slot> inner;
    final Z2Form<S> shapeForm;
    final S shape;
    Slot nextSlot;
    S nextShape;
    Slot previousSlot;
    S previousShape;

    QTreeShapeCursor(Cursor<Slot> inner, Z2Form<S> shapeForm, S shape) {
        this.inner = inner;
        this.shapeForm = shapeForm;
        this.shape = shape;
    }

    public boolean isEmpty() {
        Slot nextSlot = this.nextSlot;
        Object nextShape = this.nextShape;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (this.inner.hasNext()) {
                nextSlot = (Slot)this.inner.next();
                nextShape = shapeForm.cast((Item)nextSlot.toValue());
                if (!shapeForm.intersects(this.shape, nextShape)) continue;
                this.nextSlot = nextSlot;
                this.nextShape = nextShape;
                return false;
            }
            return true;
        }
        return false;
    }

    public SpatialMap.Entry<Value, S, Value> head() {
        Slot nextSlot = this.nextSlot;
        Object nextShape = this.nextShape;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (!shapeForm.intersects(this.shape, nextShape = shapeForm.cast((Item)(nextSlot = (Slot)this.inner.next()).toValue()))) {
            }
        }
        this.previousSlot = null;
        this.previousShape = null;
        this.nextSlot = nextSlot;
        this.nextShape = nextShape;
        Value nextKey = nextSlot.key();
        Value nextValue = nextSlot.toValue().body();
        return new SpatialMap.SimpleEntry((Object)nextKey, nextShape, (Object)nextValue);
    }

    public void step() {
        Slot nextSlot = this.nextSlot;
        Object nextShape = this.nextShape;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (!shapeForm.intersects(this.shape, nextShape = shapeForm.cast((Item)(nextSlot = (Slot)this.inner.next()).toValue()))) {
            }
        }
        this.previousSlot = nextSlot;
        this.previousShape = nextShape;
        this.nextSlot = null;
        this.nextShape = null;
    }

    public void skip(long count) {
        this.inner.skip(count);
    }

    public boolean hasNext() {
        Slot nextSlot = this.nextSlot;
        Object nextShape = this.nextShape;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (this.inner.hasNext()) {
                nextSlot = (Slot)this.inner.next();
                nextShape = shapeForm.cast((Item)nextSlot.toValue());
                if (!shapeForm.intersects(this.shape, nextShape)) continue;
                this.nextSlot = nextSlot;
                this.nextShape = nextShape;
                return true;
            }
            return false;
        }
        return true;
    }

    public long nextIndexLong() {
        return this.inner.nextIndexLong();
    }

    public int nextIndex() {
        return this.inner.nextIndex();
    }

    public SpatialMap.Entry<Value, S, Value> next() {
        Slot nextSlot = this.nextSlot;
        Object nextShape = this.nextShape;
        if (nextSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (!shapeForm.intersects(this.shape, nextShape = shapeForm.cast((Item)(nextSlot = (Slot)this.inner.next()).toValue()))) {
            }
        }
        this.previousSlot = nextSlot;
        this.previousShape = nextShape;
        this.nextSlot = null;
        this.nextShape = null;
        Value nextKey = nextSlot.key();
        Value nextValue = nextSlot.toValue().body();
        return new SpatialMap.SimpleEntry((Object)nextKey, nextShape, (Object)nextValue);
    }

    public boolean hasPrevious() {
        Slot previousSlot = this.previousSlot;
        Object previousShape = this.previousShape;
        if (previousSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (this.inner.hasPrevious()) {
                previousSlot = (Slot)this.inner.previous();
                previousShape = shapeForm.cast((Item)previousSlot.toValue());
                if (!shapeForm.intersects(this.shape, previousShape)) continue;
                this.previousSlot = previousSlot;
                this.previousShape = previousShape;
                return true;
            }
            return false;
        }
        return true;
    }

    public long previousIndexLong() {
        return this.inner.previousIndexLong();
    }

    public int previousIndex() {
        return this.inner.previousIndex();
    }

    public SpatialMap.Entry<Value, S, Value> previous() {
        Slot previousSlot = this.previousSlot;
        Object previousShape = this.previousShape;
        if (previousSlot == null) {
            Z2Form<S> shapeForm = this.shapeForm;
            while (!shapeForm.intersects(this.shape, previousShape = shapeForm.cast((Item)(previousSlot = (Slot)this.inner.previous()).toValue()))) {
            }
        }
        this.nextSlot = previousSlot;
        this.nextShape = previousShape;
        this.previousSlot = null;
        this.previousShape = null;
        Value previousKey = previousSlot.key();
        Value previousValue = previousSlot.toValue().body();
        return new SpatialMap.SimpleEntry((Object)previousKey, previousShape, (Object)previousValue);
    }

    public void load() {
        this.inner.load();
    }
}

