/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.db.StoreSettingsForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.util.Murmur3;

public class StoreSettings
implements Debug {
    protected final int pageSplitSize;
    protected final int pageCacheSize;
    protected final long minCommitSize;
    protected final long maxCommitSize;
    protected final long minCommitInterval;
    protected final long maxCommitTime;
    protected final long minCompactSize;
    protected final long maxCompactSize;
    protected final long maxCompactTime;
    protected final long maxZoneSize;
    protected final double minZoneFill;
    protected final double minTreeFill;
    protected final int maxRetries;
    protected final int deleteDelay;
    private static int hashSeed;
    private static StoreSettings standard;
    private static Form<StoreSettings> form;

    public StoreSettings(int pageSplitSize, int pageCacheSize, long minCommitSize, long maxCommitSize, long minCommitInterval, long maxCommitTime, long minCompactSize, long maxCompactSize, long maxCompactTime, long maxZoneSize, double minZoneFill, double minTreeFill, int maxRetries, int deleteDelay) {
        this.pageSplitSize = pageSplitSize;
        this.pageCacheSize = pageCacheSize;
        this.minCommitSize = minCommitSize;
        this.maxCommitSize = maxCommitSize;
        this.minCommitInterval = minCommitInterval;
        this.maxCommitTime = maxCommitTime;
        this.minCompactSize = minCompactSize;
        this.maxCompactSize = maxCompactSize;
        this.maxCompactTime = maxCompactTime;
        this.maxZoneSize = maxZoneSize;
        this.minZoneFill = minZoneFill;
        this.minTreeFill = minTreeFill;
        this.maxRetries = maxRetries;
        this.deleteDelay = deleteDelay;
    }

    public final int pageSplitSize() {
        return this.pageSplitSize;
    }

    public StoreSettings pageSplitSize(int pageSplitSize) {
        return this.copy(pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final int pageCacheSize() {
        return this.pageCacheSize;
    }

    public StoreSettings pageCacheSize(int pageCacheSize) {
        return this.copy(this.pageSplitSize, pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long minCommitSize() {
        return this.minCommitSize;
    }

    public StoreSettings minCommitSize(long minCommitSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long maxCommitSize() {
        return this.maxCommitSize;
    }

    public StoreSettings maxCommitSize(long maxCommitSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long minCommitInterval() {
        return this.minCommitInterval;
    }

    public StoreSettings minCommitInterval(long minCommitInterval) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long maxCommitTime() {
        return this.maxCommitTime;
    }

    public StoreSettings maxCommitTime(long maxCommitTime) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long minCompactSize() {
        return this.minCompactSize;
    }

    public StoreSettings minCompactSize(long minCompactSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long maxCompactSize() {
        return this.maxCompactSize;
    }

    public StoreSettings maxCompactSize(long maxCompactSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long maxCompactTime() {
        return this.maxCompactTime;
    }

    public StoreSettings maxCompactTime(long maxCompactTime) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final long maxZoneSize() {
        return this.maxZoneSize;
    }

    public StoreSettings maxZoneSize(long maxZoneSize) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final double minZoneFill() {
        return this.minZoneFill;
    }

    public StoreSettings minZoneFill(double minZoneFill) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, minZoneFill, this.minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final double minTreeFill() {
        return this.minTreeFill;
    }

    public StoreSettings minTreeFill(double minTreeFill) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, minTreeFill, this.maxRetries, this.deleteDelay);
    }

    public final int maxRetries() {
        return this.maxRetries;
    }

    public StoreSettings maxRetries(int maxRetries) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, maxRetries, this.deleteDelay);
    }

    public final int deleteDelay() {
        return this.deleteDelay;
    }

    public StoreSettings deleteDelay(int deleteDelay) {
        return this.copy(this.pageSplitSize, this.pageCacheSize, this.minCommitSize, this.maxCommitSize, this.minCommitInterval, this.maxCommitTime, this.minCompactSize, this.maxCompactSize, this.maxCompactTime, this.maxZoneSize, this.minZoneFill, this.minTreeFill, this.maxRetries, deleteDelay);
    }

    protected StoreSettings copy(int pageSplitSize, int pageCacheSize, long minCommitSize, long maxCommitSize, long minCommitInterval, long maxCommitTime, long minCompactSize, long maxCompactSize, long maxCompactTime, long maxZoneSize, double minZoneFill, double minTreeFill, int maxRetries, int deleteDelay) {
        return new StoreSettings(pageSplitSize, pageCacheSize, minCommitSize, maxCommitSize, minCommitInterval, maxCommitTime, minCompactSize, maxCompactSize, maxCompactTime, maxZoneSize, minZoneFill, minTreeFill, maxRetries, deleteDelay);
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof StoreSettings) {
            StoreSettings that = (StoreSettings)other;
            return that.canEqual(this) && this.pageSplitSize == that.pageSplitSize && this.pageCacheSize == that.pageCacheSize && this.minCommitSize == that.minCommitSize && this.maxCommitSize == that.maxCommitSize && this.minCommitInterval == that.minCommitInterval && this.maxCommitTime == that.maxCommitTime && this.minCompactSize == that.minCompactSize && this.maxCompactSize == that.maxCompactSize && this.maxCompactTime == that.maxCompactTime && this.maxZoneSize == that.maxZoneSize && this.minZoneFill == that.minZoneFill && this.minTreeFill == that.minTreeFill && this.maxRetries == that.maxRetries && this.deleteDelay == that.deleteDelay;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(StoreSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.pageSplitSize), (int)this.pageCacheSize), (int)Murmur3.hash((long)this.minCommitSize)), (int)Murmur3.hash((long)this.maxCommitSize)), (int)Murmur3.hash((long)this.minCommitInterval)), (int)Murmur3.hash((long)this.maxCommitTime)), (int)Murmur3.hash((long)this.minCompactSize)), (int)Murmur3.hash((long)this.maxCompactSize)), (int)Murmur3.hash((long)this.maxCompactTime)), (int)Murmur3.hash((long)this.maxZoneSize)), (int)Murmur3.hash((double)this.minZoneFill)), (int)Murmur3.hash((double)this.minTreeFill)), (int)this.maxRetries), (int)this.deleteDelay));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("StoreSettings").write(46).write("standard").write(40).write(41).write(46).write("pageSplitSize").write(40).debug((Object)this.pageSplitSize).write(41).write(46).write("pageCacheSize").write(40).debug((Object)this.pageCacheSize).write(41).write(46).write("minCommitSize").write(40).debug((Object)this.minCommitSize).write(41).write(46).write("maxCommitSize").write(40).debug((Object)this.maxCommitSize).write(41).write(46).write("minCommitInterval").write(40).debug((Object)this.minCommitInterval).write(41).write(46).write("maxCommitTime").write(40).debug((Object)this.maxCommitTime).write(41).write(46).write("minCompactSize").write(40).debug((Object)this.minCompactSize).write(41).write(46).write("maxCompactSize").write(40).debug((Object)this.maxCompactSize).write(41).write(46).write("maxCompactTime").write(40).debug((Object)this.maxCompactTime).write(41).write(46).write("maxZoneSize").write(40).debug((Object)this.maxZoneSize).write(41).write(46).write("minZoneFill").write(40).debug((Object)this.minZoneFill).write(41).write(46).write("minTreeFill").write(40).debug((Object)this.minTreeFill).write(41).write(46).write("maxRetries").write(40).debug((Object)this.maxRetries).write(41).write(46).write("deleteDelay").write(40).debug((Object)this.deleteDelay).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static StoreSettings standard() {
        if (standard == null) {
            int deleteDelay;
            int maxRetries;
            double minTreeFill;
            double minZoneFill;
            long maxZoneSize;
            long maxCompactTime;
            long maxCompactSize;
            long minCompactSize;
            long maxCommitTime;
            long minCommitInterval;
            long maxCommitSize;
            long minCommitSize;
            int pageCacheSize;
            int pageSplitSize;
            try {
                pageSplitSize = Integer.parseInt(System.getProperty("swim.db.page.split.size"));
            }
            catch (NumberFormatException e) {
                pageSplitSize = 16384;
            }
            try {
                pageCacheSize = Integer.parseInt(System.getProperty("swim.db.page.cache.size"));
            }
            catch (NumberFormatException e) {
                pageCacheSize = 4096;
            }
            try {
                minCommitSize = Long.parseLong(System.getProperty("swim.db.min.commit.size"));
            }
            catch (NumberFormatException e) {
                minCommitSize = 0x400000L;
            }
            try {
                maxCommitSize = Long.parseLong(System.getProperty("swim.db.max.commit.size"));
            }
            catch (NumberFormatException e) {
                maxCommitSize = 0x1000000L;
            }
            try {
                minCommitInterval = Integer.parseInt(System.getProperty("swim.db.min.commit.interval"));
            }
            catch (NumberFormatException e) {
                minCommitInterval = 60000L;
            }
            try {
                maxCommitTime = Integer.parseInt(System.getProperty("swim.db.max.commit.time"));
            }
            catch (NumberFormatException e) {
                maxCommitTime = 5000L;
            }
            try {
                minCompactSize = Long.parseLong(System.getProperty("swim.db.min.compact.size"));
            }
            catch (NumberFormatException e) {
                minCompactSize = 0x400000L;
            }
            try {
                maxCompactSize = Long.parseLong(System.getProperty("swim.db.max.compact.size"));
            }
            catch (NumberFormatException e) {
                maxCompactSize = 0x1000000L;
            }
            try {
                maxCompactTime = Long.parseLong(System.getProperty("swim.db.max.compact.time"));
            }
            catch (NumberFormatException e) {
                maxCompactTime = 5000L;
            }
            try {
                maxZoneSize = Long.parseLong(System.getProperty("swim.db.max.zone.size"));
            }
            catch (NumberFormatException e) {
                maxZoneSize = 0x20000000L;
            }
            try {
                minZoneFill = Double.parseDouble(System.getProperty("swim.db.min.zone.fill"));
            }
            catch (NullPointerException | NumberFormatException e) {
                minZoneFill = 0.5;
            }
            try {
                minTreeFill = Double.parseDouble(System.getProperty("swim.db.min.tree.fill"));
            }
            catch (NullPointerException | NumberFormatException e) {
                minTreeFill = 0.2;
            }
            try {
                maxRetries = Integer.parseInt(System.getProperty("swim.db.max.retries"));
            }
            catch (NumberFormatException e) {
                maxRetries = 2;
            }
            try {
                deleteDelay = Integer.parseInt(System.getProperty("swim.db.delete.delay"));
            }
            catch (NumberFormatException e) {
                deleteDelay = 15000;
            }
            standard = new StoreSettings(pageSplitSize, pageCacheSize, minCommitSize, maxCommitSize, minCommitInterval, maxCommitTime, minCompactSize, maxCompactSize, maxCompactTime, maxZoneSize, minZoneFill, minTreeFill, maxRetries, deleteDelay);
        }
        return standard;
    }

    @Kind
    public static Form<StoreSettings> form() {
        if (form == null) {
            form = new StoreSettingsForm();
        }
        return form;
    }
}

