/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.UTreeLeaf;
import swim.db.UTreePageRef;
import swim.structure.Value;
import swim.util.Cursor;

public abstract class UTreePage
extends Page {
    UTreePage() {
    }

    @Override
    public boolean isUTreePage() {
        return true;
    }

    @Override
    public abstract UTreePageRef pageRef();

    @Override
    public abstract UTreePageRef getChildRef(int var1);

    @Override
    public abstract UTreePage getChild(int var1);

    public abstract Value get();

    public abstract UTreePage updated(Value var1, long var2);

    @Override
    public abstract UTreePage evacuated(int var1, long var2);

    @Override
    public abstract UTreePage committed(int var1, long var2, long var4);

    @Override
    public abstract UTreePage uncommitted(long var1);

    abstract void memoizeSize(UTreePageRef var1);

    @Override
    public abstract UTreePage loadTree(PageLoader var1);

    public abstract Cursor<Value> cursor();

    public static UTreePage empty(PageContext context, int stem, long version) {
        return UTreeLeaf.empty(context, stem, version);
    }

    public static UTreePage fromValue(UTreePageRef pageRef, Value value) {
        switch (pageRef.pageType()) {
            case LEAF: {
                return UTreeLeaf.fromValue(pageRef, value);
            }
        }
        throw new IllegalArgumentException(pageRef.toString());
    }
}

