/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Comparator;
import java.util.Map;
import swim.db.BTree;
import swim.structure.Form;
import swim.structure.Slot;
import swim.structure.Value;
import swim.structure.collections.ValueMap;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class BTreeMapView
implements OrderedMap<Value, Value> {
    protected final BTree tree;

    public BTreeMapView(BTree tree) {
        this.tree = tree;
    }

    public BTree tree() {
        return this.tree;
    }

    public BTreeMapView load() {
        this.tree.load();
        return this;
    }

    public boolean isResident() {
        return this.tree.isResident();
    }

    public boolean isTransient() {
        return this.tree.isTransient();
    }

    public <K> ValueMap<K, Value> keyForm(Form<K> keyForm) {
        return new ValueMap((Map)((Object)this), keyForm, Form.forValue());
    }

    public <K> ValueMap<K, Value> keyClass(Class<K> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public <V> ValueMap<Value, V> valueForm(Form<V> valueForm) {
        return new ValueMap((Map)((Object)this), Form.forValue(), valueForm);
    }

    public <V> ValueMap<Value, V> valueClass(Class<V> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    public int size() {
        return (int)this.tree.span();
    }

    public boolean containsKey(Object key) {
        if (key instanceof Value) {
            return this.tree.containsKey((Value)key);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value instanceof Value) {
            return this.tree.containsValue((Value)value);
        }
        return false;
    }

    public int indexOf(Object key) {
        if (key instanceof Value) {
            return (int)this.tree.indexOf((Value)key);
        }
        throw new IllegalArgumentException(key.toString());
    }

    public Value get(Object key) {
        if (key instanceof Value) {
            return this.tree.get((Value)key);
        }
        return Value.absent();
    }

    public Slot getEntry(Object key) {
        if (key instanceof Value) {
            return this.tree.getEntry((Value)key);
        }
        return null;
    }

    public Slot getIndex(int index) {
        return this.tree.getIndex(index);
    }

    public Slot firstEntry() {
        return this.tree.firstEntry();
    }

    public Value firstKey() {
        return this.tree.firstKey();
    }

    public Value firstValue() {
        return this.tree.firstValue();
    }

    public Slot lastEntry() {
        return this.tree.lastEntry();
    }

    public Value lastKey() {
        return this.tree.lastKey();
    }

    public Value lastValue() {
        return this.tree.lastValue();
    }

    public Slot nextEntry(Value key) {
        return this.tree.nextEntry(key);
    }

    public Value nextKey(Value key) {
        return this.tree.nextKey(key);
    }

    public Value nextValue(Value key) {
        return this.tree.nextValue(key);
    }

    public Slot previousEntry(Value key) {
        return this.tree.previousEntry(key);
    }

    public Value previousKey(Value key) {
        return this.tree.previousKey(key);
    }

    public Value previousValue(Value key) {
        return this.tree.previousValue(key);
    }

    public Value put(Value key, Value newValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends Value, ? extends Value> map) {
        throw new UnsupportedOperationException();
    }

    public Value remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public OrderedMapCursor<Value, Value> iterator() {
        return this.tree.cursor();
    }

    public Cursor<Value> keyIterator() {
        return Cursor.keys(this.tree.cursor());
    }

    public Cursor<Value> valueIterator() {
        return Cursor.values(this.tree.cursor());
    }

    public Cursor<Value> depthValueIterator(int maxDepth) {
        return Cursor.values(this.tree.depthCursor(maxDepth));
    }

    public Comparator<? super Value> comparator() {
        return null;
    }
}

