/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.BTreeLeaf;
import swim.db.BTreeNode;
import swim.db.BTreePageRef;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.CombinerFunction;
import swim.util.OrderedMapCursor;

public abstract class BTreePage
extends Page {
    BTreePage() {
    }

    @Override
    public boolean isBTreePage() {
        return true;
    }

    @Override
    public abstract BTreePageRef pageRef();

    public abstract boolean containsKey(Value var1);

    public abstract boolean containsValue(Value var1);

    public abstract long indexOf(Value var1);

    @Override
    public abstract BTreePageRef getChildRef(int var1);

    @Override
    public abstract BTreePage getChild(int var1);

    public abstract Slot getSlot(int var1);

    public abstract Value getKey(int var1);

    public abstract Value minKey();

    public abstract Value maxKey();

    public abstract Value get(Value var1);

    public abstract Slot getEntry(Value var1);

    public abstract Slot getIndex(long var1);

    public abstract Slot firstEntry(Value var1);

    public abstract Slot firstEntry();

    public abstract Slot lastEntry();

    public abstract Slot nextEntry(Value var1);

    public abstract Slot previousEntry(Value var1);

    public abstract BTreePage updated(Value var1, Value var2, long var3);

    public abstract BTreePage removed(Value var1, long var2);

    public abstract BTreePage drop(long var1, long var3);

    public abstract BTreePage take(long var1, long var3);

    public abstract BTreePage balanced(long var1);

    public abstract BTreeNode split(int var1, long var2);

    public abstract BTreePage splitLeft(int var1, long var2);

    public abstract BTreePage splitRight(int var1, long var2);

    public abstract BTreePage reduced(Value var1, CombinerFunction<? super Value, Value> var2, CombinerFunction<Value, Value> var3, long var4);

    @Override
    public abstract BTreePage evacuated(int var1, long var2);

    @Override
    public abstract BTreePage committed(int var1, long var2, long var4);

    @Override
    public abstract BTreePage uncommitted(long var1);

    abstract void memoizeSize(BTreePageRef var1);

    @Override
    public abstract BTreePage loadTree(PageLoader var1);

    public abstract OrderedMapCursor<Value, Value> cursor();

    public abstract OrderedMapCursor<Value, Value> depthCursor(int var1);

    public abstract OrderedMapCursor<Value, Value> deltaCursor(long var1);

    public static BTreePage empty(PageContext context, int stem, long version) {
        return BTreeLeaf.empty(context, stem, version);
    }

    public static BTreePage fromValue(BTreePageRef pageRef, Value value) {
        switch (pageRef.pageType()) {
            case LEAF: {
                return BTreeLeaf.fromValue(pageRef, value);
            }
            case NODE: {
                return BTreeNode.fromValue(pageRef, value);
            }
        }
        throw new IllegalArgumentException(pageRef.toString());
    }
}

