/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Map;
import java.util.NoSuchElementException;
import swim.db.BTreePageRef;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.OrderedMapCursor;

final class BTreePageRefCursor
implements OrderedMapCursor<Value, Value> {
    final BTreePageRef pageRef;
    final Record record;
    int index;

    BTreePageRefCursor(BTreePageRef pageRef, Record record, int index) {
        this.pageRef = pageRef;
        this.record = record;
        this.index = index;
    }

    BTreePageRefCursor(BTreePageRef pageRef, Record record) {
        this(pageRef, record, 0);
    }

    public boolean isEmpty() {
        return this.index >= this.record.size();
    }

    public Map.Entry<Value, Value> head() {
        int index = this.index;
        Record record = this.record;
        if (index >= record.size()) {
            throw new NoSuchElementException();
        }
        Item item = record.get(index);
        if (item instanceof Slot) {
            return (Slot)item;
        }
        return Slot.of((Value)item.key(), (Value)item.toValue());
    }

    public void step() {
        int index = this.index;
        Record record = this.record;
        if (index >= record.size()) {
            throw new UnsupportedOperationException();
        }
        this.index = index + 1;
    }

    public void skip(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        this.index = Math.min(this.index + (int)count, this.record.size());
    }

    public boolean hasNext() {
        return this.index < this.record.size();
    }

    public long nextIndexLong() {
        return this.nextIndex();
    }

    public int nextIndex() {
        return this.index;
    }

    public Value nextKey() {
        int index = this.index;
        Record record = this.record;
        if (index >= record.size()) {
            throw new NoSuchElementException();
        }
        return record.get(index).key();
    }

    public Map.Entry<Value, Value> next() {
        int index = this.index;
        Record record = this.record;
        if (index >= record.size()) {
            throw new NoSuchElementException();
        }
        Item item = record.get(index);
        this.index = index + 1;
        if (item instanceof Slot) {
            return (Slot)item;
        }
        return Slot.of((Value)item.key(), (Value)item.toValue());
    }

    public boolean hasPrevious() {
        return this.index >= 0;
    }

    public long previousIndexLong() {
        return this.previousIndex();
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public Value previousKey() {
        int index = this.index - 1;
        if (index < 0) {
            throw new NoSuchElementException();
        }
        return this.record.get(index).key();
    }

    public Map.Entry<Value, Value> previous() {
        int index = this.index - 1;
        if (index < 0) {
            throw new NoSuchElementException();
        }
        Item item = this.record.get(index);
        this.index = index;
        if (item instanceof Slot) {
            return (Slot)item;
        }
        return Slot.of((Value)item.key(), (Value)item.toValue());
    }
}

