/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import swim.codec.Binary;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.db.Commit;
import swim.db.Database;
import swim.db.Germ;
import swim.db.Page;
import swim.db.StoreException;
import swim.db.Tree;

public class Chunk {
    final Database database;
    final Commit commit;
    final int post;
    final int zone;
    final Germ germ;
    final long size;
    final FingerTrieSeq<Tree> trees;
    final FingerTrieSeq<Page> pages;

    public Chunk(Database database, Commit commit, int post, int zone, Germ germ, long size, FingerTrieSeq<Tree> trees, FingerTrieSeq<Page> pages) {
        this.database = database;
        this.commit = commit;
        this.post = post;
        this.zone = zone;
        this.germ = germ;
        this.size = size;
        this.trees = trees;
        this.pages = pages;
    }

    public final Database database() {
        return this.database;
    }

    public final Commit commit() {
        return this.commit;
    }

    public final int post() {
        return this.post;
    }

    public final int zone() {
        return this.zone;
    }

    public final Germ germ() {
        return this.germ;
    }

    public final long size() {
        return this.size;
    }

    public final FingerTrieSeq<Tree> trees() {
        return this.trees;
    }

    public final FingerTrieSeq<Page> pages() {
        return this.pages;
    }

    public void soften() {
        long version = this.germ.version();
        for (Tree tree : this.trees) {
            tree.soften(version);
        }
    }

    public void write(WritableByteChannel channel) {
        try {
            FingerTrieSeq<Page> pages = this.pages;
            for (int i = 0; i < pages.size(); ++i) {
                Page page = (Page)pages.get(i);
                int pageSize = page.pageSize();
                OutputBuffer output = Binary.outputBuffer((byte[])new byte[pageSize]);
                Output encoder = Utf8.encodedOutput((Output)output);
                page.writePage(encoder);
                ByteBuffer pageBuffer = (ByteBuffer)output.bind();
                if (pageBuffer.remaining() != pageSize) {
                    throw new StoreException("serialized page size of " + pageBuffer.remaining() + " bytes does not match expected page size of " + pageSize + " bytes");
                }
                do {
                    channel.write(pageBuffer);
                } while (pageBuffer.hasRemaining());
                if (!pageBuffer.hasRemaining()) continue;
                throw new StoreException("wrote incomplete chunk");
            }
        }
        catch (IOException cause) {
            throw new StoreException(cause);
        }
    }
}

