/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.FingerTrieSeq;
import swim.collections.HashTrieMap;
import swim.concurrent.Cont;
import swim.concurrent.Stage;
import swim.concurrent.Sync;
import swim.db.BTree;
import swim.db.BTreeMap;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.DatabaseDelegate;
import swim.db.DatabaseLeafIterator;
import swim.db.DatabaseTreeIterator;
import swim.db.Germ;
import swim.db.MetaLeaf;
import swim.db.MetaTree;
import swim.db.Page;
import swim.db.QTree;
import swim.db.QTreeMap;
import swim.db.STree;
import swim.db.STreeList;
import swim.db.Seed;
import swim.db.Store;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeType;
import swim.db.Trunk;
import swim.db.UTree;
import swim.db.UTreeValue;
import swim.math.Z2Form;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Text;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Cursor;
import swim.util.Murmur3;
import swim.util.OrderedMapCursor;

public class Database {
    final Store store;
    volatile DatabaseDelegate delegate;
    volatile Germ germ;
    volatile int stem;
    volatile int post;
    int stablePost;
    volatile long version;
    volatile long diffSize;
    volatile long treeSize;
    final Trunk<BTree> metaTrunk;
    final Trunk<BTree> seedTrunk;
    volatile HashTrieMap<Value, Trunk<Tree>> trunks;
    volatile HashTrieMap<Value, Trunk<Tree>> sprouts;
    Value commitKey;
    Value evacuateKey;
    int evacuationPass;
    volatile int status;
    static final int INITIAL_STATE = 0;
    static final int OPENING_STATE = 1;
    static final int OPENED_STATE = 2;
    static final int CLOSING_STATE = 3;
    static final int CLOSED_STATE = 4;
    static final int STATE_BITS = 3;
    static final int STATE_MASK = 7;
    static final AtomicIntegerFieldUpdater<Database> STEM = AtomicIntegerFieldUpdater.newUpdater(Database.class, "stem");
    static final AtomicLongFieldUpdater<Database> VERSION = AtomicLongFieldUpdater.newUpdater(Database.class, "version");
    static final AtomicIntegerFieldUpdater<Database> POST = AtomicIntegerFieldUpdater.newUpdater(Database.class, "post");
    static final AtomicLongFieldUpdater<Database> DIFF_SIZE = AtomicLongFieldUpdater.newUpdater(Database.class, "diffSize");
    static final AtomicLongFieldUpdater<Database> TREE_SIZE = AtomicLongFieldUpdater.newUpdater(Database.class, "treeSize");
    static final AtomicIntegerFieldUpdater<Database> STATUS = AtomicIntegerFieldUpdater.newUpdater(Database.class, "status");
    static final AtomicReferenceFieldUpdater<Database, HashTrieMap<Value, Trunk<Tree>>> TRUNKS = AtomicReferenceFieldUpdater.newUpdater(Database.class, HashTrieMap.class, "trunks");
    static final AtomicReferenceFieldUpdater<Database, HashTrieMap<Value, Trunk<Tree>>> SPROUTS = AtomicReferenceFieldUpdater.newUpdater(Database.class, HashTrieMap.class, "sprouts");

    Database(Store store, int stem, long version) {
        this.store = store;
        this.stem = stem;
        this.stablePost = this.post = store.oldestZoneId();
        this.version = version;
        this.metaTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("meta"), null);
        this.metaTrunk.tree = new BTree(this.metaTrunk, 0, version, true, false);
        this.seedTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("seed"), null);
        this.seedTrunk.tree = new BTree(this.seedTrunk, 1, version, true, false);
        this.trunks = HashTrieMap.empty();
        this.sprouts = HashTrieMap.empty();
        long time = System.currentTimeMillis();
        this.germ = new Germ(stem, version, time, time, ((BTree)this.seedTrunk.tree).rootRef().toValue());
    }

    Database(Store store, Germ germ) {
        this.store = store;
        this.germ = germ;
        this.stem = germ.stem();
        this.stablePost = this.post = store.oldestZoneId();
        this.version = germ.version() + 1L;
        this.metaTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("meta"), null);
        this.metaTrunk.tree = new BTree(this.metaTrunk, 0, this.version, true, false);
        this.seedTrunk = new Trunk<Object>(this, (Value)Record.create((int)1).attr("seed"), null);
        this.seedTrunk.tree = new BTree(this.seedTrunk, germ.seed(), true, false);
        this.trunks = HashTrieMap.empty();
        this.sprouts = HashTrieMap.empty();
    }

    Database(Store store) {
        this(store, 10, 1L);
    }

    public Store store() {
        return this.store;
    }

    public StoreSettings settings() {
        return this.store.settings();
    }

    public Stage stage() {
        return this.store.stage();
    }

    public DatabaseDelegate databaseDelegate() {
        return this.delegate;
    }

    public void setDatabaseDelegate(DatabaseDelegate delegate) {
        this.delegate = delegate;
    }

    public Germ germ() {
        return this.germ;
    }

    public int stem() {
        return this.stem;
    }

    public int post() {
        return this.post;
    }

    public long version() {
        return this.version;
    }

    public long diffSize() {
        return DIFF_SIZE.get(this);
    }

    public long treeSize() {
        return this.treeSize;
    }

    public long treeCount() {
        return Trunk.TREE.get(this.seedTrunk).span();
    }

    public int trunkCount() {
        return this.trunks.size();
    }

    public boolean isCompacting() {
        return this.evacuationPass != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open() {
        StoreException error;
        boolean interrupted;
        boolean opened;
        block35: {
            int status = STATUS.get(this);
            int state = status & 7;
            opened = false;
            interrupted = false;
            error = null;
            while (true) {
                if (state == 2) {
                    if (!opened) break block35;
                    try {
                        this.didOpen();
                    }
                    catch (Throwable cause2) {
                        if (!Cont.isNonFatal((Throwable)cause2)) {
                            throw cause2;
                        }
                        if (error == null) {
                            error = new StoreException("lifecycle callback failure", cause2);
                        }
                        break block35;
                    }
                }
                if (state == 1) {
                    int newStatus;
                    int oldStatus;
                    Database cause2;
                    block36: {
                        if (!opened) {
                            Database cause2 = this;
                            synchronized (cause2) {
                            }
                        } else {
                            try {
                                this.onOpen();
                                cause2 = this;
                                break block36;
                            }
                            catch (Throwable cause3) {
                                try {
                                    if (!Cont.isNonFatal((Throwable)cause3)) {
                                        throw cause3;
                                    }
                                    if (error == null) {
                                        error = new StoreException("lifecycle callback failure", cause3);
                                    }
                                    cause2 = this;
                                }
                                catch (Throwable throwable) {
                                    Database database = this;
                                    synchronized (database) {
                                        int newStatus2;
                                        int oldStatus2;
                                        while ((state = (status = STATUS.compareAndSet(this, oldStatus2 = status, newStatus2 = oldStatus2 & 0xFFFFFFF8 | 2) ? oldStatus2 : STATUS.get(this)) & 7) != oldStatus2) {
                                        }
                                        this.notifyAll();
                                        throw throwable;
                                    }
                                }
                                synchronized (cause2) {
                                    while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 2) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                                    }
                                    this.notifyAll();
                                    continue;
                                }
                            }
                        }
                        {
                            while ((state = (status = STATUS.get(this)) & 7) == 1) {
                                try {
                                    this.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                            }
                            continue;
                        }
                    }
                    synchronized (cause2) {
                        while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 2) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                        }
                        this.notifyAll();
                        continue;
                    }
                }
                if (state != 0) break;
                int oldStatus = status;
                int newStatus = oldStatus & 0xFFFFFFF8 | 1;
                status = STATUS.compareAndSet(this, oldStatus, newStatus) ? oldStatus : STATUS.get(this);
                state = status & 7;
                if (status != oldStatus) continue;
                opened = true;
                try {
                    this.willOpen();
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    error = new StoreException("lifecycle callback failure", cause);
                }
            }
            if (state != 3 && state != 4) {
                throw new AssertionError((Object)Integer.toString(state));
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error != null) {
            this.close();
            throw error;
        }
        return opened;
    }

    protected void willOpen() {
        this.store.databaseWillOpen(this);
    }

    protected void onOpen() {
        BTree seedTree = (BTree)Trunk.TREE.get(this.seedTrunk);
        seedTree.load();
        long treeSize = 0L;
        OrderedMapCursor<Value, Value> seedCursor = seedTree.cursor();
        while (seedCursor.hasNext()) {
            Value seedValue = (Value)((Map.Entry)seedCursor.next()).getValue();
            Value sizeValue = seedValue.get("root").head().toValue().get("area");
            treeSize += sizeValue.longValue(0L);
        }
        TREE_SIZE.set(this, treeSize);
    }

    protected void didOpen() {
        this.store.databaseDidOpen(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        StoreException error;
        boolean interrupted;
        boolean closed;
        block39: {
            int status = STATUS.get(this);
            int state = status & 7;
            closed = false;
            interrupted = false;
            error = null;
            while (true) {
                if (state == 4) {
                    if (!closed) break block39;
                    try {
                        this.didClose();
                        break block39;
                    }
                    catch (Throwable cause) {
                        if (Cont.isNonFatal((Throwable)cause)) {
                            if (error == null) {
                                error = new StoreException("lifecycle callback failure", cause);
                            }
                            break block39;
                        }
                        throw cause;
                    }
                }
                if (state == 3 || state == 1) {
                    int newStatus;
                    int oldStatus;
                    Database database;
                    int oldState = state;
                    if (!closed) {
                        Database database2 = this;
                        synchronized (database2) {
                            while ((state = (status = STATUS.get(this)) & 7) == oldState) {
                                try {
                                    this.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                            }
                        }
                    }
                    try {
                        this.onClose();
                        database = this;
                    }
                    catch (Throwable cause2) {
                        Database cause2;
                        try {
                            if (Cont.isNonFatal((Throwable)cause2)) {
                                if (error == null) {
                                    error = new StoreException("lifecycle callback failure", cause2);
                                }
                            } else {
                                throw cause2;
                            }
                            cause2 = this;
                        }
                        catch (Throwable throwable) {
                            Database database3 = this;
                            synchronized (database3) {
                                int newStatus2;
                                int oldStatus2;
                                while ((state = (status = STATUS.compareAndSet(this, oldStatus2 = status, newStatus2 = oldStatus2 & 0xFFFFFFF8 | 4) ? oldStatus2 : STATUS.get(this)) & 7) != oldStatus2) {
                                }
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (cause2) {
                            while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 4) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                            }
                            this.notifyAll();
                            continue;
                        }
                    }
                    synchronized (database) {
                        while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 4) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                        }
                        this.notifyAll();
                    }
                }
                if (state == 2) {
                    int oldStatus = status;
                    int newStatus = oldStatus & 0xFFFFFFF8 | 3;
                    status = STATUS.compareAndSet(this, oldStatus, newStatus) ? oldStatus : STATUS.get(this);
                    state = status & 7;
                    if (status != oldStatus) continue;
                    closed = true;
                    try {
                        this.willClose();
                    }
                    catch (Throwable cause) {
                        if (Cont.isNonFatal((Throwable)cause)) {
                            error = new StoreException("lifecycle callback failure", cause);
                        }
                        throw cause;
                    }
                }
                if (state != 0) break;
                this.open();
            }
            throw new AssertionError((Object)Integer.toString(state));
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error != null) {
            throw error;
        }
        return closed;
    }

    protected void willClose() {
    }

    protected void onClose() {
    }

    protected void didClose() {
        this.store.databaseDidClose(this);
    }

    public <T extends Tree> Trunk<T> openTrunk(Value name, TreeType treeType, boolean isResident, boolean isTransient) {
        HashTrieMap<Value, Trunk<Tree>> oldTrunks;
        Trunk oldTrunk;
        Trunk<Object> newTrunk = null;
        boolean created = false;
        while ((oldTrunk = (Trunk)(oldTrunks = this.trunks).get((Object)name)) == null) {
            HashTrieMap newTrunks;
            if (newTrunk == null) {
                Seed seed = Seed.fromValue(((BTree)Trunk.TREE.get(this.seedTrunk)).get(name));
                newTrunk = new Trunk<Object>(this, name, null);
                if (seed != null) {
                    newTrunk.tree = seed.treeType().treeFromSeed(newTrunk, seed, isResident, isTransient);
                } else if (treeType != null) {
                    int stem = STEM.getAndIncrement(this);
                    newTrunk.tree = treeType.emptyTree(newTrunk, stem, this.version, isResident, isTransient);
                    created = true;
                } else {
                    return null;
                }
            }
            if (!TRUNKS.compareAndSet(this, oldTrunks, (HashTrieMap<Value, Trunk<Tree>>)(newTrunks = oldTrunks.updated((Object)name, newTrunk)))) continue;
            if (created) {
                this.databaseDidCreateTrunk(newTrunk);
            }
            this.databaseDidOpenTrunk(newTrunk);
            return newTrunk;
        }
        return oldTrunk;
    }

    public Trunk<BTree> openBTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.BTREE, isResident, isTransient);
    }

    public BTreeMap openBTreeMap(Value name, boolean isResident, boolean isTransient) {
        return new BTreeMap(this.openBTreeTrunk(name, isResident, isTransient));
    }

    public BTreeMap openBTreeMap(Value name) {
        return new BTreeMap(this.openBTreeTrunk(name, false, false));
    }

    public BTreeMap openBTreeMap(String name) {
        return new BTreeMap(this.openBTreeTrunk((Value)Text.from((String)name), false, false));
    }

    public Trunk<QTree> openQTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.QTREE, isResident, isTransient);
    }

    public <S> QTreeMap<S> openQTreeMap(Value name, Z2Form<S> shapeForm, boolean isResident, boolean isTransient) {
        return new QTreeMap<S>(this.openQTreeTrunk(name, isResident, isTransient), shapeForm);
    }

    public <S> QTreeMap<S> openQTreeMap(Value name, Z2Form<S> shapeForm) {
        return new QTreeMap<S>(this.openQTreeTrunk(name, false, false), shapeForm);
    }

    public <S> QTreeMap<S> openQTreeMap(String name, Z2Form<S> shapeForm) {
        return new QTreeMap<S>(this.openQTreeTrunk((Value)Text.from((String)name), false, false), shapeForm);
    }

    public Trunk<STree> openSTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.STREE, isResident, isTransient);
    }

    public STreeList openSTreeList(Value name, boolean isResident, boolean isTransient) {
        return new STreeList(this.openSTreeTrunk(name, isResident, isTransient));
    }

    public STreeList openSTreeList(Value name) {
        return new STreeList(this.openSTreeTrunk(name, false, false));
    }

    public STreeList openSTreeList(String name) {
        return new STreeList(this.openSTreeTrunk((Value)Text.from((String)name), false, false));
    }

    private Trunk<UTree> openUTreeTrunk(Value name, boolean isResident, boolean isTransient) {
        return this.openTrunk(name, TreeType.UTREE, isResident, isTransient);
    }

    public UTreeValue openUTreeValue(Value name) {
        return new UTreeValue(this.openUTreeTrunk(name, false, false));
    }

    public UTreeValue openUTreeValue(String name) {
        return new UTreeValue(this.openUTreeTrunk((Value)Text.from((String)name), false, false));
    }

    public Trunk<Tree> closeTrunk(Value name) {
        HashTrieMap newTrunks;
        HashTrieMap<Value, Trunk<Tree>> oldTrunks;
        while (!TRUNKS.compareAndSet(this, oldTrunks = this.trunks, (HashTrieMap<Value, Trunk<Tree>>)(newTrunks = oldTrunks.removed((Object)name)))) {
        }
        Trunk oldTrunk = (Trunk)oldTrunks.get((Object)name);
        if (oldTrunk != null) {
            this.databaseDidCloseTrunk(oldTrunk);
        }
        return oldTrunk;
    }

    public void removeTree(Value name) {
        block3: {
            BTree newSeedTree;
            BTree oldSeedTree;
            HashTrieMap newSprouts;
            HashTrieMap<Value, Trunk<Tree>> oldSprouts;
            Trunk<Tree> oldTrunk = this.closeTrunk(name);
            while (!SPROUTS.compareAndSet(this, oldSprouts = SPROUTS.get(this), (HashTrieMap<Value, Trunk<Tree>>)(newSprouts = oldSprouts.removed((Object)name)))) {
            }
            if (oldTrunk != null) {
                int oldDiffSize = Trunk.DIFF_SIZE.getAndSet(oldTrunk, 0);
                DIFF_SIZE.addAndGet(this, -((long)oldDiffSize));
            }
            do {
                long newVersion = this.version;
                oldSeedTree = (BTree)Trunk.TREE.get(this.seedTrunk);
                if (oldSeedTree == (newSeedTree = oldSeedTree.removed(name, newVersion, this.post))) break block3;
            } while (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree, newSeedTree));
            Value seedValue = oldSeedTree.get(name);
            Value sizeValue = seedValue.get("root").head().toValue().get("area");
            long treeSize = sizeValue.longValue(0L);
            TREE_SIZE.addAndGet(this, -treeSize);
        }
    }

    public void commitAsync(Commit commit) {
        try {
            if (DIFF_SIZE.get(this) > 0L) {
                this.store.commitAsync(commit);
            } else {
                commit.bind(null);
            }
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        if (DIFF_SIZE.get(this) > 0L) {
            Sync syncChunk = new Sync();
            this.commitAsync(commit.andThen((Cont<Chunk>)syncChunk));
            return (Chunk)syncChunk.await();
        }
        return null;
    }

    public void shiftZone() {
        this.store.shiftZone();
    }

    public Chunk commitChunk(Commit commit, int zone, long base) {
        Germ germ;
        BTree metaTree;
        BTree oldMetaTree;
        int newPost;
        BTree newMetaTree;
        BTree oldMetaTree2;
        BTree seedTree;
        BTree oldSeedTree;
        int newPost2;
        BTree newSeedTree;
        BTree oldSeedTree2;
        long version = VERSION.getAndIncrement(this);
        long time = System.currentTimeMillis();
        int post = this.post;
        Builder treeBuilder = FingerTrieSeq.builder();
        Builder pageBuilder = FingerTrieSeq.builder();
        long step = base;
        if (this.evacuationPass == 0 && post < zone) {
            long treeSize = this.treeSize;
            long storeSize = this.store.size();
            double treeFill = (double)treeSize / (double)storeSize;
            if (storeSize > this.settings().minCompactSize && treeFill < this.settings().minTreeFill) {
                post = zone;
                this.evacuateKey = null;
                this.evacuationPass = 1;
                this.post = post;
                this.databaseWillCompact(post);
                this.store.databaseWillCompact(this, post);
            }
        }
        Value startCommitKey = this.commitKey;
        int startCommitKeyHash = Murmur3.hash((Object)startCommitKey);
        boolean commitKeyRollover = false;
        Value prevCommitKey = startCommitKey;
        block0: do {
            Tree newTree;
            Tree oldTree;
            Trunk nextTrunk;
            block17: {
                boolean rollover;
                Value nextCommitKey;
                HashTrieMap newSprouts;
                HashTrieMap<Value, Trunk<Tree>> oldSprouts;
                nextTrunk = null;
                do {
                    int nextKeyHash;
                    oldSprouts = SPROUTS.get(this);
                    nextCommitKey = (Value)oldSprouts.nextKey((Object)prevCommitKey);
                    rollover = commitKeyRollover;
                    if (nextCommitKey == null) {
                        rollover = true;
                        nextCommitKey = (Value)oldSprouts.nextKey(null);
                    }
                    if (nextCommitKey == null || rollover && HashTrieMap.compareKeyHashes((int)startCommitKeyHash, (int)(nextKeyHash = Murmur3.hash((Object)nextCommitKey))) <= 0) break block17;
                    nextTrunk = (Trunk)oldSprouts.get((Object)nextCommitKey);
                } while (!SPROUTS.compareAndSet(this, oldSprouts, (HashTrieMap<Value, Trunk<Tree>>)(newSprouts = oldSprouts.removed((Object)nextCommitKey))));
                this.commitKey = nextCommitKey;
                prevCommitKey = nextCommitKey;
                commitKeyRollover = rollover;
            }
            if (nextTrunk == null) break;
            while ((oldTree = Trunk.TREE.get(nextTrunk)) != (newTree = oldTree.committed(zone, step, version, time))) {
                BTree newSeedTree2;
                BTree oldSeedTree3;
                if (!Trunk.TREE.compareAndSet(nextTrunk, oldTree, newTree)) continue;
                DIFF_SIZE.addAndGet(this, -((long)Trunk.DIFF_SIZE.getAndSet(nextTrunk, 0)));
                while (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree3 = (BTree)Trunk.TREE.get(this.seedTrunk), newSeedTree2 = oldSeedTree3.updated(nextTrunk.name, newTree.seed().toValue(), version, post))) {
                }
                treeBuilder.add((Object)newTree);
                newTree.buildDiff(version, pageBuilder);
                TREE_SIZE.addAndGet(this, newTree.treeSize() - oldTree.treeSize());
                newTree.treeContext().treeDidCommit(newTree, oldTree);
                step += (long)newTree.diffSize(version);
                continue block0;
            }
        } while (step - base <= this.settings().maxCommitSize && System.currentTimeMillis() - time <= this.settings().maxCommitTime);
        if (this.evacuationPass != 0) {
            long startEvacuationBase = base;
            long startEvacuationTime = System.currentTimeMillis();
            block4: do {
                int newPost3;
                Tree newTree;
                Tree oldTree;
                Value nextEvacuateKey;
                BTree seedTree2 = (BTree)Trunk.TREE.get(this.seedTrunk);
                this.evacuateKey = nextEvacuateKey = seedTree2.nextKey(this.evacuateKey);
                if (nextEvacuateKey == null) {
                    ++this.evacuationPass;
                    if (this.evacuationPass <= 2) break;
                    this.stablePost = post;
                    this.evacuationPass = 0;
                    this.databaseDidCompact(post);
                    this.store.databaseDidCompact(this, post);
                    break;
                }
                Value seedValue = seedTree2.get(nextEvacuateKey);
                Seed seed = Seed.fromValue(seedValue);
                Trunk<Object> trunk = new Trunk<Object>(this, nextEvacuateKey, null);
                Tree tree = seed.treeType().treeFromSeed(trunk, seed, false, false);
                trunk.tree = tree;
                int treePost = tree.rootRef().post();
                if (treePost == 0 || treePost >= post) continue;
                trunk = this.openTrunk(nextEvacuateKey, null, false, false);
                tree = trunk.tree;
                while ((oldTree = Trunk.TREE.get(trunk)) != (newTree = oldTree.evacuated(post, version)) && (!Trunk.TREE.compareAndSet(trunk, oldTree, newTree) || (newPost3 = newTree.post()) != 0 && newPost3 < post)) {
                }
                while ((oldTree = Trunk.TREE.get(trunk)) != (newTree = oldTree.committed(zone, step, version, time))) {
                    BTree newSeedTree3;
                    BTree oldSeedTree4;
                    if (!Trunk.TREE.compareAndSet(trunk, oldTree, newTree)) continue;
                    DIFF_SIZE.addAndGet(this, -((long)Trunk.DIFF_SIZE.getAndSet(trunk, 0)));
                    while (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree4 = (BTree)Trunk.TREE.get(this.seedTrunk), newSeedTree3 = oldSeedTree4.updated(trunk.name, newTree.seed().toValue(), version, post))) {
                    }
                    treeBuilder.add((Object)newTree);
                    newTree.buildDiff(version, pageBuilder);
                    TREE_SIZE.addAndGet(this, newTree.treeSize() - oldTree.treeSize());
                    newTree.treeContext().treeDidCommit(newTree, oldTree);
                    step += (long)newTree.diffSize(version);
                    continue block4;
                }
            } while (step - startEvacuationBase <= this.settings().maxCompactSize && System.currentTimeMillis() - startEvacuationTime <= this.settings().maxCompactTime);
        }
        while ((oldSeedTree2 = (BTree)Trunk.TREE.get(this.seedTrunk)) != (newSeedTree = oldSeedTree2.evacuated(post, version)) && (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree2, newSeedTree) || (newPost2 = newSeedTree.post()) != 0 && newPost2 < post)) {
        }
        while ((oldSeedTree = (BTree)Trunk.TREE.get(this.seedTrunk)) != (seedTree = oldSeedTree.committed(zone, step, version, time))) {
            if (!Trunk.TREE.compareAndSet(this.seedTrunk, oldSeedTree, seedTree)) continue;
            seedTree.buildDiff(version, pageBuilder);
            step += (long)seedTree.diffSize(version);
            break;
        }
        while ((oldMetaTree2 = (BTree)Trunk.TREE.get(this.seedTrunk)) != (newMetaTree = oldMetaTree2.evacuated(post, version)) && (!Trunk.TREE.compareAndSet(this.seedTrunk, oldMetaTree2, newMetaTree) || (newPost = newMetaTree.post()) != 0 && newPost < post)) {
        }
        while ((oldMetaTree = (BTree)Trunk.TREE.get(this.metaTrunk)) != (metaTree = oldMetaTree.updated((Value)Text.from((String)"seed"), seedTree.rootRef().toValue(), version, post).updated((Value)Text.from((String)"stem"), (Value)Num.from((int)this.stem), version, post).updated((Value)Text.from((String)"time"), (Value)Num.from((long)time), version, post).committed(zone, step, version, time))) {
            if (!Trunk.TREE.compareAndSet(this.metaTrunk, oldMetaTree, metaTree)) continue;
            metaTree.buildDiff(version, pageBuilder);
            step += (long)metaTree.diffSize(version);
            break;
        }
        long size = step - base;
        FingerTrieSeq trees = (FingerTrieSeq)treeBuilder.bind();
        FingerTrieSeq pages = (FingerTrieSeq)pageBuilder.bind();
        this.germ = germ = new Germ(this.stem, version, this.germ.created(), time, seedTree.rootRef().toValue());
        return new Chunk(this, commit, post, zone, germ, size, (FingerTrieSeq<Tree>)trees, (FingerTrieSeq<Page>)pages);
    }

    public void uncommit(long version) {
        OrderedMapCursor<Value, Value> seedCursor = ((BTree)Trunk.TREE.get(this.seedTrunk)).cursor();
        while (seedCursor.hasNext()) {
            long newVersion;
            Tree newTree;
            Trunk<Tree> trunk;
            Tree oldTree;
            Value name = (Value)((Map.Entry)seedCursor.next()).getKey();
            do {
                newVersion = this.version;
            } while ((oldTree = Trunk.TREE.get(trunk = this.openTrunk(name, null, false, false))) != (newTree = oldTree.uncommitted(version)) && !trunk.updateTree(oldTree, newTree, newVersion));
        }
    }

    public Iterator<MetaTree> trees() {
        return new DatabaseTreeIterator((Cursor<Map.Entry<Value, Value>>)((BTree)Trunk.TREE.get(this.seedTrunk)).cursor());
    }

    public Iterator<MetaLeaf> leafs() {
        return new DatabaseLeafIterator(this, this.trees());
    }

    public void databaseDidCreateTrunk(Trunk<?> trunk) {
        TREE_SIZE.addAndGet(this, Trunk.TREE.get(trunk).treeSize());
    }

    public void databaseDidOpenTrunk(Trunk<?> trunk) {
        this.store.treeDidOpen(this, Trunk.TREE.get(trunk));
    }

    Commit databaseWillCommit(Commit commit) {
        return this.store.databaseWillCommit(this, commit);
    }

    void databaseDidCommit(Chunk chunk) {
        this.store.databaseDidCommit(this, chunk);
        DatabaseDelegate delegate = this.delegate;
        if (delegate != null) {
            delegate.databaseDidCommit(this, chunk);
        }
    }

    void databaseCommitDidFail(Throwable error) {
        this.store.databaseCommitDidFail(this, error);
    }

    void databaseWillCompact(int post) {
        this.store.databaseWillCompact(this, post);
    }

    void databaseDidCompact(int post) {
        this.store.databaseDidCompact(this, post);
        DatabaseDelegate delegate = this.delegate;
        if (delegate != null) {
            delegate.databaseDidCompact(this, post);
        }
    }

    void databaseCompactDidFail(Throwable error) {
        this.store.databaseCompactDidFail(this, error);
    }

    public void databaseDidUpdateTrunk(Trunk<?> trunk, Tree newTree, Tree oldTree, long newVersion) {
        if (!newTree.isTransient()) {
            HashTrieMap newSprouts;
            HashTrieMap<Value, Trunk<Tree>> oldSprouts;
            while (!SPROUTS.compareAndSet(this, oldSprouts = SPROUTS.get(this), (HashTrieMap<Value, Trunk<Tree>>)(newSprouts = oldSprouts.updated((Object)trunk.name, trunk)))) {
            }
            int newDiffSize = newTree.diffSize(newVersion);
            int oldDiffSize = Trunk.DIFF_SIZE.getAndSet(trunk, newDiffSize);
            long deltaSize = newDiffSize;
            if (!oldTree.isTransient()) {
                deltaSize -= (long)oldDiffSize;
            }
            DIFF_SIZE.addAndGet(this, deltaSize);
        }
        TREE_SIZE.addAndGet(this, newTree.treeSize() - oldTree.treeSize());
    }

    public void databaseDidCloseTrunk(Trunk<?> trunk) {
        this.store.treeDidClose(this, Trunk.TREE.get(trunk));
    }
}

