/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.concurrent.AbstractTask;
import swim.concurrent.Cont;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.FileStore;
import swim.db.FileZone;

final class FileStoreCommitter
extends AbstractTask {
    final FileStore store;
    volatile Commit commit;
    static final AtomicReferenceFieldUpdater<FileStoreCommitter, Commit> COMMIT = AtomicReferenceFieldUpdater.newUpdater(FileStoreCommitter.class, Commit.class, "commit");

    FileStoreCommitter(FileStore store) {
        this.store = store;
    }

    void commitAsync(Commit commit) {
        block2: {
            int newStatus;
            int oldStatus;
            Commit newCommit;
            Commit oldCommit;
            this.store.open();
            while (!COMMIT.compareAndSet(this, oldCommit, newCommit = (oldCommit = this.commit) != null ? oldCommit.merged(commit) : commit)) {
            }
            if (oldCommit != null) break block2;
            while (!FileStore.STATUS.compareAndSet(this.store, oldStatus = this.store.status, newStatus = oldStatus | 8)) {
            }
            this.cue();
        }
    }

    public boolean taskWillBlock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask() {
        block15: {
            FileStore store = this.store;
            Database database = null;
            Commit committing = COMMIT.getAndSet(this, null);
            try {
                FileZone zone;
                Chunk chunk;
                database = store.openDatabase();
                if (committing == null) {
                    return;
                }
                if ((committing = database.databaseWillCommit(committing)).isShifted()) {
                    store.shiftZone();
                }
                if ((chunk = (zone = store.zone).commitAndWriteChunk(committing)) != null) {
                    chunk.soften();
                }
                if (database.stablePost != 0) {
                    store.deletePost(database.stablePost);
                }
                database.databaseDidCommit(chunk);
                committing.bind(chunk);
            }
            catch (Throwable cause) {
                if (Cont.isNonFatal((Throwable)cause)) {
                    try {
                        database.databaseCommitDidFail(cause);
                        break block15;
                    }
                    finally {
                        committing.trap(cause);
                    }
                }
                throw cause;
            }
            finally {
                int newStatus;
                int oldStatus;
                while (!FileStore.STATUS.compareAndSet(store, oldStatus = this.store.status, newStatus = oldStatus & 0xFFFFFFF7)) {
                }
            }
        }
    }
}

