/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import swim.codec.Binary;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.concurrent.Cont;
import swim.db.Seed;
import swim.db.StoreException;
import swim.db.TreeType;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public class Germ {
    final int stem;
    final long version;
    final long created;
    final long updated;
    final Value seedRefValue;
    static final int BLOCK_SIZE = 4096;

    public Germ(int stem, long version, long created, long updated, Value seedRefValue) {
        this.stem = stem;
        this.version = version;
        this.created = created;
        this.updated = updated;
        this.seedRefValue = seedRefValue.commit();
    }

    public final int stem() {
        return this.stem;
    }

    public final long version() {
        return this.version;
    }

    public final long created() {
        return this.created;
    }

    public final long updated() {
        return this.updated;
    }

    public final Value seedRefValue() {
        return this.seedRefValue;
    }

    public Seed seed() {
        return new Seed(TreeType.BTREE, 1, this.created, this.updated, this.seedRefValue);
    }

    public Value toValue() {
        Record header = Record.create((int)4).slot("stem", this.stem).slot("version", this.version).slot("created", this.created).slot("updated", this.updated);
        Record record = Record.create((int)2).attr("swimdb", (Value)header);
        if (this.seedRefValue.isDefined()) {
            record.slot("seed", this.seedRefValue);
        }
        return record;
    }

    public void writeValue(Output<?> output) {
        Value value = this.toValue();
        Recon.write(output, (Item)value);
        for (int i = Recon.sizeOf((Item)value); i < 4096; ++i) {
            if (i % 1024 == 1023) {
                output.write(10);
                continue;
            }
            output.write(32);
        }
    }

    public void writeValue(WritableByteChannel channel) {
        ByteBuffer buffer = this.toByteBuffer();
        try {
            int k;
            while ((k = channel.write(buffer)) > 0 && buffer.hasRemaining()) {
            }
            if (buffer.hasRemaining()) {
                throw new StoreException("wrote incomplete germ");
            }
        }
        catch (IOException cause) {
            throw new StoreException(cause);
        }
    }

    public ByteBuffer toByteBuffer() {
        Output output = Utf8.decodedOutput((Output)Binary.outputBuffer((byte[])new byte[4096]));
        this.writeValue(output);
        return (ByteBuffer)output.bind();
    }

    public String toString() {
        return Recon.toString((Item)this.toValue());
    }

    public static Germ fromValue(Value value) {
        Throwable error = null;
        try {
            Value header = value.header("swimdb");
            if (header != null) {
                int stem = header.get("stem").intValue();
                long version = header.get("version").longValue();
                long created = header.get("created").longValue();
                long updated = header.get("updated").longValue();
                Value seedRefValue = value.get("seed");
                return new Germ(stem, version, created, updated, seedRefValue);
            }
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                error = cause;
            }
            throw cause;
        }
        Output message = Unicode.stringOutput((String)"Malformed germ: ");
        Recon.write((Output)message, (Item)value);
        throw new StoreException((String)message.bind(), error);
    }
}

