/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.STreePage;
import swim.db.STreePageRef;
import swim.db.Seed;
import swim.db.StoreException;
import swim.db.Tree;
import swim.db.TreeContext;
import swim.db.TreeType;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class STree
extends Tree {
    final TreeContext treeContext;
    final STreePageRef rootRef;
    final Seed seed;
    final boolean isResident;
    final boolean isTransient;

    public STree(TreeContext treeContext, STreePageRef rootRef, Seed seed, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = rootRef;
        this.seed = seed;
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    public STree(TreeContext treeContext, Seed seed, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = (STreePageRef)seed.rootRef(treeContext);
        this.seed = seed;
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    public STree(TreeContext treeContext, int stem, long version, boolean isResident, boolean isTransient) {
        this.treeContext = treeContext;
        this.rootRef = STreePageRef.empty(treeContext, stem, version);
        long time = System.currentTimeMillis();
        this.seed = new Seed(TreeType.STREE, stem, time, time, this.rootRef.toValue());
        this.isResident = isResident;
        this.isTransient = isTransient;
    }

    @Override
    public TreeType treeType() {
        return TreeType.STREE;
    }

    @Override
    public TreeContext treeContext() {
        return this.treeContext;
    }

    @Override
    public STreePageRef rootRef() {
        return this.rootRef;
    }

    @Override
    public STreePage rootPage() {
        try {
            return this.rootRef.page();
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                throw new StoreException(this.seed.toString(), error);
            }
            throw error;
        }
    }

    @Override
    public Seed seed() {
        return this.seed;
    }

    @Override
    public boolean isResident() {
        return this.isResident;
    }

    @Override
    public STree isResident(boolean isResident) {
        if (this.isResident != isResident) {
            return new STree(this.treeContext, this.rootRef, this.seed, isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public STree isTransient(boolean isTransient) {
        if (this.isTransient != isTransient) {
            return new STree(this.treeContext, this.rootRef, this.seed, this.isResident, isTransient);
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.rootRef.isEmpty();
    }

    public boolean contains(Value value) {
        return this.rootPage().contains(value);
    }

    public Value get(long index) {
        return this.rootPage().get(index);
    }

    public Slot getEntry(long index) {
        return this.rootPage().getEntry(index);
    }

    public STree updated(long index, Value newValue, long newVersion, int newPost) {
        STreePage newRoot;
        STreePage oldRoot = this.rootPage();
        if (oldRoot != (newRoot = oldRoot.updated(index, newValue, newVersion).balanced(newVersion).evacuated(newPost, newVersion))) {
            return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public STree inserted(long index, Value key, Value newValue, long newVersion, int newPost) {
        STreePage oldRoot = this.rootPage();
        STreePage newRoot = oldRoot.inserted(index, key, newValue, newVersion).balanced(newVersion).evacuated(newPost, newVersion);
        return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
    }

    public STree appended(Value key, Value newValue, long newVersion, int newPost) {
        STreePage oldRoot = this.rootPage();
        STreePage newRoot = oldRoot.appended(key, newValue, newVersion).balanced(newVersion).evacuated(newPost, newVersion);
        return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
    }

    public STree prepended(Value key, Value newValue, long newVersion, int newPost) {
        STreePage oldRoot = this.rootPage();
        STreePage newRoot = oldRoot.prepended(key, newValue, newVersion).balanced(newVersion).evacuated(newPost, newVersion);
        return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
    }

    public STree removed(long index, long newVersion, int newPost) {
        STreePage oldRoot = this.rootPage();
        STreePage newRoot = oldRoot.removed(index, newVersion).balanced(newVersion).evacuated(newPost, newVersion);
        return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
    }

    public STree removed(Object object, long newVersion, int newPost) {
        STreePage newRoot;
        STreePage oldRoot = this.rootPage();
        if (oldRoot != (newRoot = oldRoot.removed(object, newVersion).balanced(newVersion).evacuated(newPost, newVersion))) {
            return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public STree drop(long lower, long newVersion, int newPost) {
        if (lower > 0L) {
            STreePageRef oldRootRef = this.rootRef;
            STreePage newRoot = lower < oldRootRef.span() ? oldRootRef.page().drop(lower, newVersion).balanced(newVersion).evacuated(newPost, newVersion) : STreePage.empty(this.treeContext, this.seed.stem, newVersion);
            return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public STree take(long upper, long newVersion, int newPost) {
        STreePageRef oldRootRef = this.rootRef;
        if (upper < oldRootRef.span()) {
            STreePage newRoot = upper > 0L ? oldRootRef.page().take(upper, newVersion).balanced(newVersion).evacuated(newPost, newVersion) : STreePage.empty(this.treeContext, this.seed.stem, newVersion);
            return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public STree cleared(long newVersion) {
        if (!this.rootRef.isEmpty()) {
            STreePage newRoot = STreePage.empty(this.treeContext, this.seed.stem, newVersion);
            return new STree(this.treeContext, newRoot.pageRef(), this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    public long indexOf(Object object) {
        return this.rootPage().indexOf(object);
    }

    public long lastIndexOf(Object object) {
        return this.rootPage().lastIndexOf(object);
    }

    public long lookup(long start, Object key) {
        STreePage root = this.rootPage();
        if ((start = Math.min(Math.max(0L, start), root.span() - 1L)) > -1L) {
            long index = start;
            do {
                Slot slot;
                if ((slot = root.getEntry(index)) == null || !slot.key().equals(key)) continue;
                return index;
            } while ((index = (index + 1L) % root.span()) != start);
        }
        return -1L;
    }

    public void copyToArray(Object[] array, int offset) {
        this.rootPage().copyToArray(array, offset);
    }

    @Override
    public int diffSize(long version) {
        if (version == this.rootRef.softVersion()) {
            return this.rootRef.diffSize();
        }
        return 0;
    }

    @Override
    public long treeSize() {
        return this.rootRef.treeSize();
    }

    public STree reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion, int newPost) {
        STreePageRef oldRootRef = this.rootRef;
        STreePageRef newRootRef = oldRootRef.reduced(identity, accumulator, combiner, newVersion).evacuated(newPost, newVersion);
        if (oldRootRef != newRootRef) {
            return new STree(this.treeContext, newRootRef, this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public STree evacuated(int post, long version) {
        STreePageRef oldRootRef = this.rootRef;
        STreePageRef newRootRef = oldRootRef.evacuated(post, version);
        if (oldRootRef != newRootRef) {
            return new STree(this.treeContext, newRootRef, this.seed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public STree committed(int zone, long base, long version, long time) {
        if (!this.rootRef.isCommitted()) {
            STreePageRef newRootRef = this.rootRef.committed(zone, base, version);
            Seed newSeed = this.seed.committed(time, newRootRef);
            return new STree(this.treeContext, newRootRef, newSeed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public STree uncommitted(long version) {
        STreePageRef oldRootRef = this.rootRef;
        STreePageRef newRootRef = oldRootRef.uncommitted(version);
        if (oldRootRef != newRootRef) {
            Seed newSeed = this.seed.uncommitted(newRootRef);
            return new STree(this.treeContext, newRootRef, newSeed, this.isResident, this.isTransient);
        }
        return this;
    }

    @Override
    public void writeDiff(Output<?> output, long version) {
        if (version == this.rootRef.softVersion()) {
            this.rootRef.writeDiff(output);
        }
    }

    @Override
    public void buildDiff(long version, Builder<Page, ?> builder) {
        if (version == this.rootRef.softVersion()) {
            this.rootRef.buildDiff(builder);
        }
    }

    @Override
    public STree load() {
        this.rootRef.loadTree(this.isResident);
        return this;
    }

    @Override
    public void soften(long version) {
        if (!this.isResident && !this.isTransient) {
            this.rootRef.soften(version);
        }
    }

    public Cursor<Slot> cursor() {
        return this.rootRef.cursor();
    }

    public Cursor<Slot> depthCursor(int maxDepth) {
        return this.rootRef.depthCursor(maxDepth);
    }

    public Cursor<Slot> deltaCursor(long sinceVersion) {
        return this.rootRef.deltaCursor(sinceVersion);
    }
}

