/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.STreeNode;
import swim.db.STreePage;
import swim.db.STreePageRef;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class STreeLeaf
extends STreePage {
    final STreePageRef pageRef;
    final long version;
    final Slot[] slots;
    static final Slot[] EMPTY_SLOTS = new Slot[0];

    protected STreeLeaf(STreePageRef pageRef, long version, Slot[] slots) {
        this.pageRef = pageRef;
        this.version = version;
        this.slots = slots;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public STreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.LEAF;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return this.slots.length == 0;
    }

    @Override
    public int arity() {
        return this.slots.length;
    }

    @Override
    public int childCount() {
        return 0;
    }

    @Override
    public STreePageRef getChildRef(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public STreePage getChild(int index) {
        throw new IndexOutOfBoundsException(Integer.toString(index));
    }

    @Override
    public boolean contains(Value value) {
        Slot[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            if (!value.equals((Object)slots[i].value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Slot getSlot(int x) {
        return this.slots[x];
    }

    @Override
    public Value get(long index) {
        if (0L <= index && index < (long)this.slots.length) {
            return this.slots[(int)index].value();
        }
        return Value.absent();
    }

    @Override
    public Slot getEntry(long index) {
        if (0L <= index && index < (long)this.slots.length) {
            return this.slots[(int)index];
        }
        return null;
    }

    @Override
    public STreePage updated(long index, Value newValue, long newVersion) {
        if (0L <= index && index < (long)this.slots.length) {
            return this.updatedSlot((int)index, newValue, newVersion);
        }
        throw new IndexOutOfBoundsException();
    }

    STreeLeaf updatedSlot(int index, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot oldSlot = oldSlots[index];
        if (!newValue.equals((Object)oldSlot.value())) {
            int n = oldSlots.length;
            Slot[] newSlots = new Slot[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[index] = oldSlot.updatedValue(newValue).commit();
            return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
        }
        return this;
    }

    @Override
    public STreePage inserted(long index, Value key, Value newValue, long newVersion) {
        if (0L <= index && index <= (long)this.slots.length) {
            return this.insertedSlot((int)index, key, newValue, newVersion);
        }
        throw new IndexOutOfBoundsException();
    }

    STreeLeaf insertedSlot(int index, Value key, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, index);
        newSlots[index] = Slot.of((Value)key, (Value)newValue).commit();
        System.arraycopy(oldSlots, index, newSlots, index + 1, n - (index + 1));
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public STreeLeaf removed(long index, long newVersion) {
        if (0L <= index && index < (long)this.slots.length) {
            if (this.slots.length > 1) {
                return this.removedSlot((int)index, newVersion);
            }
            return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        throw new IndexOutOfBoundsException();
    }

    STreeLeaf removedSlot(int index, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, index);
        System.arraycopy(oldSlots, index + 1, newSlots, index, n - index);
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public STreeLeaf removed(Object object, long newVersion) {
        int i = (int)this.indexOf(object);
        if (i >= 0) {
            if (this.slots.length > 1) {
                return this.removedSlot(i, newVersion);
            }
            return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    @Override
    public STreePage drop(long lower, long newVersion) {
        if (lower > 0L) {
            Slot[] slots = this.slots;
            int k = slots.length;
            if (lower < (long)k) {
                int x = (int)lower;
                int n = k - x;
                Slot[] newSlots = new Slot[n];
                System.arraycopy(slots, x, newSlots, 0, n);
                return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
            }
            return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    @Override
    public STreePage take(long upper, long newVersion) {
        Slot[] slots = this.slots;
        if (upper < (long)slots.length) {
            if (upper > 0L) {
                int n = (int)upper;
                Slot[] newSlots = new Slot[n];
                System.arraycopy(slots, 0, newSlots, 0, n);
                return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
            }
            return STreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        return this;
    }

    @Override
    public long indexOf(Object object) {
        Slot[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            if (!object.equals(slots[i])) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(Object object) {
        Slot[] slots = this.slots;
        for (int i = slots.length - 1; i >= 0; --i) {
            if (!object.equals(slots[i])) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public void copyToArray(Object[] array, int offset) {
        Slot[] slots = this.slots;
        System.arraycopy(slots, 0, array, offset, slots.length);
    }

    @Override
    public STreePage balanced(long newVersion) {
        int n = this.slots.length;
        if (n > 1 && this.pageRef.context.pageShouldSplit(this)) {
            int x = n >>> 1;
            return this.split(x, newVersion);
        }
        return this;
    }

    @Override
    public STreeNode split(int x, long newVersion) {
        STreePageRef[] newChildRefs = new STreePageRef[2];
        STreeLeaf newLeftPage = this.splitLeft(x, newVersion);
        STreeLeaf newRightPage = this.splitRight(x, newVersion);
        newChildRefs[0] = newLeftPage.pageRef();
        newChildRefs[1] = newRightPage.pageRef();
        long[] newKnotIndexes = new long[]{x};
        return STreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.slots.length, Value.absent(), newChildRefs, newKnotIndexes);
    }

    @Override
    public STreeLeaf splitLeft(int x, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot[] newSlots = new Slot[x];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public STreeLeaf splitRight(int x, long newVersion) {
        Slot[] oldSlots = this.slots;
        int y = oldSlots.length - x;
        Slot[] newSlots = new Slot[y];
        System.arraycopy(oldSlots, x, newSlots, 0, y);
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), newSlots);
    }

    @Override
    public int pageSize() {
        return this.pageRef.pageSize();
    }

    @Override
    public int diffSize() {
        return this.pageRef.diffSize();
    }

    @Override
    public long treeSize() {
        return this.pageRef.treeSize();
    }

    @Override
    void memoizeSize(STreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        Slot[] slots = this.slots;
        int n = slots.length;
        if (n > 0) {
            ++pageSize;
            pageSize += Recon.sizeOf((Item)slots[0]);
            for (int i = 1; i < n; ++i) {
                ++pageSize;
                pageSize += Recon.sizeOf((Item)slots[i]);
            }
            ++pageSize;
        }
        pageRef.pageSize = ++pageSize;
        pageRef.diffSize = pageSize;
        pageRef.treeSize = pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("sleaf", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        Slot[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            record.add((Item)slots[i]);
        }
        return record;
    }

    @Override
    public STreeLeaf reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        Slot[] slots = this.slots;
        Value fold = identity;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            fold = (Value)accumulator.combine((Object)fold, (Object)slots[i].value());
        }
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, fold, slots);
    }

    @Override
    public STreeLeaf evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.fold, this.slots);
        }
        return this;
    }

    @Override
    public STreeLeaf committed(int zone, long base, long version) {
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, zone, base, this.pageRef.fold, this.slots);
    }

    @Override
    public STreeLeaf uncommitted(long version) {
        return STreeLeaf.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.fold, this.slots);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write(output, (Item)this.toHeader());
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        Slot[] slots = this.slots;
        int n = slots.length;
        if (n > 0) {
            output.write(123);
            Recon.write(output, (Item)slots[0]);
            for (int i = 1; i < n; ++i) {
                output.write(44);
                Recon.write(output, (Item)slots[i]);
            }
            output.write(125);
        }
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.writePage(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        builder.add((Object)this);
    }

    @Override
    public STreePage loadTree(PageLoader pageLoader) {
        return this;
    }

    @Override
    public void soften(long version) {
    }

    @Override
    public Cursor<Slot> cursor() {
        return Cursor.array((Object[])this.slots);
    }

    @Override
    public Cursor<Slot> depthCursor(int maxDepth) {
        return this.cursor();
    }

    @Override
    public Cursor<Slot> deltaCursor(long sinceVersion) {
        if (sinceVersion <= this.version) {
            return this.cursor();
        }
        return Cursor.empty();
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Output)output, (Item)this.toHeader());
        this.writePageContent(output);
        return (String)output.bind();
    }

    public static STreeLeaf create(PageContext context, int stem, long version, int zone, long base, Value fold, Slot[] slots) {
        STreePageRef pageRef = new STreePageRef(context, PageType.LEAF, stem, zone, zone, base, slots.length, fold);
        STreeLeaf page = new STreeLeaf(pageRef, version, slots);
        pageRef.page = page;
        return page;
    }

    public static STreeLeaf create(PageContext context, int stem, long version, Value fold, Slot[] slots) {
        return STreeLeaf.create(context, stem, version, 0, 0L, fold, slots);
    }

    public static STreeLeaf empty(PageContext context, int stem, long version) {
        return STreeLeaf.create(context, stem, version, 0, 0L, Value.absent(), EMPTY_SLOTS);
    }

    public static STreeLeaf fromValue(STreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("sleaf");
            long version = header.get("v").longValue();
            Record tail = value.tail();
            Object[] slots = new Slot[tail.size()];
            tail.toArray(slots);
            return new STreeLeaf(pageRef, version, (Slot[])slots);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed sleaf: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

