/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.AbstractList;
import java.util.List;
import swim.db.STreeList;
import swim.structure.Value;

final class STreeSubList
extends AbstractList<Value> {
    final STreeList inner;
    final int fromIndex;
    final int toIndex;

    STreeSubList(STreeList inner, int fromIndex, int toIndex) {
        this.inner = inner;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    public int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public Value get(int index) {
        int i = this.fromIndex + index;
        if (i < this.fromIndex || i >= this.toIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.inner.get(i);
    }

    @Override
    public List<Value> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        fromIndex += this.fromIndex;
        if ((toIndex += this.fromIndex) > this.toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new STreeSubList(this.inner, fromIndex, toIndex);
    }
}

