/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.StoreSettings;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class StoreSettingsForm
extends Form<StoreSettings> {
    StoreSettingsForm() {
    }

    public String tag() {
        return "store";
    }

    public StoreSettings unit() {
        return StoreSettings.standard();
    }

    public Class<?> type() {
        return StoreSettings.class;
    }

    public Item mold(StoreSettings settings) {
        if (settings != null) {
            StoreSettings standard = StoreSettings.standard();
            Record record = Record.create().attr(this.tag());
            if (settings.pageSplitSize != standard.pageSplitSize) {
                record.slot("pageSplitSize", settings.pageSplitSize);
            }
            if (settings.pageCacheSize != standard.pageCacheSize) {
                record.slot("pageCacheSize", settings.pageCacheSize);
            }
            if (settings.minCommitSize != standard.minCommitSize) {
                record.slot("minCommitSize", settings.minCommitSize);
            }
            if (settings.maxCommitSize != standard.maxCommitSize) {
                record.slot("maxCommitSize", settings.maxCommitSize);
            }
            if (settings.minCommitInterval != standard.minCommitInterval) {
                record.slot("minCommitInterval", settings.minCommitInterval);
            }
            if (settings.maxCommitTime != standard.maxCommitTime) {
                record.slot("maxCommitTime", settings.maxCommitTime);
            }
            if (settings.minCompactSize != standard.minCompactSize) {
                record.slot("minCompactSize", settings.minCompactSize);
            }
            if (settings.maxCompactSize != standard.maxCompactSize) {
                record.slot("maxCompactSize", settings.maxCompactSize);
            }
            if (settings.maxCompactTime != standard.maxCompactTime) {
                record.slot("maxCompactTime", settings.maxCompactTime);
            }
            if (settings.maxZoneSize != standard.maxZoneSize) {
                record.slot("maxZoneSize", settings.maxZoneSize);
            }
            if (settings.minZoneFill != standard.minZoneFill) {
                record.slot("minZoneFill", settings.minZoneFill);
            }
            if (settings.minTreeFill != standard.minTreeFill) {
                record.slot("minTreeFill", settings.minTreeFill);
            }
            if (settings.maxRetries != standard.maxRetries) {
                record.slot("maxRetries", settings.maxRetries);
            }
            if (settings.deleteDelay != standard.deleteDelay) {
                record.slot("deleteDelay", settings.deleteDelay);
            }
            return record;
        }
        return Item.extant();
    }

    public StoreSettings cast(Item item) {
        Value value = item.toValue();
        if (value.getAttr(this.tag()).isDefined()) {
            StoreSettings standard = StoreSettings.standard();
            int pageSplitSize = value.get("pageSplitSize").intValue(standard.pageSplitSize);
            int pageCacheSize = value.get("pageCacheSize").intValue(standard.pageCacheSize);
            long minCommitSize = value.get("minCommitSize").longValue(standard.minCommitSize);
            long maxCommitSize = value.get("maxCommitSize").longValue(standard.maxCommitSize);
            long minCommitInterval = value.get("minCommitInterval").longValue(standard.minCommitInterval);
            long maxCommitTime = value.get("maxCommitTime").longValue(standard.maxCommitTime);
            long minCompactSize = value.get("minCompactSize").longValue(standard.minCompactSize);
            long maxCompactSize = value.get("maxCompactSize").longValue(standard.maxCompactSize);
            long maxCompactTime = value.get("maxCompactTime").longValue(standard.maxCompactTime);
            long maxZoneSize = value.get("maxZoneSize").longValue(standard.maxZoneSize);
            double minZoneFill = value.get("minZoneFill").doubleValue(standard.minZoneFill);
            double minTreeFill = value.get("minTreeFill").doubleValue(standard.minTreeFill);
            int maxRetries = value.get("maxRetries").intValue(standard.maxRetries);
            int deleteDelay = value.get("deleteDelay").intValue(standard.deleteDelay);
            return new StoreSettings(pageSplitSize, pageCacheSize, minCommitSize, maxCommitSize, minCommitInterval, maxCommitTime, minCompactSize, maxCompactSize, maxCompactTime, maxZoneSize, minZoneFill, minTreeFill, maxRetries, deleteDelay);
        }
        return null;
    }
}

