/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.lang.ref.WeakReference;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.PageType;
import swim.db.StoreException;
import swim.db.UTreeLeaf;
import swim.db.UTreePage;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Cursor;

public final class UTreePageRef
extends PageRef {
    final PageContext context;
    final int stem;
    final int post;
    final int zone;
    final long base;
    Object page;
    int pageRefSize;
    int pageSize;
    int diffSize;

    public UTreePageRef(PageContext context, int stem, int post, int zone, long base, Object page, int pageRefSize, int pageSize, int diffSize) {
        this.context = context;
        this.stem = stem;
        this.post = post;
        this.zone = zone;
        this.base = base;
        this.page = page;
        this.pageRefSize = pageRefSize;
        this.pageSize = pageSize;
        this.diffSize = diffSize;
    }

    public UTreePageRef(PageContext context, int stem, int post, int zone, long base, Object page) {
        this(context, stem, post, zone, base, page, -1, -1, -1);
    }

    public UTreePageRef(PageContext context, int stem, int post, int zone, long base) {
        this(context, stem, post, zone, base, null, -1, -1, -1);
    }

    @Override
    public PageContext pageContext() {
        return this.context;
    }

    @Override
    public PageType pageType() {
        return PageType.LEAF;
    }

    @Override
    public int stem() {
        return this.stem;
    }

    @Override
    public int post() {
        return this.post;
    }

    @Override
    public int zone() {
        return this.zone;
    }

    @Override
    public long base() {
        return this.base;
    }

    @Override
    public long span() {
        return 1L;
    }

    @Override
    public Value fold() {
        return Value.absent();
    }

    @Override
    public UTreePage page() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof UTreePage) {
            this.context.hitPage((UTreePage)page);
            return (UTreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(false);
        try {
            UTreePage uTreePage = (UTreePage)pageLoader.loadPage(this);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return uTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public UTreePage hardPage() {
        Object page = this.page;
        if (page instanceof UTreePage) {
            return (UTreePage)page;
        }
        return null;
    }

    @Override
    public UTreePage softPage() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof UTreePage) {
            return (UTreePage)page;
        }
        return null;
    }

    @Override
    public long softVersion() {
        UTreePage page = this.softPage();
        if (page != null) {
            return page.version();
        }
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isCommitted() {
        return this.zone > 0 && this.base > 0L;
    }

    @Override
    public int pageRefSize() {
        int pageRefSize = this.pageRefSize;
        if (pageRefSize < 0) {
            pageRefSize = 5;
            if (this.post != this.zone) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)Num.from((int)this.post));
            }
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.zone));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.base));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.pageSize()));
            this.pageRefSize = ++pageRefSize;
        }
        return pageRefSize;
    }

    @Override
    public int pageSize() {
        if (this.pageSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.pageSize;
    }

    @Override
    public int diffSize() {
        if (this.diffSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.diffSize;
    }

    @Override
    public long treeSize() {
        return this.pageSize();
    }

    @Override
    public Value toValue() {
        Record header = Record.create((int)4);
        if (this.post != this.zone) {
            header.slot("post", this.post);
        }
        header.slot("zone", this.zone).slot("base", this.base).slot("size", this.pageSize());
        return Record.create((int)1).attr(this.pageType().tag(), (Value)header);
    }

    @Override
    public UTreePageRef evacuated(int post, long version) {
        if (this.post != 0 && this.post < post) {
            UTreePage page = this.page();
            try {
                return page.evacuated(post, version).pageRef();
            }
            catch (Throwable cause) {
                if (Cont.isNonFatal((Throwable)cause)) {
                    throw new StoreException(cause);
                }
                throw new StoreException(this.toDebugString(), cause);
            }
        }
        return this;
    }

    @Override
    public UTreePageRef committed(int zone, long base, long version) {
        UTreePage page = this.hardPage();
        if (page != null) {
            return page.committed(zone, base, version).pageRef();
        }
        return this;
    }

    @Override
    public UTreePageRef uncommitted(long version) {
        UTreePage page = this.hardPage();
        if (page != null && page.version() >= version) {
            return page.uncommitted(version).pageRef();
        }
        return this;
    }

    @Override
    public void writePageRef(Output<?> output) {
        Recon.write(output, (Item)this.toValue());
    }

    @Override
    public void writePage(Output<?> output) {
        this.page().writePage(output);
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.page().writeDiff(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        this.page().buildDiff(builder);
    }

    @Override
    public UTreePage setPageValue(Value value, boolean isResident) {
        try {
            UTreePage page = UTreePage.fromValue(this, value);
            if (isResident) {
                this.page = page;
            } else {
                this.context.hitPage(page);
                this.page = new WeakReference<UTreePage>(page);
            }
            return page;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public UTreePage loadPage(boolean isResident) {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof UTreePage) {
            this.context.hitPage((UTreePage)page);
            return (UTreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(isResident);
        try {
            UTreePage uTreePage = (UTreePage)pageLoader.loadPage(this);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return uTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public UTreePage loadPage(PageLoader pageLoader) {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof UTreePage) {
            this.context.hitPage((UTreePage)page);
            return (UTreePage)page;
        }
        try {
            return (UTreePage)pageLoader.loadPage(this);
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                throw new StoreException(this.toDebugString(), error);
            }
            throw error;
        }
    }

    @Override
    public UTreePage loadTree(boolean isResident) {
        try (PageLoader pageLoader = this.context.openPageLoader(isResident);){
            UTreePage uTreePage = this.loadTree(pageLoader);
            return uTreePage;
        }
    }

    @Override
    public UTreePage loadTree(PageLoader pageLoader) {
        UTreePage page = this.loadPage(pageLoader);
        return page.loadTree(pageLoader);
    }

    @Override
    public void soften(long version) {
        Object page = this.page;
        if (page instanceof UTreePage) {
            if (((UTreePage)page).version() <= version && this.isCommitted()) {
                this.context.hitPage((UTreePage)page);
                this.page = new WeakReference<Object>(page);
            }
            ((UTreePage)page).soften(version);
        }
    }

    public Cursor<Value> cursor() {
        return this.page().cursor();
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)this.pageRefSize());
        this.writePageRef(output);
        return (String)output.bind();
    }

    public static UTreePageRef empty(PageContext context, int stem, long version) {
        return UTreeLeaf.empty(context, stem, version).pageRef();
    }

    public static UTreePageRef fromValue(PageContext context, int stem, Value value) {
        Throwable cause = null;
        try {
            String tag = value.tag();
            PageType pageType = PageType.fromTag(tag);
            if (pageType == null) {
                return null;
            }
            Value header = value.header(tag);
            int zone = header.get("zone").intValue();
            int post = header.get("post").intValue(zone);
            long base = header.get("base").longValue();
            int size = header.get("size").intValue();
            if (base < 0L) {
                throw new StoreException("negative page base: " + base);
            }
            if (size < 0) {
                throw new StoreException("negative page size: " + size);
            }
            return new UTreePageRef(context, stem, post, zone, base, null, -1, size, 0);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed utree page ref: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

