/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.BTreeLeaf;
import swim.db.BTreeNodeDeltaCursor;
import swim.db.BTreeNodeDepthCursor;
import swim.db.BTreePage;
import swim.db.BTreePageRef;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.OrderedMapCursor;

public final class BTreeNode
extends BTreePage {
    final BTreePageRef pageRef;
    final long version;
    final BTreePageRef[] childRefs;
    final Value[] knotKeys;
    static final Value[] EMPTY_KNOT_KEYS = new Value[0];

    protected BTreeNode(BTreePageRef pageRef, long version, BTreePageRef[] childRefs, Value[] knotKeys) {
        this.pageRef = pageRef;
        this.version = version;
        this.childRefs = childRefs;
        this.knotKeys = knotKeys;
        for (int i = 0; i < childRefs.length; ++i) {
            if (childRefs[i] == null) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public BTreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.NODE;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return this.pageRef.span == 0L;
    }

    @Override
    public int arity() {
        return this.knotKeys.length;
    }

    @Override
    public int childCount() {
        return this.childRefs.length;
    }

    @Override
    public BTreePageRef getChildRef(int index) {
        return this.childRefs[index];
    }

    @Override
    public BTreePage getChild(int index) {
        try {
            return this.childRefs[index].page();
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public Slot getSlot(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value getKey(int x) {
        return this.knotKeys[x];
    }

    @Override
    public Value minKey() {
        return this.getChild(0).minKey();
    }

    @Override
    public Value maxKey() {
        return this.getChild(this.childRefs.length - 1).maxKey();
    }

    int lookup(Value key) {
        Value[] knotKeys = this.knotKeys;
        int low = 0;
        int high = knotKeys.length - 1;
        while (low <= high) {
            int order;
            int x = low + high >>> 1;
            int n = order = key != null ? key.compareTo((Item)knotKeys[x]) : -1;
            if (order > 0) {
                low = x + 1;
                continue;
            }
            if (order < 0) {
                high = x - 1;
                continue;
            }
            return x;
        }
        return -(low + 1);
    }

    @Override
    public boolean containsKey(Value key) {
        int x = this.lookup(key);
        if (x > 0) {
            ++x;
        } else if (x < 0) {
            x = -(x + 1);
        } else {
            return true;
        }
        return this.getChild(x).containsKey(key);
    }

    @Override
    public boolean containsValue(Value value) {
        try {
            BTreePageRef[] childRefs = this.childRefs;
            int n = childRefs.length;
            for (int i = 0; i < n; ++i) {
                if (!childRefs[i].page().containsValue(value)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public long indexOf(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        long count = 0L;
        for (int i = 0; i < x; ++i) {
            count += this.childRefs[x].span();
        }
        try {
            long index = this.childRefs[x].page().indexOf(key);
            if (index >= 0L) {
                return count + index;
            }
            return index - count;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public Value get(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        return this.getChild(x).get(key);
    }

    @Override
    public Slot getEntry(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        return this.getChild(x).getEntry(key);
    }

    @Override
    public Slot getIndex(long index) {
        for (BTreePageRef childRef : this.childRefs) {
            long k = childRef.span();
            if (index < k) {
                try {
                    return childRef.page().getIndex(index);
                }
                catch (Throwable cause) {
                    if (Cont.isNonFatal((Throwable)cause)) {
                        throw new StoreException(this.toDebugString(), cause);
                    }
                    throw cause;
                }
            }
            index -= k;
        }
        return null;
    }

    @Override
    public Slot firstEntry(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        try {
            return this.childRefs[x].page().firstEntry(key);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public Slot firstEntry() {
        BTreePageRef[] childRefs = this.childRefs;
        if (childRefs.length != 0) {
            try {
                return childRefs[0].page().firstEntry();
            }
            catch (Throwable cause) {
                if (Cont.isNonFatal((Throwable)cause)) {
                    throw new StoreException(this.toDebugString(), cause);
                }
                throw cause;
            }
        }
        return null;
    }

    @Override
    public Slot lastEntry() {
        BTreePageRef[] childRefs = this.childRefs;
        if (childRefs.length != 0) {
            try {
                return childRefs[childRefs.length - 1].page().lastEntry();
            }
            catch (Throwable cause) {
                if (Cont.isNonFatal((Throwable)cause)) {
                    throw new StoreException(this.toDebugString(), cause);
                }
                throw cause;
            }
        }
        return null;
    }

    @Override
    public Slot nextEntry(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePageRef[] childRefs = this.childRefs;
        try {
            Slot entry = childRefs[x].page().nextEntry(key);
            if (entry == null && x + 1 < childRefs.length) {
                entry = childRefs[x + 1].page().nextEntry(key);
            }
            return entry;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public Slot previousEntry(Value key) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePageRef[] childRefs = this.childRefs;
        try {
            Slot entry = childRefs[x].page().previousEntry(key);
            if (entry == null && x > 0) {
                entry = childRefs[x - 1].page().previousEntry(key);
            }
            return entry;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public BTreePage updated(Value key, Value newValue, long newVersion) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePage oldPage = this.getChild(x);
        BTreePage newPage = oldPage.updated(key, newValue, newVersion);
        if (oldPage != newPage) {
            if (oldPage.span() != newPage.span() && this.pageRef.context.pageShouldSplit(newPage)) {
                return this.updatedPageSplit(x, newPage, oldPage, newVersion);
            }
            return this.updatedPage(x, newPage, oldPage, newVersion);
        }
        return this;
    }

    BTreeNode updatedPage(int x, BTreePage newPage, BTreePage oldPage, long newVersion) {
        Value[] newKnotKeys;
        BTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        BTreePageRef[] newChildRefs = new BTreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, n);
        newChildRefs[x] = newPage.pageRef();
        Value[] oldKnotKeys = this.knotKeys;
        if (n - 1 > 0) {
            newKnotKeys = new Value[n - 1];
            System.arraycopy(oldKnotKeys, 0, newKnotKeys, 0, n - 1);
            if (x > 0) {
                newKnotKeys[x - 1] = newPage.minKey();
            }
        } else {
            newKnotKeys = EMPTY_KNOT_KEYS;
        }
        long newSpan = this.pageRef.span - oldPage.span() + newPage.span();
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
    }

    BTreeNode updatedPageSplit(int x, BTreePage newPage, BTreePage oldPage, long newVersion) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length + 1;
        BTreePageRef[] newChildRefs = new BTreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x);
        int y = newPage.arity() >>> 1;
        BTreePage newLeftPage = newPage.splitLeft(y, newVersion);
        BTreePage newRightPage = newPage.splitRight(y, newVersion);
        newChildRefs[x] = newLeftPage.pageRef();
        newChildRefs[x + 1] = newRightPage.pageRef();
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, x + 2, n - (x + 2));
        Value[] oldKnotKeys = this.knotKeys;
        Value[] newKnotKeys = new Value[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnotKeys, 0, newKnotKeys, 0, x - 1);
            newKnotKeys[x - 1] = newLeftPage.minKey();
            newKnotKeys[x] = newRightPage.minKey();
            System.arraycopy(oldKnotKeys, x, newKnotKeys, x + 1, n - (x + 2));
        } else {
            newKnotKeys[0] = newRightPage.minKey();
            System.arraycopy(oldKnotKeys, 0, newKnotKeys, 1, n - 2);
        }
        long newSpan = this.pageRef.span - oldPage.span() + newPage.span();
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
    }

    BTreeNode updatedPageMerge(int x, BTreeNode newPage, BTreePage oldPage, long newVersion) {
        try {
            BTreePageRef[] oldChildRefs = this.childRefs;
            BTreePageRef[] mergePages = newPage.childRefs;
            int k = mergePages.length;
            int n = oldChildRefs.length + (k - 1);
            BTreePageRef[] newChildRefs = new BTreePageRef[n];
            System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x);
            System.arraycopy(mergePages, 0, newChildRefs, x, k);
            System.arraycopy(oldChildRefs, x + 1, newChildRefs, x + k, n - (x + k));
            Value[] oldKnotKeys = this.knotKeys;
            Value[] mergeKeys = newPage.knotKeys;
            Value[] newKnotKeys = new Value[n - 1];
            if (x > 0) {
                System.arraycopy(oldKnotKeys, 0, newKnotKeys, 0, x - 1);
                newKnotKeys[x - 1] = mergePages[0].page().minKey();
                System.arraycopy(mergeKeys, 0, newKnotKeys, x, k - 1);
                System.arraycopy(oldKnotKeys, x, newKnotKeys, x + (k - 1), n - (x + k));
            } else {
                System.arraycopy(mergeKeys, 0, newKnotKeys, 0, k - 1);
                newKnotKeys[k - 1] = oldChildRefs[1].page().minKey();
                System.arraycopy(oldKnotKeys, 1, newKnotKeys, k, n - k - 1);
            }
            long newSpan = this.pageRef.span - oldPage.span() + newPage.span();
            return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public BTreePage removed(Value key, long newVersion) {
        int x = this.lookup(key);
        x = x >= 0 ? ++x : -(x + 1);
        BTreePage oldPage = this.getChild(x);
        BTreePage newPage = oldPage.removed(key, newVersion);
        if (oldPage != newPage) {
            return this.replacedPage(x, newPage, oldPage, newVersion);
        }
        return this;
    }

    BTreePage replacedPage(int x, BTreePage newPage, BTreePage oldPage, long newVersion) {
        if (!newPage.isEmpty()) {
            if (newPage.isNode() && this.pageRef.context.pageShouldMerge(newPage)) {
                return this.updatedPageMerge(x, (BTreeNode)newPage, oldPage, newVersion);
            }
            return this.updatedPage(x, newPage, oldPage, newVersion);
        }
        if (this.childRefs.length > 2) {
            return this.removedPage(x, newPage, oldPage, newVersion);
        }
        if (this.childRefs.length > 1) {
            if (x == 0) {
                return this.getChild(1);
            }
            return this.getChild(0);
        }
        return BTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
    }

    BTreeNode removedPage(int x, BTreePage newPage, BTreePage oldPage, long newVersion) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length - 1;
        BTreePageRef[] newChildRefs = new BTreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x);
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, x, n - x);
        Value[] oldKnotKeys = this.knotKeys;
        Value[] newKnotKeys = new Value[n - 1];
        if (x > 0) {
            System.arraycopy(oldKnotKeys, 0, newKnotKeys, 0, x - 1);
            System.arraycopy(oldKnotKeys, x, newKnotKeys, x - 1, n - x);
        } else {
            System.arraycopy(oldKnotKeys, 1, newKnotKeys, 0, n - 1);
        }
        long newSpan = this.pageRef.span - oldPage.span();
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
    }

    @Override
    public BTreePage drop(long lower, long newVersion) {
        try {
            if (lower > 0L) {
                long newSpan = this.span();
                if (lower < newSpan) {
                    int x;
                    long childSpan;
                    BTreePageRef[] oldChildRefs = this.childRefs;
                    int k = oldChildRefs.length;
                    for (x = 0; x < k && (childSpan = oldChildRefs[x].span()) <= lower; lower -= childSpan, ++x) {
                        newSpan -= childSpan;
                    }
                    int n = k - x;
                    if (n > 1) {
                        BTreeNode newNode;
                        if (x > 0) {
                            BTreePageRef[] newChildRefs = new BTreePageRef[n];
                            System.arraycopy(oldChildRefs, x, newChildRefs, 0, n);
                            Value[] newKnotKeys = new Value[n - 1];
                            System.arraycopy(this.knotKeys, x, newKnotKeys, 0, n - 1);
                            newNode = BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
                        } else {
                            newNode = this;
                        }
                        if (lower > 0L) {
                            BTreePage oldPage = oldChildRefs[x].page();
                            BTreePage newPage = oldPage.drop(lower, newVersion);
                            return newNode.replacedPage(0, newPage, oldPage, newVersion);
                        }
                        return newNode;
                    }
                    return oldChildRefs[x].page().drop(lower, newVersion);
                }
                return BTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
            }
            return this;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public BTreePage take(long upper, long newVersion) {
        try {
            if (upper < this.span()) {
                if (upper > 0L) {
                    int n;
                    long childSpan;
                    int x;
                    BTreePageRef[] oldChildRefs = this.childRefs;
                    int k = oldChildRefs.length;
                    long newSpan = 0L;
                    for (x = 0; x < k && upper > 0L; ++x, upper -= childSpan) {
                        childSpan = oldChildRefs[x].span();
                        newSpan += childSpan;
                        if (childSpan > upper) break;
                    }
                    int n2 = n = upper == 0L ? x : x + 1;
                    if (n > 1) {
                        BTreeNode newNode;
                        if (x < k) {
                            BTreePageRef[] newChildRefs = new BTreePageRef[n];
                            System.arraycopy(oldChildRefs, 0, newChildRefs, 0, n);
                            Value[] newKnotKeys = new Value[n - 1];
                            System.arraycopy(this.knotKeys, 0, newKnotKeys, 0, n - 1);
                            newNode = BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
                        } else {
                            newNode = this;
                        }
                        if (upper > 0L) {
                            BTreePage oldPage = oldChildRefs[x - 1].page();
                            BTreePage newPage = oldPage.take(upper, newVersion);
                            return newNode.replacedPage(x - 1, newPage, oldPage, newVersion);
                        }
                        return newNode;
                    }
                    if (upper > 0L) {
                        return oldChildRefs[0].page().take(upper, newVersion);
                    }
                    return oldChildRefs[0].page();
                }
                return BTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
            }
            return this;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public BTreeNode balanced(long newVersion) {
        if (this.childRefs.length > 1 && this.pageRef.context.pageShouldSplit(this)) {
            int x = this.knotKeys.length >>> 1;
            return this.split(x, newVersion);
        }
        return this;
    }

    @Override
    public BTreeNode split(int x, long newVersion) {
        BTreePageRef[] newChildRefs = new BTreePageRef[2];
        BTreeNode newLeftPage = this.splitLeft(x, newVersion);
        BTreeNode newRightPage = this.splitRight(x, newVersion);
        newChildRefs[0] = newLeftPage.pageRef();
        newChildRefs[1] = newRightPage.pageRef();
        Value[] newKnotKeys = new Value[]{newRightPage.minKey()};
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), newChildRefs, newKnotKeys);
    }

    @Override
    public BTreeNode splitLeft(int x, long newVersion) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        BTreePageRef[] newChildRefs = new BTreePageRef[x + 1];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, x + 1);
        Value[] oldKnotKeys = this.knotKeys;
        Value[] newKnotKeys = new Value[x];
        System.arraycopy(oldKnotKeys, 0, newKnotKeys, 0, x);
        long newSpan = 0L;
        for (int i = 0; i <= x; ++i) {
            newSpan += newChildRefs[i].span();
        }
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
    }

    @Override
    public BTreeNode splitRight(int x, long newVersion) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        int y = oldChildRefs.length - (x + 1);
        BTreePageRef[] newChildRefs = new BTreePageRef[y];
        System.arraycopy(oldChildRefs, x + 1, newChildRefs, 0, y);
        Value[] oldKnotKeys = this.knotKeys;
        Value[] newKnotKeys = new Value[y - 1];
        System.arraycopy(oldKnotKeys, x + 1, newKnotKeys, 0, y - 1);
        long newSpan = 0L;
        for (int i = 0; i < y; ++i) {
            newSpan += newChildRefs[i].span();
        }
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), newChildRefs, newKnotKeys);
    }

    @Override
    public int pageSize() {
        return this.pageRef.pageSize();
    }

    @Override
    public int diffSize() {
        return this.pageRef.diffSize();
    }

    @Override
    public long treeSize() {
        return this.pageRef.treeSize();
    }

    @Override
    void memoizeSize(BTreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        BTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        Value[] knotKeys = this.knotKeys;
        int diffSize = 0;
        long treeSize = 0L;
        if (n > 0) {
            ++pageSize;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    Value key = knotKeys[i - 1];
                    pageSize += 11;
                    pageSize += Recon.sizeOf((Item)key);
                    pageSize += 2;
                }
                BTreePageRef childRef = childRefs[i];
                pageSize += childRef.pageRefSize();
                if (this.version == childRef.softVersion()) {
                    diffSize += childRef.diffSize();
                }
                treeSize += childRef.treeSize();
            }
            ++pageSize;
            ++pageSize;
        }
        pageRef.pageSize = pageSize;
        pageRef.diffSize = diffSize += pageSize;
        pageRef.treeSize = treeSize += (long)pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("bnode", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        BTreePageRef[] childRefs = this.childRefs;
        Value[] knotKeys = this.knotKeys;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                record.add((Item)Record.create((int)1).attr("knot", (Value)Record.create((int)1).slot("key", knotKeys[i - 1])));
            }
            record.add((Item)childRefs[i].toValue());
        }
        return record;
    }

    @Override
    public BTreeNode reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        BTreePageRef[] newChildRefs = new BTreePageRef[n];
        for (int i = 0; i < n; ++i) {
            newChildRefs[i] = oldChildRefs[i].reduced(identity, accumulator, combiner, newVersion);
        }
        Value fold = newChildRefs[0].fold();
        for (int i = 1; i < n; ++i) {
            fold = (Value)combiner.combine((Object)fold, (Object)newChildRefs[i].fold());
        }
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, fold, newChildRefs, this.knotKeys);
    }

    @Override
    public BTreeNode evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            BTreePageRef[] oldChildRefs = this.childRefs;
            int n = oldChildRefs.length;
            BTreePageRef[] newChildRefs = new BTreePageRef[n];
            for (int i = 0; i < n; ++i) {
                BTreePageRef newChildRef;
                BTreePageRef oldChildRef = oldChildRefs[i];
                newChildRefs[i] = newChildRef = oldChildRef.evacuated(post, version);
                if (oldChildRef == newChildRef) continue;
                if (++i < n) {
                    System.arraycopy(oldChildRefs, i, newChildRefs, i, n - i);
                }
                return BTreeNode.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.span, this.pageRef.fold, newChildRefs, this.knotKeys);
            }
        }
        return this;
    }

    @Override
    public BTreeNode committed(int zone, long base, long version) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        BTreePageRef[] newChildRefs = new BTreePageRef[n];
        long step = base;
        for (int i = 0; i < n; ++i) {
            BTreePageRef oldChildRef = oldChildRefs[i];
            if (!oldChildRef.isCommitted()) {
                BTreePageRef newChildRef;
                newChildRefs[i] = newChildRef = oldChildRef.committed(zone, step, version);
                step += (long)newChildRef.diffSize();
                continue;
            }
            newChildRefs[i] = oldChildRef;
        }
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, version, zone, step, this.pageRef.span, this.pageRef.fold, newChildRefs, this.knotKeys);
    }

    @Override
    public BTreeNode uncommitted(long version) {
        BTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        BTreePageRef[] newChildRefs = new BTreePageRef[n];
        for (int i = 0; i < n; ++i) {
            newChildRefs[i] = oldChildRefs[i].uncommitted(version);
        }
        return BTreeNode.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.span, this.pageRef.fold, newChildRefs, this.knotKeys);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write(output, (Item)this.toHeader());
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        BTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        Value[] knotKeys = this.knotKeys;
        if (n > 0) {
            output.write(123);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    output.write(44).write(64).write(107).write(110).write(111).write(116).write(40).write(107).write(101).write(121).write(58);
                    Recon.write(output, (Item)knotKeys[i - 1]);
                    output.write(41).write(44);
                }
                childRefs[i].writePageRef(output);
            }
            output.write(125);
        }
    }

    @Override
    public void writeDiff(Output<?> output) {
        for (BTreePageRef childRef : this.childRefs) {
            if (this.version != childRef.softVersion()) continue;
            childRef.writeDiff(output);
        }
        this.writePage(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        for (BTreePageRef childRef : this.childRefs) {
            if (this.version != childRef.softVersion()) continue;
            childRef.buildDiff(builder);
        }
        builder.add((Object)this);
    }

    @Override
    public BTreePage loadTree(PageLoader pageLoader) {
        BTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            childRefs[i].loadTree(pageLoader);
        }
        return this;
    }

    @Override
    public void soften(long version) {
        BTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            childRefs[i].soften(version);
        }
    }

    @Override
    public OrderedMapCursor<Value, Value> cursor() {
        return new BTreeNodeDepthCursor(this, Integer.MAX_VALUE);
    }

    @Override
    public OrderedMapCursor<Value, Value> depthCursor(int maxDepth) {
        return new BTreeNodeDepthCursor(this, maxDepth);
    }

    @Override
    public OrderedMapCursor<Value, Value> deltaCursor(long sinceVersion) {
        return new BTreeNodeDeltaCursor(this, sinceVersion);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Output)output, (Item)this.toHeader());
        this.writePageContent(output);
        return (String)output.bind();
    }

    public static BTreeNode create(PageContext context, int stem, long version, int post, int zone, long base, long span, Value fold, BTreePageRef[] childRefs, Value[] knotKeys) {
        BTreePageRef pageRef = new BTreePageRef(context, PageType.NODE, stem, post, zone, base, span, fold);
        BTreeNode page = new BTreeNode(pageRef, version, childRefs, knotKeys);
        pageRef.page = page;
        return page;
    }

    public static BTreeNode create(PageContext context, int stem, long version, int zone, long base, long span, Value fold, BTreePageRef[] childRefs, Value[] knotKeys) {
        int post = zone;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            int childPost = childRefs[i].post;
            if (childPost == 0) continue;
            post = post == 0 ? childPost : Math.min(post, childPost);
        }
        return BTreeNode.create(context, stem, version, post, zone, base, span, fold, childRefs, knotKeys);
    }

    public static BTreeNode create(PageContext context, int stem, long version, long span, Value fold, BTreePageRef[] childRefs, Value[] knotKeys) {
        return BTreeNode.create(context, stem, version, 0, 0L, span, fold, childRefs, knotKeys);
    }

    public static BTreeNode fromValue(BTreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("bnode");
            long version = header.get("v").longValue();
            Record tail = value.tail();
            int n = tail.size() >>> 1;
            BTreePageRef[] childRefs = new BTreePageRef[n + 1];
            Value[] knotKeys = new Value[n];
            childRefs[0] = BTreePageRef.fromValue(pageRef.context, pageRef.stem, tail.get(0).toValue());
            for (int i = 1; i <= n; ++i) {
                knotKeys[i - 1] = tail.get(2 * i - 1).header("knot").get("key");
                childRefs[i] = BTreePageRef.fromValue(pageRef.context, pageRef.stem, tail.get(2 * i).toValue());
            }
            return new BTreeNode(pageRef, version, childRefs, knotKeys);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed bnode: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

