/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.collections.HashTrieMap;
import swim.db.FileStore;
import swim.db.FileZone;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.StoreException;
import swim.db.TreeDelegate;

final class FilePageLoader
extends PageLoader {
    final FileStore store;
    final TreeDelegate treeDelegate;
    final boolean isResident;
    volatile HashTrieMap<Integer, FileChannel> channels;
    static final AtomicReferenceFieldUpdater<FilePageLoader, HashTrieMap<Integer, FileChannel>> CHANNELS = AtomicReferenceFieldUpdater.newUpdater(FilePageLoader.class, HashTrieMap.class, "channels");

    FilePageLoader(FileStore store, TreeDelegate treeDelegate, boolean isResident) {
        this.store = store;
        this.treeDelegate = treeDelegate;
        this.isResident = isResident;
        this.channels = HashTrieMap.empty();
    }

    @Override
    public boolean isResident() {
        return this.isResident;
    }

    @Override
    public Page loadPage(PageRef pageRef) {
        int zoneId = pageRef.zone();
        FileZone zone = this.store.openZone(zoneId);
        return this.loadPage(zone, pageRef);
    }

    Page loadPage(FileZone zone, PageRef pageRef) {
        FileChannel channel;
        block6: {
            HashTrieMap<Integer, FileChannel> oldChannels;
            FileChannel oldChannel;
            Integer zoneId = zone.id;
            channel = null;
            while ((oldChannel = (FileChannel)(oldChannels = this.channels).get((Object)zoneId)) == null) {
                try {
                    channel = zone.openReadChannel();
                }
                catch (IOException cause) {
                    throw new StoreException(cause);
                }
                HashTrieMap newChannels = oldChannels.updated((Object)zoneId, (Object)channel);
                if (!CHANNELS.compareAndSet(this, oldChannels, (HashTrieMap<Integer, FileChannel>)newChannels)) continue;
                break block6;
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException swallow) {
                    swallow.printStackTrace();
                }
            }
            channel = oldChannel;
        }
        return zone.loadPage(channel, pageRef, this.treeDelegate, this.isResident);
    }

    @Override
    public void close() {
        HashTrieMap newChannels;
        HashTrieMap<Integer, FileChannel> oldChannels;
        while ((oldChannels = this.channels) != (newChannels = HashTrieMap.empty())) {
            if (!CHANNELS.compareAndSet(this, oldChannels, (HashTrieMap<Integer, FileChannel>)newChannels)) continue;
            Iterator channelIterator = oldChannels.valueIterator();
            while (channelIterator.hasNext()) {
                try {
                    ((FileChannel)channelIterator.next()).close();
                }
                catch (IOException swallow) {
                    swallow.printStackTrace();
                }
            }
            break block2;
        }
    }
}

