/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.StoreSettings;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Cursor;

public abstract class PageRef {
    PageRef() {
    }

    public abstract PageContext pageContext();

    public StoreSettings settings() {
        return this.pageContext().settings();
    }

    public abstract PageType pageType();

    public abstract int stem();

    public abstract int post();

    public abstract int zone();

    public abstract long base();

    public abstract long span();

    public abstract Value fold();

    public abstract Page page();

    public abstract Page hardPage();

    public abstract Page softPage();

    public abstract long softVersion();

    public abstract boolean isEmpty();

    public abstract boolean isCommitted();

    public abstract int pageRefSize();

    public abstract int pageSize();

    public abstract int diffSize();

    public abstract long treeSize();

    public abstract Value toValue();

    public abstract PageRef evacuated(int var1, long var2);

    public abstract PageRef committed(int var1, long var2, long var4);

    public abstract PageRef uncommitted(long var1);

    public abstract void writePageRef(Output<?> var1);

    public abstract void writePage(Output<?> var1);

    public abstract void writeDiff(Output<?> var1);

    public abstract void buildDiff(Builder<Page, ?> var1);

    public abstract Page setPageValue(Value var1, boolean var2);

    public abstract Page loadPage(boolean var1);

    public abstract Page loadPage(PageLoader var1);

    public abstract Page loadTree(boolean var1);

    public abstract Page loadTree(PageLoader var1);

    public abstract void soften(long var1);

    public abstract Cursor<? extends Object> cursor();

    public String toDebugString() {
        return "stem: " + this.stem() + ", pageRef: " + Recon.toString((Item)this.toValue());
    }
}

