/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.util.NoSuchElementException;
import swim.db.QTreeLeaf;
import swim.spatial.BitInterval;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Cursor;

class QTreeLeafCursor
implements Cursor<Slot> {
    final QTreeLeaf page;
    final long x;
    final long y;
    int index;

    QTreeLeafCursor(QTreeLeaf page, long x, long y, int index) {
        this.page = page;
        this.x = x;
        this.y = y;
        this.index = index;
    }

    QTreeLeafCursor(QTreeLeaf page, long x, long y) {
        this(page, x, y, 0);
    }

    protected Slot getSlot(Slot slot) {
        return slot.updatedValue(slot.toValue().body());
    }

    public boolean isEmpty() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index < slots.length) {
            long yt;
            Slot slot = slots[this.index];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) continue;
            return false;
        }
        return true;
    }

    public Slot head() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index < slots.length) {
            long yt;
            Slot slot = slots[this.index];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) continue;
            return this.getSlot(slot);
        }
        throw new NoSuchElementException();
    }

    public void step() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index < slots.length) {
            long yt;
            Slot slot = slots[this.index];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) continue;
            ++this.index;
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException();
        }
        this.index = Math.min(this.index + (int)count, this.page.slots.length);
    }

    public boolean hasNext() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index < slots.length) {
            long yt;
            Slot slot = slots[this.index];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    public long nextIndexLong() {
        return this.nextIndex();
    }

    public int nextIndex() {
        return this.index;
    }

    public Slot next() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index < slots.length) {
            Slot slot = slots[this.index];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            ++this.index;
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)yt)) continue;
            return this.getSlot(slot);
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index > 0) {
            long yt;
            Slot slot = slots[this.index - 1];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            if (BitInterval.intersects((long)x, (long)y, (long)xt, (long)(yt = tile.getItem(1).longValue()))) {
                return true;
            }
            --this.index;
        }
        return false;
    }

    public long previousIndexLong() {
        return this.previousIndex();
    }

    public int previousIndex() {
        return this.index - 1;
    }

    public Slot previous() {
        long x = this.x;
        long y = this.y;
        Slot[] slots = this.page.slots;
        while (this.index > 0) {
            Slot slot = slots[this.index - 1];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            --this.index;
            if (!BitInterval.intersects((long)x, (long)y, (long)xt, (long)yt)) continue;
            return this.getSlot(slot);
        }
        throw new NoSuchElementException();
    }
}

