/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.lang.ref.WeakReference;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageRef;
import swim.db.PageType;
import swim.db.QTreeLeaf;
import swim.db.QTreePage;
import swim.db.QTreePageRefCursor;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class QTreePageRef
extends PageRef {
    final PageContext context;
    final PageType pageType;
    final int stem;
    final int post;
    final int zone;
    final long base;
    final long span;
    final long x;
    final long y;
    final Value fold;
    Object page;
    int pageRefSize;
    int pageSize;
    int diffSize;
    long treeSize;

    public QTreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, long x, long y, Value fold, Object page, int pageRefSize, int pageSize, int diffSize, long treeSize) {
        this.context = context;
        this.pageType = pageType;
        this.stem = stem;
        this.post = post;
        this.zone = zone;
        this.base = base;
        this.span = span;
        this.x = x;
        this.y = y;
        this.fold = fold;
        this.page = page;
        this.pageRefSize = pageRefSize;
        this.pageSize = pageSize;
        this.diffSize = diffSize;
        this.treeSize = treeSize;
    }

    public QTreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, long x, long y, Value fold, Object page) {
        this(context, pageType, stem, post, zone, base, span, x, y, fold, page, -1, -1, -1, -1L);
    }

    public QTreePageRef(PageContext context, PageType pageType, int stem, int post, int zone, long base, long span, long x, long y, Value fold) {
        this(context, pageType, stem, post, zone, base, span, x, y, fold, null, -1, -1, -1, -1L);
    }

    @Override
    public PageContext pageContext() {
        return this.context;
    }

    @Override
    public PageType pageType() {
        return this.pageType;
    }

    @Override
    public int stem() {
        return this.stem;
    }

    @Override
    public int post() {
        return this.post;
    }

    @Override
    public int zone() {
        return this.zone;
    }

    @Override
    public long base() {
        return this.base;
    }

    @Override
    public long span() {
        return this.span;
    }

    public long x() {
        return this.x;
    }

    public int xRank() {
        return Long.numberOfLeadingZeros(this.x ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long xBase() {
        return this.x << this.xRank();
    }

    public long xMask() {
        return (1L << this.xRank()) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public long xSplit() {
        return this.x << 1 & 1L;
    }

    public long y() {
        return this.y;
    }

    public int yRank() {
        return Long.numberOfLeadingZeros(this.y ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long yBase() {
        return this.y << this.yRank();
    }

    public long yMask() {
        return (1L << this.yRank()) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public long ySplit() {
        return this.y << 1 & 1L;
    }

    @Override
    public Value fold() {
        return this.fold;
    }

    @Override
    public QTreePage page() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof QTreePage) {
            this.context.hitPage((QTreePage)page);
            return (QTreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(false);
        try {
            QTreePage qTreePage = (QTreePage)pageLoader.loadPage(this);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return qTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public QTreePage hardPage() {
        Object page = this.page;
        if (page instanceof QTreePage) {
            return (QTreePage)page;
        }
        return null;
    }

    @Override
    public QTreePage softPage() {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof QTreePage) {
            return (QTreePage)page;
        }
        return null;
    }

    @Override
    public long softVersion() {
        QTreePage page = this.softPage();
        if (page != null) {
            return page.version();
        }
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.span == 0L;
    }

    @Override
    public boolean isCommitted() {
        return this.zone > 0 && this.base > 0L;
    }

    @Override
    public int pageRefSize() {
        int pageRefSize = this.pageRefSize;
        if (pageRefSize < 0) {
            pageRefSize = 5;
            if (this.post != this.zone) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)Num.from((int)this.post));
            }
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.zone));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.base));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((int)this.pageSize()));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.treeSize()));
            pageRefSize += 6;
            pageRefSize += Recon.sizeOf((Item)Num.from((long)this.span));
            pageRefSize += 3;
            pageRefSize += 18;
            pageRefSize += 3;
            pageRefSize += 18;
            Value fold = this.fold();
            if (fold.isDefined()) {
                pageRefSize += 6;
                pageRefSize += Recon.sizeOf((Item)fold);
            }
            this.pageRefSize = ++pageRefSize;
        }
        return pageRefSize;
    }

    @Override
    public int pageSize() {
        if (this.pageSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.pageSize;
    }

    @Override
    public int diffSize() {
        if (this.diffSize < 0) {
            this.page().memoizeSize(this);
        }
        return this.diffSize;
    }

    @Override
    public long treeSize() {
        if (this.treeSize < 0L) {
            this.page().memoizeSize(this);
        }
        return this.treeSize;
    }

    @Override
    public Value toValue() {
        Record header = Record.create((int)9);
        if (this.post != this.zone) {
            header.slot("post", this.post);
        }
        header.slot("zone", this.zone).slot("base", this.base).slot("size", this.pageSize()).slot("area", this.treeSize()).slot("span", this.span).slot("x", (Value)Num.uint64((long)this.x)).slot("y", (Value)Num.uint64((long)this.y));
        Value fold = this.fold();
        if (fold.isDefined()) {
            header.slot("fold", fold);
        }
        return Record.create((int)1).attr(this.pageType.tag(), (Value)header);
    }

    public QTreePageRef reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        if (!this.fold.isDefined()) {
            return this.page().reduced(identity, accumulator, combiner, newVersion).pageRef();
        }
        return this;
    }

    @Override
    public QTreePageRef evacuated(int post, long version) {
        if (this.post != 0 && this.post < post) {
            QTreePage page = this.page();
            try {
                return page.evacuated(post, version).pageRef();
            }
            catch (Throwable cause) {
                if (Cont.isNonFatal((Throwable)cause)) {
                    throw new StoreException(cause);
                }
                throw new StoreException(this.toDebugString(), cause);
            }
        }
        return this;
    }

    @Override
    public QTreePageRef committed(int zone, long base, long version) {
        QTreePage page = this.hardPage();
        if (page != null) {
            return page.committed(zone, base, version).pageRef();
        }
        return this;
    }

    @Override
    public QTreePageRef uncommitted(long version) {
        QTreePage page = this.hardPage();
        if (page != null && page.version() >= version) {
            return page.uncommitted(version).pageRef();
        }
        return this;
    }

    @Override
    public void writePageRef(Output<?> output) {
        Recon.write(output, (Item)this.toValue());
    }

    @Override
    public void writePage(Output<?> output) {
        this.page().writePage(output);
    }

    @Override
    public void writeDiff(Output<?> output) {
        this.page().writeDiff(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        this.page().buildDiff(builder);
    }

    @Override
    public QTreePage setPageValue(Value value, boolean isResident) {
        QTreePage page = QTreePage.fromValue(this, value);
        if (isResident) {
            this.page = page;
        } else {
            this.context.hitPage(page);
            this.page = new WeakReference<QTreePage>(page);
        }
        return page;
    }

    @Override
    public QTreePage loadPage(boolean isResident) {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof QTreePage) {
            this.context.hitPage((QTreePage)page);
            return (QTreePage)page;
        }
        PageLoader pageLoader = this.context.openPageLoader(isResident);
        try {
            QTreePage qTreePage = (QTreePage)pageLoader.loadPage(this);
            if (pageLoader != null) {
                pageLoader.close();
            }
            return qTreePage;
        }
        catch (Throwable throwable) {
            try {
                if (pageLoader != null) {
                    try {
                        pageLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable error) {
                if (Cont.isNonFatal((Throwable)error)) {
                    throw new StoreException(this.toDebugString(), error);
                }
                throw error;
            }
        }
    }

    @Override
    public QTreePage loadPage(PageLoader pageLoader) {
        Object page = this.page;
        if (page instanceof WeakReference) {
            page = ((WeakReference)page).get();
        }
        if (page instanceof QTreePage) {
            this.context.hitPage((QTreePage)page);
            return (QTreePage)page;
        }
        try {
            return (QTreePage)pageLoader.loadPage(this);
        }
        catch (Throwable error) {
            if (Cont.isNonFatal((Throwable)error)) {
                throw new StoreException(this.toDebugString(), error);
            }
            throw error;
        }
    }

    @Override
    public QTreePage loadTree(boolean isResident) {
        try (PageLoader pageLoader = this.context.openPageLoader(isResident);){
            QTreePage qTreePage = this.loadTree(pageLoader);
            return qTreePage;
        }
    }

    @Override
    public QTreePage loadTree(PageLoader pageLoader) {
        QTreePage page = this.loadPage(pageLoader);
        return page.loadTree(pageLoader);
    }

    @Override
    public void soften(long version) {
        Object page = this.page;
        if (page instanceof QTreePage) {
            if (((QTreePage)page).version() <= version && this.isCommitted()) {
                this.context.hitPage((QTreePage)page);
                this.page = new WeakReference<Object>(page);
            }
            ((QTreePage)page).soften(version);
        }
    }

    public Cursor<Slot> cursor() {
        return this.page().cursor();
    }

    public Cursor<Slot> cursor(long x, long y) {
        return this.page().cursor(x, y);
    }

    public Cursor<Slot> depthCursor(long x, long y, int maxDepth) {
        if (maxDepth > 0) {
            return this.page().depthCursor(x, y, maxDepth);
        }
        Value fold = this.fold();
        if (fold instanceof Record) {
            return new QTreePageRefCursor(this, (Record)fold);
        }
        if (fold.isDefined()) {
            return new QTreePageRefCursor(this, Record.of((Object)fold));
        }
        return new QTreePageRefCursor(this, Record.empty());
    }

    public Cursor<Slot> depthCursor(int maxDepth) {
        if (maxDepth > 0) {
            return this.page().depthCursor(maxDepth);
        }
        Value fold = this.fold();
        if (fold instanceof Record) {
            return new QTreePageRefCursor(this, (Record)fold);
        }
        if (fold.isDefined()) {
            return new QTreePageRefCursor(this, Record.of((Object)fold));
        }
        return new QTreePageRefCursor(this, Record.empty());
    }

    public Cursor<Slot> deltaCursor(long x, long y, long sinceVersion) {
        return this.page().deltaCursor(x, y, sinceVersion);
    }

    public Cursor<Slot> deltaCursor(long sinceVersion) {
        return this.page().deltaCursor(sinceVersion);
    }

    public Cursor<Slot> tileCursor(long x, long y) {
        return this.page().tileCursor(x, y);
    }

    public Cursor<Slot> tileCursor() {
        return this.page().tileCursor();
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)this.pageRefSize());
        this.writePageRef(output);
        return (String)output.bind();
    }

    public static QTreePageRef empty(PageContext context, int stem, long version) {
        return QTreeLeaf.empty(context, stem, version).pageRef();
    }

    public static QTreePageRef fromValue(PageContext context, int stem, Value value) {
        Throwable cause = null;
        try {
            String tag = value.tag();
            PageType pageType = PageType.fromTag(tag);
            if (pageType == null) {
                return null;
            }
            Value header = value.header(tag);
            int zone = header.get("zone").intValue();
            int post = header.get("post").intValue(zone);
            long base = header.get("base").longValue();
            int size = header.get("size").intValue();
            long area = header.get("area").longValue();
            long span = header.get("span").longValue();
            long x = header.get("x").longValue();
            long y = header.get("y").longValue();
            Value fold = header.get("fold");
            if (base < 0L) {
                throw new StoreException("negative page base: " + base);
            }
            if (size < 0) {
                throw new StoreException("negative page size: " + size);
            }
            if (area < 0L) {
                throw new StoreException("negative page area: " + area);
            }
            if (span < 0L) {
                throw new StoreException("negative page span: " + span);
            }
            return new QTreePageRef(context, pageType, stem, post, zone, base, span, x, y, fold, null, -1, size, 0, area);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed qtree page ref: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

