/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.Store;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.Zone;

public class StoreContext {
    protected final StoreSettings settings;

    public StoreContext(StoreSettings settings) {
        this.settings = settings;
    }

    public StoreContext() {
        this(StoreSettings.standard());
    }

    public final StoreSettings settings() {
        return this.settings;
    }

    public boolean pageShouldSplit(Store store, Database database, Page page) {
        return PageContext.pageShouldSplit(page, this.settings.pageSplitSize);
    }

    public boolean pageShouldMerge(Store store, Database database, Page page) {
        return PageContext.pageShouldMerge(page, this.settings.pageSplitSize);
    }

    public void hitPage(Store store, Database database, Page page) {
    }

    public void treeDidOpen(Store store, Database database, Tree tree) {
    }

    public void treeDidClose(Store store, Database database, Tree tree) {
    }

    public void treeDidChange(Store store, Database database, Tree newTree, Tree oldTree) {
        StoreContext.autoCommit(database, this.settings.minCommitSize, this.settings.minCommitInterval, Commit.forced());
    }

    public void databaseWillOpen(Store store, Database database) {
    }

    public void databaseDidOpen(Store store, Database database) {
    }

    public void databaseWillClose(Store store, Database database) {
    }

    public void databaseDidClose(Store store, Database database) {
    }

    public Commit databaseWillCommit(Store store, Database database, Commit commit) {
        return StoreContext.autoCommitShifted(store, this.settings.maxZoneSize, commit);
    }

    public void databaseDidCommit(Store store, Database database, Chunk chunk) {
    }

    public void databaseCommitDidFail(Store store, Database database, Throwable error) {
        error.printStackTrace();
    }

    public void databaseWillCompact(Store store, Database database, int post) {
    }

    public void databaseDidCompact(Store store, Database database, int post) {
    }

    public void databaseCompactDidFail(Store store, Database database, Throwable error) {
        error.printStackTrace();
    }

    public void databaseDidShiftZone(Store store, Database database, Zone newZone) {
    }

    public void databaseDidDeleteZone(Store store, Database database, int zoneId) {
    }

    public static boolean autoCommit(Database database, long minCommitSize, long minCommitInterval, Commit commit) {
        if (database.isCompacting() || minCommitInterval > 0L && (database.diffSize() > minCommitSize || System.currentTimeMillis() - database.germ().updated() > minCommitInterval)) {
            database.commitAsync(commit);
            return true;
        }
        return false;
    }

    public static Commit autoCommitShifted(Store store, long maxZoneSize, Commit commit) {
        if (store.zone().size() > maxZoneSize) {
            return commit.isShifted(true);
        }
        return commit;
    }
}

