/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.math.Z2Form;
import swim.spatial.SpatialMap;
import swim.structure.Item;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Cursor;

final class QTreeEntryCursor<S>
implements Cursor<SpatialMap.Entry<Value, S, Value>> {
    final Cursor<Slot> inner;
    final Z2Form<S> shapeForm;

    QTreeEntryCursor(Cursor<Slot> inner, Z2Form<S> shapeForm) {
        this.inner = inner;
        this.shapeForm = shapeForm;
    }

    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    public SpatialMap.Entry<Value, S, Value> head() {
        Slot slot = (Slot)this.inner.head();
        Value key = slot.key();
        Object shape = this.shapeForm.cast((Item)slot.toValue());
        Value value = slot.toValue().body();
        return new SpatialMap.SimpleEntry((Object)key, shape, (Object)value);
    }

    public void step() {
        this.inner.step();
    }

    public void skip(long count) {
        this.inner.skip(count);
    }

    public boolean hasNext() {
        return this.inner.hasNext();
    }

    public long nextIndexLong() {
        return this.inner.nextIndexLong();
    }

    public int nextIndex() {
        return this.inner.nextIndex();
    }

    public SpatialMap.Entry<Value, S, Value> next() {
        Slot slot = (Slot)this.inner.next();
        Value key = slot.key();
        Object shape = this.shapeForm.cast((Item)slot.toValue());
        Value value = slot.toValue().body();
        return new SpatialMap.SimpleEntry((Object)key, shape, (Object)value);
    }

    public boolean hasPrevious() {
        return this.inner.hasPrevious();
    }

    public long previousIndexLong() {
        return this.inner.previousIndexLong();
    }

    public int previousIndex() {
        return this.inner.previousIndex();
    }

    public SpatialMap.Entry<Value, S, Value> previous() {
        Slot slot = (Slot)this.inner.previous();
        Value key = slot.key();
        Object shape = this.shapeForm.cast((Item)slot.toValue());
        Value value = slot.toValue().body();
        return new SpatialMap.SimpleEntry((Object)key, shape, (Object)value);
    }

    public void load() {
        this.inner.load();
    }
}

