/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.concurrent.Cont;
import swim.db.Page;
import swim.db.PageContext;
import swim.db.PageLoader;
import swim.db.PageType;
import swim.db.QTreeLeaf;
import swim.db.QTreeNodeDeltaCursor;
import swim.db.QTreeNodeDepthCursor;
import swim.db.QTreeNodeTileCursor;
import swim.db.QTreePage;
import swim.db.QTreePageRef;
import swim.db.StoreException;
import swim.recon.Recon;
import swim.spatial.BitInterval;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Slot;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.CombinerFunction;
import swim.util.Cursor;

public final class QTreeNode
extends QTreePage {
    final QTreePageRef pageRef;
    final long version;
    final QTreePageRef[] childRefs;
    final Slot[] slots;

    protected QTreeNode(QTreePageRef pageRef, long version, QTreePageRef[] childRefs, Slot[] slots) {
        this.pageRef = pageRef;
        this.version = version;
        this.childRefs = childRefs;
        this.slots = slots;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public QTreePageRef pageRef() {
        return this.pageRef;
    }

    @Override
    public PageType pageType() {
        return PageType.NODE;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return this.pageRef.span == 0L;
    }

    @Override
    public int arity() {
        return this.childRefs.length + this.slots.length;
    }

    @Override
    public int childCount() {
        return this.childRefs.length;
    }

    @Override
    public QTreePageRef getChildRef(int index) {
        return this.childRefs[index];
    }

    @Override
    public QTreePage getChild(int index) {
        try {
            return this.childRefs[index].page();
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public int slotCount() {
        return this.slots.length;
    }

    @Override
    public Slot getSlot(int index) {
        return this.slots[index];
    }

    int scan(long xk, long yk) {
        QTreePageRef[] childRefs = this.childRefs;
        int j = 0;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            QTreePageRef childRef = childRefs[i];
            int order = BitInterval.compare((long)childRef.x, (long)childRef.y, (long)xk, (long)yk);
            if (order == 0) {
                return i;
            }
            if (order >= 0) continue;
            j = i;
        }
        return -(j + 1);
    }

    int lookup(long xk, long yk) {
        int yOrder;
        QTreePageRef[] childRefs = this.childRefs;
        int l = 0;
        int u = childRefs.length - 1;
        while (l <= u) {
            int i = l + u >>> 1;
            int xOrder = BitInterval.compare((long)childRefs[i].x, (long)xk);
            if (xOrder < 0) {
                l = i + 1;
                continue;
            }
            if (xOrder > 0) {
                u = i - 1;
                continue;
            }
            l = i + 1;
        }
        --l;
        while (l >= 0 && (yOrder = BitInterval.compare((long)childRefs[l].y, (long)yk)) >= 0) {
            if (yOrder > 0) {
                --l;
                continue;
            }
            return l;
        }
        if (l >= 0) {
            return -(l + 1);
        }
        return -1;
    }

    int lookup(Value key) {
        Slot[] slots = this.slots;
        int low = 0;
        int high = slots.length - 1;
        while (low <= high) {
            int i = low + high >>> 1;
            int order = key.compareTo((Item)slots[i].key());
            if (order > 0) {
                low = i + 1;
                continue;
            }
            if (order < 0) {
                high = i - 1;
                continue;
            }
            return i;
        }
        return -(low + 1);
    }

    @Override
    public boolean containsKey(Value key, long xk, long yk) {
        try {
            int xRank = Long.numberOfLeadingZeros(this.pageRef.x ^ 0xFFFFFFFFFFFFFFFFL);
            int yRank = Long.numberOfLeadingZeros(this.pageRef.y ^ 0xFFFFFFFFFFFFFFFFL);
            int xkRank = Long.numberOfLeadingZeros(xk ^ 0xFFFFFFFFFFFFFFFFL);
            int ykRank = Long.numberOfLeadingZeros(yk ^ 0xFFFFFFFFFFFFFFFFL);
            if (xkRank <= xRank && ykRank <= yRank) {
                QTreePageRef childRef;
                int i = this.scan(xk, yk);
                if (i >= 0 && xkRank <= (childRef = this.childRefs[i]).xRank() && ykRank <= childRef.yRank() && childRef.page().containsKey(key, xk, yk)) {
                    return true;
                }
                return this.lookup(key) >= 0;
            }
            return false;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public Value get(Value key, long xk, long yk) {
        try {
            int xRank = Long.numberOfLeadingZeros(this.pageRef.x ^ 0xFFFFFFFFFFFFFFFFL);
            int yRank = Long.numberOfLeadingZeros(this.pageRef.y ^ 0xFFFFFFFFFFFFFFFFL);
            int xkRank = Long.numberOfLeadingZeros(xk ^ 0xFFFFFFFFFFFFFFFFL);
            int ykRank = Long.numberOfLeadingZeros(yk ^ 0xFFFFFFFFFFFFFFFFL);
            if (xkRank <= xRank && ykRank <= yRank) {
                Value value;
                QTreePageRef childRef;
                int i = this.scan(xk, yk);
                if (i >= 0 && xkRank <= (childRef = this.childRefs[i]).xRank() && ykRank <= childRef.yRank() && (value = childRef.page().get(key, xk, yk)).isDefined()) {
                    return value;
                }
                i = this.lookup(key);
                if (i >= 0) {
                    return this.slots[i].toValue().body();
                }
            }
            return Value.absent();
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    QTreeNode updated(Value key, long xk, long yk, Value newValue, long newVersion, boolean canSplit) {
        try {
            QTreePageRef[] childRefs = this.childRefs;
            int n = childRefs.length;
            int j = this.lookup(xk, yk);
            int i = j >= 0 ? j : -(j + 1);
            QTreePage oldPage = childRefs[i].page();
            QTreePage newPage = oldPage.updated(key, xk, yk, newValue, newVersion);
            if (oldPage.x() == newPage.x() && oldPage.y() == newPage.y()) {
                if (canSplit && oldPage.span() != newPage.span() && this.pageRef.context.pageShouldSplit(newPage)) {
                    return this.updatedPageSplit(i, newPage, oldPage, newVersion);
                }
                return this.updatedPage(i, newPage, oldPage, newVersion);
            }
            return this.coalescePage(this, i, newPage, oldPage, newVersion);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    QTreeNode coalescePage(QTreeNode basePage, int i, QTreePage newPage, QTreePage oldPage, long newVersion) {
        try {
            while (true) {
                int j;
                if ((j = (basePage = basePage.removedPage(i, oldPage, newVersion)).scan(newPage.x(), newPage.y())) < 0) {
                    j = -(j + 1);
                    return basePage.insertedPageRef(j, newPage.pageRef(), newVersion).reinsertedSlots(newVersion);
                }
                i = j;
                oldPage = basePage.getChildRef(i).page();
                newPage = oldPage.mergedPage(newPage, newVersion);
            }
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    QTreeNode updatedPage(int i, QTreePage newPage, QTreePage oldPage, long newVersion) {
        QTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        Object[] newChildRefs = new QTreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, n);
        newChildRefs[i] = newPage.pageRef();
        BitInterval.sort((Object[])newChildRefs, QTreePage.PAGE_REF_ORDERING);
        long newSpan = this.pageRef.span - oldPage.span() + newPage.span();
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), (QTreePageRef[])newChildRefs, this.slots);
    }

    QTreeNode updatedPageSplit(int i, QTreePage newPage, QTreePage oldPage, long newVersion) {
        QTreeNode page = this.removedPage(i, oldPage, newVersion);
        QTreeNode subPage = newPage.split(newVersion);
        QTreePageRef[] subChildRefs = subPage.childRefs;
        int subChildCount = subChildRefs.length;
        if (subChildCount <= 1) {
            return this.updatedPage(i, newPage, oldPage, newVersion);
        }
        for (int j = 0; j < subChildCount; ++j) {
            page = page.insertedPageRef(subChildRefs[j], newVersion);
        }
        return page.mergedSlots(subPage.slots, newVersion);
    }

    QTreeNode updatedPageMerge(int i, QTreeNode newPage, QTreePage oldPage, long newVersion) {
        QTreeNode page = this.removedPage(i, oldPage, newVersion);
        QTreePageRef[] newChildRefs = newPage.childRefs;
        int childCount = newChildRefs.length;
        for (int j = 0; j < childCount; ++j) {
            page = page.insertedPageRef(newChildRefs[j], newVersion);
        }
        Slot[] newSlots = newPage.slots;
        int slotCount = newSlots.length;
        for (int j = 0; j < slotCount; ++j) {
            page = page.updatedSlot(newSlots[j], newVersion);
        }
        return page;
    }

    @Override
    QTreeNode mergedPage(QTreePage newPage, long newVersion) {
        int i;
        QTreeNode page = this;
        if (newPage.isNode()) {
            int childCount = newPage.childCount();
            for (i = 0; i < childCount; ++i) {
                page = page.insertedPageRef(newPage.getChildRef(i), newVersion);
            }
        }
        int slotCount = newPage.slotCount();
        for (i = 0; i < slotCount; ++i) {
            Slot slot = newPage.getSlot(i);
            Value key = slot.key();
            Value tile = slot.toValue().header("tile");
            long x = tile.getItem(0).longValue();
            long y = tile.getItem(1).longValue();
            Value value = slot.toValue().body();
            page = page.updated(key, x, y, value, newVersion, false);
        }
        return page;
    }

    @Override
    QTreeNode mergedSlots(Slot[] subSlots, long newVersion) {
        if (subSlots.length > 0) {
            Slot[] oldSlots = this.slots;
            Object[] newSlots = new Slot[oldSlots.length + subSlots.length];
            System.arraycopy(oldSlots, 0, newSlots, 0, oldSlots.length);
            System.arraycopy(subSlots, 0, newSlots, oldSlots.length, subSlots.length);
            BitInterval.sort((Object[])newSlots, QTreePage.SLOT_ORDERING);
            long newSpan = this.pageRef.span + (long)subSlots.length;
            return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), this.childRefs, (Slot[])newSlots);
        }
        return this;
    }

    QTreeNode reinsertedSlots(long newVersion) {
        QTreeNode page = this;
        Slot[] oldSlots = this.slots;
        int oldSlotCount = oldSlots.length;
        Slot[] newSlots = null;
        int newSlotCount = 0;
        for (int i = 0; i < oldSlotCount; ++i) {
            long y;
            Slot slot = oldSlots[i];
            Value tile = slot.toValue().header("tile");
            long x = tile.getItem(0).longValue();
            int j = page.lookup(x, y = tile.getItem(1).longValue());
            if (j >= 0) {
                Value key = slot.key();
                Value value = slot.toValue().body();
                page = page.updated(key, x, y, value, newVersion, false);
                if (newSlots != null) continue;
                newSlots = new Slot[oldSlotCount - 1];
                System.arraycopy(oldSlots, 0, newSlots, 0, i);
                newSlotCount = i;
                continue;
            }
            if (newSlots == null) continue;
            newSlots[newSlotCount] = slot;
            ++newSlotCount;
        }
        if (newSlots != null) {
            if (newSlotCount == 0) {
                newSlots = QTreePage.EMPTY_SLOTS;
            } else if (newSlotCount < oldSlotCount - 1) {
                Slot[] resizedSlots = new Slot[newSlotCount];
                System.arraycopy(newSlots, 0, resizedSlots, 0, newSlotCount);
                newSlots = resizedSlots;
            }
            return QTreeNode.create(page.pageRef.context, page.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), page.childRefs, newSlots);
        }
        return page;
    }

    @Override
    QTreeNode insertedPageRef(QTreePageRef newPageRef, long newVersion) {
        try {
            int i = this.lookup(newPageRef.x(), newPageRef.y());
            if (i < 0) {
                i = -(i + 1);
                return this.insertedPageRef(i, newPageRef, newVersion);
            }
            return this.mergedPage(newPageRef.page(), newVersion);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    QTreeNode insertedPageRef(int i, QTreePageRef newPageRef, long newVersion) {
        QTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length + 1;
        Object[] newChildRefs = new QTreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, i);
        newChildRefs[i] = newPageRef;
        System.arraycopy(oldChildRefs, i, newChildRefs, i + 1, n - (i + 1));
        BitInterval.sort((Object[])newChildRefs, QTreePage.PAGE_REF_ORDERING);
        long newSpan = this.pageRef.span + newPageRef.span();
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), (QTreePageRef[])newChildRefs, this.slots);
    }

    QTreeNode insertedSlot(int i, Value key, long xk, long yk, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        newSlots[i] = QTreeNode.slot(key, xk, yk, newValue);
        System.arraycopy(oldSlots, i, newSlots, i + 1, n - (i + 1));
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span + 1L, Value.absent(), this.childRefs, newSlots);
    }

    QTreeNode updatedSlot(Value key, long xk, long yk, Value newValue, long newVersion) {
        return this.updatedSlot(QTreeNode.slot(key, xk, yk, newValue), newVersion);
    }

    QTreeNode updatedSlot(int i, Value key, long xk, long yk, Value newValue, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot oldSlot = oldSlots[i];
        Value oldTile = oldSlot.toValue().header("tile");
        long oldX = oldTile.getItem(0).longValue();
        long oldY = oldTile.getItem(1).longValue();
        if (!newValue.equals((Object)oldSlot.toValue()) || oldX != xk || oldY != yk) {
            int n = oldSlots.length;
            Slot[] newSlots = new Slot[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = QTreeNode.slot(key, xk, yk, newValue);
            return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), this.childRefs, newSlots);
        }
        return this;
    }

    @Override
    QTreeNode updatedSlot(Slot newSlot, long newVersion) {
        int i = this.lookup(newSlot.key());
        if (i >= 0) {
            return this.updatedSlot(i, newSlot, newVersion);
        }
        i = -(i + 1);
        return this.insertedSlot(i, newSlot, newVersion);
    }

    QTreeNode updatedSlot(int i, Slot newSlot, long newVersion) {
        Slot[] oldSlots = this.slots;
        Slot oldSlot = oldSlots[i];
        if (!newSlot.equals((Object)oldSlot)) {
            int n = oldSlots.length;
            Slot[] newSlots = new Slot[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = newSlot.commit();
            return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), this.childRefs, newSlots);
        }
        return this;
    }

    QTreeNode insertedSlot(int i, Slot newSlot, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        newSlots[i] = newSlot.commit();
        System.arraycopy(oldSlots, i, newSlots, i + 1, n - (i + 1));
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), this.childRefs, newSlots);
    }

    @Override
    public QTreePage removed(Value key, long xk, long yk, long newVersion) {
        int xRank = Long.numberOfLeadingZeros(this.pageRef.x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(this.pageRef.y ^ 0xFFFFFFFFFFFFFFFFL);
        int xkRank = Long.numberOfLeadingZeros(xk ^ 0xFFFFFFFFFFFFFFFFL);
        int ykRank = Long.numberOfLeadingZeros(yk ^ 0xFFFFFFFFFFFFFFFFL);
        if (xkRank <= xRank && ykRank <= yRank) {
            QTreePage newPage;
            QTreePage oldPage;
            int i = this.scan(xk, yk);
            if (i >= 0 && (oldPage = this.getChild(i)) != (newPage = oldPage.removed(key, xk, yk, newVersion))) {
                return this.replacedPage(i, newPage, oldPage, newVersion);
            }
            i = this.lookup(key);
            if (i >= 0) {
                return this.removedSlot(i, newVersion);
            }
        }
        return this;
    }

    QTreePage replacedPage(int i, QTreePage newPage, QTreePage oldPage, long newVersion) {
        if (!newPage.isEmpty()) {
            if (newPage.isNode() && this.pageRef.context.pageShouldMerge(newPage)) {
                return this.updatedPageMerge(i, (QTreeNode)newPage, oldPage, newVersion);
            }
            return this.updatedPage(i, newPage, oldPage, newVersion);
        }
        if (this.childRefs.length > 2) {
            return this.removedPage(i, oldPage, newVersion);
        }
        if (this.childRefs.length > 1) {
            QTreePage onlyChild = i == 0 ? this.getChild(1) : this.getChild(0);
            if (this.slots.length == 0) {
                return onlyChild;
            }
            return onlyChild.mergedSlots(this.slots, newVersion);
        }
        if (this.slots.length > 0) {
            return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), this.slots);
        }
        return QTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
    }

    QTreeNode removedPage(int i, QTreePage oldPage, long newVersion) {
        QTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length - 1;
        Object[] newChildRefs = new QTreePageRef[n];
        System.arraycopy(oldChildRefs, 0, newChildRefs, 0, i);
        System.arraycopy(oldChildRefs, i + 1, newChildRefs, i, n - i);
        BitInterval.sort((Object[])newChildRefs, QTreePage.PAGE_REF_ORDERING);
        long newSpan = this.pageRef.span - oldPage.span();
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, newSpan, Value.absent(), (QTreePageRef[])newChildRefs, this.slots);
    }

    QTreeNode removedSlot(int i, long newVersion) {
        Slot[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        Slot[] newSlots = new Slot[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, i);
        System.arraycopy(oldSlots, i + 1, newSlots, i, n - i);
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span - 1L, Value.absent(), this.childRefs, newSlots);
    }

    @Override
    public QTreePage flattened(long newVersion) {
        try {
            QTreePageRef[] childRefs = this.childRefs;
            Slot[] slots = this.slots;
            if (childRefs.length > 1) {
                return this;
            }
            if (childRefs.length == 1) {
                QTreePage child = childRefs[0].page();
                if (slots.length == 0) {
                    return child;
                }
                return child.mergedSlots(slots, newVersion);
            }
            if (slots.length > 0) {
                return QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), slots);
            }
            return QTreeLeaf.empty(this.pageRef.context, this.pageRef.stem, newVersion);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException(this.toDebugString(), cause);
            }
            throw cause;
        }
    }

    @Override
    public QTreeNode balanced(long newVersion) {
        if (this.childRefs.length > 1 && this.pageRef.context.pageShouldSplit(this)) {
            return this.split(newVersion);
        }
        return this;
    }

    @Override
    QTreeNode split(long newVersion) {
        Slot[] newSlots;
        QTreePageRef[] newChildRefs;
        long x = this.pageRef.x;
        long y = this.pageRef.y;
        int xRank = Long.numberOfLeadingZeros(x ^ 0xFFFFFFFFFFFFFFFFL);
        int yRank = Long.numberOfLeadingZeros(y ^ 0xFFFFFFFFFFFFFFFFL);
        int xnRank = Math.max(0, xRank - 1);
        int ynRank = Math.max(0, yRank - 1);
        long xnMask = (1L << xnRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long ynMask = (1L << ynRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long x0Base = x << xRank;
        long y0Base = y << yRank;
        long x1Base = x0Base | 1L << xnRank;
        long y1Base = y0Base | 1L << ynRank;
        int x00Rank = 0;
        int y00Rank = 0;
        int x01Rank = 0;
        int y01Rank = 0;
        int x10Rank = 0;
        int y10Rank = 0;
        int x11Rank = 0;
        int y11Rank = 0;
        int xX0Rank = 0;
        int yX0Rank = 0;
        int xX1Rank = 0;
        int yX1Rank = 0;
        long x00Base = 0L;
        long y00Base = 0L;
        long x01Base = 0L;
        long y01Base = 0L;
        long x10Base = 0L;
        long y10Base = 0L;
        long x11Base = 0L;
        long y11Base = 0L;
        long xX0Base = 0L;
        long yX0Base = 0L;
        long xX1Base = 0L;
        long yX1Base = 0L;
        long x00Mask = -1L;
        long y00Mask = -1L;
        long x01Mask = -1L;
        long y01Mask = -1L;
        long x10Mask = -1L;
        long y10Mask = -1L;
        long x11Mask = -1L;
        long y11Mask = -1L;
        long xX0Mask = -1L;
        long yX0Mask = -1L;
        long xX1Mask = -1L;
        long yX1Mask = -1L;
        QTreePageRef[] childRefs = this.childRefs;
        Object[] childRefs00 = null;
        Object[] childRefs01 = null;
        Object[] childRefs10 = null;
        Object[] childRefs11 = null;
        int childCount = childRefs.length;
        int childCount00 = 0;
        int childCount01 = 0;
        int childCount10 = 0;
        int childCount11 = 0;
        long span00 = 0L;
        long span01 = 0L;
        long span10 = 0L;
        long span11 = 0L;
        for (int i = 0; i < childCount; ++i) {
            QTreePageRef childRef = childRefs[i];
            long xc = childRef.x;
            long yc = childRef.y;
            int xcRank = Long.numberOfLeadingZeros(xc ^ 0xFFFFFFFFFFFFFFFFL);
            int ycRank = Long.numberOfLeadingZeros(yc ^ 0xFFFFFFFFFFFFFFFFL);
            long xcBase = xc << xcRank;
            long ycBase = yc << ycRank;
            long xcNorm = xcBase & xnMask;
            long ycNorm = ycBase & ynMask;
            if (xcNorm == x0Base) {
                if (ycNorm == y0Base) {
                    if (childRefs00 == null) {
                        childRefs00 = new QTreePageRef[childCount];
                    }
                    childRefs00[childCount00] = childRef;
                    ++childCount00;
                    span00 += childRef.span;
                    x00Rank = Math.max(x00Rank, xcRank);
                    y00Rank = Math.max(y00Rank, ycRank);
                    x00Base |= xcBase;
                    y00Base |= ycBase;
                    x00Mask &= xcBase;
                    y00Mask &= ycBase;
                    continue;
                }
                if (childRefs01 == null) {
                    childRefs01 = new QTreePageRef[childCount];
                }
                childRefs01[childCount01] = childRef;
                ++childCount01;
                span01 += childRef.span;
                x01Rank = Math.max(x01Rank, xcRank);
                y01Rank = Math.max(y01Rank, ycRank);
                x01Base |= xcBase;
                y01Base |= ycBase;
                x01Mask &= xcBase;
                y01Mask &= ycBase;
                continue;
            }
            if (ycNorm == y0Base) {
                if (childRefs10 == null) {
                    childRefs10 = new QTreePageRef[childCount];
                }
                childRefs10[childCount10] = childRef;
                ++childCount10;
                span10 += childRef.span;
                x10Rank = Math.max(x10Rank, xcRank);
                y10Rank = Math.max(y10Rank, ycRank);
                x10Base |= xcBase;
                y10Base |= ycBase;
                x10Mask &= xcBase;
                y10Mask &= ycBase;
                continue;
            }
            if (childRefs11 == null) {
                childRefs11 = new QTreePageRef[childCount];
            }
            childRefs11[childCount11] = childRef;
            ++childCount11;
            span11 += childRef.span;
            x11Rank = Math.max(x11Rank, xcRank);
            y11Rank = Math.max(y11Rank, ycRank);
            x11Base |= xcBase;
            y11Base |= ycBase;
            x11Mask &= xcBase;
            y11Mask &= ycBase;
        }
        Slot[] slots = this.slots;
        Object[] slots00 = null;
        Object[] slots01 = null;
        Object[] slots10 = null;
        Object[] slots11 = null;
        Slot[] slotsX0 = null;
        Slot[] slotsX1 = null;
        Object[] slotsXY = null;
        int slotCount = slots.length;
        int slotCount00 = 0;
        int slotCount01 = 0;
        int slotCount10 = 0;
        int slotCount11 = 0;
        int slotCountX0 = 0;
        int slotCountX1 = 0;
        int slotCountXY = 0;
        for (int i = 0; i < slotCount; ++i) {
            Slot slot = slots[i];
            Value tile = slot.toValue().header("tile");
            long xt = tile.getItem(0).longValue();
            long yt = tile.getItem(1).longValue();
            int xtRank = Long.numberOfLeadingZeros(xt ^ 0xFFFFFFFFFFFFFFFFL);
            int ytRank = Long.numberOfLeadingZeros(yt ^ 0xFFFFFFFFFFFFFFFFL);
            long xtBase = xt << xtRank;
            long ytBase = yt << ytRank;
            long xtNorm = xtBase & xnMask;
            long ytNorm = ytBase & ynMask;
            if (xnRank > 0 && xtRank > xnRank) {
                if (ynRank > 0 && ytRank > ynRank) {
                    slotsXY[slotCountXY] = slot;
                    ++slotCountXY;
                    continue;
                }
                if (ytNorm == y0Base) {
                    if (slotsX0 == null) {
                        slotsX0 = new Slot[slotCount];
                    }
                    slotsX0[slotCountX0] = slot;
                    ++slotCountX0;
                    xX0Rank = Math.max(xX0Rank, xtRank);
                    yX0Rank = Math.max(yX0Rank, ytRank);
                    xX0Base |= xtBase;
                    yX0Base |= ytBase;
                    xX0Mask &= xtBase;
                    yX0Mask &= ytBase;
                    continue;
                }
                if (slotsX1 == null) {
                    slotsX1 = new Slot[slotCount];
                }
                slotsX1[slotCountX1] = slot;
                ++slotCountX1;
                xX1Rank = Math.max(xX1Rank, xtRank);
                yX1Rank = Math.max(yX1Rank, ytRank);
                xX1Base |= xtBase;
                yX1Base |= ytBase;
                xX1Mask &= xtBase;
                yX1Mask &= ytBase;
                continue;
            }
            if (xtNorm == x0Base) {
                if (ytNorm == y0Base) {
                    if (slots00 == null) {
                        slots00 = new Slot[slotCount];
                    }
                    slots00[slotCount00] = slot;
                    ++slotCount00;
                    ++span00;
                    x00Rank = Math.max(x00Rank, xtRank);
                    y00Rank = Math.max(y00Rank, ytRank);
                    x00Base |= xtBase;
                    y00Base |= ytBase;
                    x00Mask &= xtBase;
                    y00Mask &= ytBase;
                    continue;
                }
                if (slots01 == null) {
                    slots01 = new Slot[slotCount];
                }
                slots01[slotCount01] = slot;
                ++slotCount01;
                ++span01;
                x01Rank = Math.max(x01Rank, xtRank);
                y01Rank = Math.max(y01Rank, ytRank);
                x01Base |= xtBase;
                y01Base |= ytBase;
                x01Mask &= xtBase;
                y01Mask &= ytBase;
                continue;
            }
            if (ytNorm == y0Base) {
                if (slots10 == null) {
                    slots10 = new Slot[slotCount];
                }
                slots10[slotCount10] = slot;
                ++slotCount10;
                ++span10;
                x10Rank = Math.max(x10Rank, xtRank);
                y10Rank = Math.max(y10Rank, ytRank);
                x10Base |= xtBase;
                y10Base |= ytBase;
                x10Mask &= xtBase;
                y10Mask &= ytBase;
                continue;
            }
            if (slots11 == null) {
                slots11 = new Slot[slotCount];
            }
            slots11[slotCount11] = slot;
            ++slotCount11;
            ++span11;
            x11Rank = Math.max(x11Rank, xtRank);
            y11Rank = Math.max(y11Rank, ytRank);
            x11Base |= xtBase;
            y11Base |= ytBase;
            x11Mask &= xtBase;
            y11Mask &= ytBase;
        }
        x00Mask ^= x00Base;
        y00Mask ^= y00Base;
        x01Mask ^= x01Base;
        y01Mask ^= y01Base;
        x10Mask ^= x10Base;
        y10Mask ^= y10Base;
        x11Mask ^= x11Base;
        y11Mask ^= y11Base;
        xX0Mask ^= xX0Base;
        yX0Mask ^= yX0Base;
        xX1Mask ^= xX1Base;
        yX1Mask ^= yX1Base;
        x00Rank = Math.max(x00Rank, 64 - Long.numberOfLeadingZeros(x00Mask));
        y00Rank = Math.max(y00Rank, 64 - Long.numberOfLeadingZeros(y00Mask));
        x01Rank = Math.max(x01Rank, 64 - Long.numberOfLeadingZeros(x01Mask));
        y01Rank = Math.max(y01Rank, 64 - Long.numberOfLeadingZeros(y01Mask));
        x10Rank = Math.max(x10Rank, 64 - Long.numberOfLeadingZeros(x10Mask));
        y10Rank = Math.max(y10Rank, 64 - Long.numberOfLeadingZeros(y10Mask));
        x11Rank = Math.max(x11Rank, 64 - Long.numberOfLeadingZeros(x11Mask));
        y11Rank = Math.max(y11Rank, 64 - Long.numberOfLeadingZeros(y11Mask));
        xX0Rank = Math.max(xX0Rank, 64 - Long.numberOfLeadingZeros(xX0Mask));
        yX0Rank = Math.max(yX0Rank, 64 - Long.numberOfLeadingZeros(yX0Mask));
        xX1Rank = Math.max(xX1Rank, 64 - Long.numberOfLeadingZeros(xX1Mask));
        yX1Rank = Math.max(yX1Rank, 64 - Long.numberOfLeadingZeros(yX1Mask));
        long x00 = BitInterval.from((int)x00Rank, (long)x00Base);
        long y00 = BitInterval.from((int)y00Rank, (long)y00Base);
        long x01 = BitInterval.from((int)x01Rank, (long)x01Base);
        long y01 = BitInterval.from((int)y01Rank, (long)y01Base);
        long x10 = BitInterval.from((int)x10Rank, (long)x10Base);
        long y10 = BitInterval.from((int)y10Rank, (long)y10Base);
        long x11 = BitInterval.from((int)x11Rank, (long)x11Base);
        long y11 = BitInterval.from((int)y11Rank, (long)y11Base);
        long xX0 = BitInterval.from((int)xX0Rank, (long)xX0Base);
        long yX0 = BitInterval.from((int)yX0Rank, (long)yX0Base);
        long xX1 = BitInterval.from((int)xX1Rank, (long)xX1Base);
        long yX1 = BitInterval.from((int)yX1Rank, (long)yX1Base);
        if (childCount11 > 0 && childCount01 > 0 && BitInterval.compare((long)x11, (long)y11, (long)x01, (long)y01) == 0) {
            System.arraycopy(childRefs11, 0, childRefs01, childCount01, childCount11);
            childCount01 += childCount11;
            span01 += span11;
            if (slotCount11 > 0) {
                if (slots01 == null) {
                    slots01 = new Slot[slotCount];
                }
                System.arraycopy(slots11, 0, slots01, slotCount01, slotCount11);
                slotCount01 += slotCount11;
                slots11 = null;
                slotCount11 = 0;
            }
            x01 = BitInterval.union((long)x01, (long)x11);
            y01 = BitInterval.union((long)y01, (long)y11);
            childRefs11 = null;
            childCount11 = 0;
            span11 = 0L;
        }
        if (childCount01 > 0 && childCount00 > 0 && BitInterval.compare((long)x01, (long)y01, (long)x00, (long)y00) == 0) {
            System.arraycopy(childRefs01, 0, childRefs00, childCount00, childCount01);
            childCount00 += childCount01;
            span00 += span01;
            if (slotCount01 > 0) {
                if (slots00 == null) {
                    slots00 = new Slot[slotCount];
                }
                System.arraycopy(slots01, 0, slots00, slotCount00, slotCount01);
                slotCount00 += slotCount01;
                slots01 = null;
                slotCount01 = 0;
            }
            x00 = BitInterval.union((long)x00, (long)x01);
            y00 = BitInterval.union((long)y00, (long)y01);
            childRefs01 = null;
            childCount01 = 0;
            span01 = 0L;
        }
        if (childCount01 > 0 && childCount10 > 0 && BitInterval.compare((long)x01, (long)y01, (long)x10, (long)y10) == 0) {
            System.arraycopy(childRefs01, 0, childRefs10, childCount10, childCount01);
            childCount10 += childCount01;
            span10 += span01;
            if (slotCount01 > 0) {
                if (slots10 == null) {
                    slots10 = new Slot[slotCount];
                }
                System.arraycopy(slots01, 0, slots10, slotCount10, slotCount01);
                slotCount10 += slotCount01;
                slots01 = null;
                slotCount01 = 0;
            }
            x10 = BitInterval.union((long)x10, (long)x01);
            y10 = BitInterval.union((long)y10, (long)y01);
            childRefs01 = null;
            childCount01 = 0;
            span01 = 0L;
        }
        if (childCount10 > 0 && childCount00 > 0 && BitInterval.compare((long)x10, (long)y10, (long)x00, (long)y00) == 0) {
            System.arraycopy(childRefs10, 0, childRefs00, childCount00, childCount10);
            childCount00 += childCount10;
            span00 += span10;
            if (slotCount10 > 0) {
                if (slots00 == null) {
                    slots00 = new Slot[slotCount];
                }
                System.arraycopy(slots10, 0, slots00, slotCount00, slotCount10);
                slotCount00 += slotCount10;
                slots10 = null;
                slotCount10 = 0;
            }
            x00 = BitInterval.union((long)x00, (long)x10);
            y00 = BitInterval.union((long)y00, (long)y10);
            childRefs10 = null;
            childCount10 = 0;
            span10 = 0L;
        }
        if (slotCountX1 > 0 && BitInterval.compare((long)xX1, (long)yX1, (long)x01, (long)y01) == 0) {
            if (slots01 != null) {
                System.arraycopy(slotsX1, 0, slots01, slotCount01, slotCountX1);
            } else {
                slots01 = slotsX1;
            }
            slotCount01 += slotCountX1;
            span01 += (long)slotCountX1;
            x01 = BitInterval.union((long)x01, (long)xX1);
            y01 = BitInterval.union((long)y01, (long)yX1);
            slotsX1 = null;
            slotCountX1 = 0;
        }
        if (slotCountX0 > 0 && BitInterval.compare((long)xX0, (long)yX0, (long)x00, (long)y00) == 0) {
            if (slots00 != null) {
                System.arraycopy(slotsX0, 0, slots00, slotCount00, slotCountX0);
            } else {
                slots00 = slotsX0;
            }
            slotCount00 += slotCountX0;
            span00 += (long)slotCountX0;
            x00 = BitInterval.union((long)x00, (long)xX0);
            y00 = BitInterval.union((long)y00, (long)yX0);
            slotsX0 = null;
            slotCountX0 = 0;
        }
        if (slotsX0 != null) {
            if (slotsXY == null) {
                slotsXY = new Slot[slotCount];
            }
            System.arraycopy(slotsX0, 0, slotsXY, slotCountXY, slotCountX0);
            slotCountXY += slotCountX0;
            slotsX0 = null;
            slotCountX0 = 0;
        }
        if (slotsX1 != null) {
            if (slotsXY == null) {
                slotsXY = new Slot[slotCount];
            }
            System.arraycopy(slotsX1, 0, slotsXY, slotCountXY, slotCountX1);
            slotCountXY += slotCountX1;
            slotsX1 = null;
            slotCountX1 = 0;
        }
        int pageRefCount = 0;
        if (childCount00 > 0 || slotCount00 > 0) {
            ++pageRefCount;
        }
        if (childCount01 > 0 || slotCount01 > 0) {
            ++pageRefCount;
        }
        if (childCount10 > 0 || slotCount10 > 0) {
            ++pageRefCount;
        }
        if (childCount11 > 0 || slotCount11 > 0) {
            ++pageRefCount;
        }
        Object[] pageRefs = new QTreePageRef[pageRefCount];
        int pageRefOffset = 0;
        if (childCount00 > 0 || slotCount00 > 0) {
            if (childCount00 < childCount) {
                newChildRefs = new QTreePageRef[childCount00];
                System.arraycopy(childRefs00, 0, newChildRefs, 0, childCount00);
                childRefs00 = newChildRefs;
            }
            if (slotCount00 == 0) {
                slots00 = QTreePage.EMPTY_SLOTS;
            } else if (slotCount00 < slotCount) {
                newSlots = new Slot[slotCount00];
                System.arraycopy(slots00, 0, newSlots, 0, slotCount00);
                slots00 = newSlots;
            }
            if (childCount00 > 1 || childCount00 == 1 && slotCount00 > 0) {
                BitInterval.sort((Object[])childRefs00, QTreePage.PAGE_REF_ORDERING);
                BitInterval.sort((Object[])slots00, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, span00, x00, y00, Value.absent(), (QTreePageRef[])childRefs00, (Slot[])slots00).pageRef();
            } else if (slotCount00 == 0) {
                pageRefs[pageRefOffset] = childRefs00[0];
            } else {
                BitInterval.sort((Object[])slots00, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), (Slot[])slots00).pageRef();
            }
            ++pageRefOffset;
        }
        if (childCount01 > 0 || slotCount01 > 0) {
            if (childCount01 < childCount) {
                newChildRefs = new QTreePageRef[childCount01];
                System.arraycopy(childRefs01, 0, newChildRefs, 0, childCount01);
                childRefs01 = newChildRefs;
            }
            if (slotCount01 == 0) {
                slots01 = QTreePage.EMPTY_SLOTS;
            } else if (slotCount01 < slotCount) {
                newSlots = new Slot[slotCount01];
                System.arraycopy(slots01, 0, newSlots, 0, slotCount01);
                slots01 = newSlots;
            }
            if (childCount01 > 1 || childCount01 == 1 && slotCount01 > 0) {
                BitInterval.sort((Object[])childRefs01, QTreePage.PAGE_REF_ORDERING);
                BitInterval.sort((Object[])slots01, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, span01, x01, y01, Value.absent(), (QTreePageRef[])childRefs01, (Slot[])slots01).pageRef();
            } else if (slotCount01 == 0) {
                pageRefs[pageRefOffset] = childRefs01[0];
            } else {
                BitInterval.sort((Object[])slots01, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), (Slot[])slots01).pageRef();
            }
            ++pageRefOffset;
        }
        if (childCount10 > 0 || slotCount10 > 0) {
            if (childCount10 < childCount) {
                newChildRefs = new QTreePageRef[childCount10];
                System.arraycopy(childRefs10, 0, newChildRefs, 0, childCount10);
                childRefs10 = newChildRefs;
            }
            if (slotCount10 == 0) {
                slots10 = QTreePage.EMPTY_SLOTS;
            } else if (slotCount10 < slotCount) {
                newSlots = new Slot[slotCount10];
                System.arraycopy(slots10, 0, newSlots, 0, slotCount10);
                slots10 = newSlots;
            }
            if (childCount10 > 1 || childCount10 == 1 && slotCount10 > 0) {
                BitInterval.sort((Object[])childRefs10, QTreePage.PAGE_REF_ORDERING);
                BitInterval.sort((Object[])slots10, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, span10, x10, y10, Value.absent(), (QTreePageRef[])childRefs10, (Slot[])slots10).pageRef();
            } else if (slotCount10 == 0) {
                pageRefs[pageRefOffset] = childRefs10[0];
            } else {
                BitInterval.sort((Object[])slots10, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), (Slot[])slots10).pageRef();
            }
            ++pageRefOffset;
        }
        if (childCount11 > 0 || slotCount11 > 0) {
            if (childCount11 < childCount) {
                newChildRefs = new QTreePageRef[childCount11];
                System.arraycopy(childRefs11, 0, newChildRefs, 0, childCount11);
                childRefs11 = newChildRefs;
            }
            if (slotCount11 == 0) {
                slots11 = QTreePage.EMPTY_SLOTS;
            } else if (slotCount11 < slotCount) {
                newSlots = new Slot[slotCount11];
                System.arraycopy(slots11, 0, newSlots, 0, slotCount11);
                slots11 = newSlots;
            }
            if (childCount11 > 1 || childCount11 == 1 && slotCount11 > 0) {
                BitInterval.sort((Object[])childRefs11, QTreePage.PAGE_REF_ORDERING);
                BitInterval.sort((Object[])slots11, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, span11, x11, y11, Value.absent(), (QTreePageRef[])childRefs11, (Slot[])slots11).pageRef();
            } else if (slotCount11 == 0) {
                pageRefs[pageRefOffset] = childRefs11[0];
            } else {
                BitInterval.sort((Object[])slots11, QTreePage.SLOT_ORDERING);
                pageRefs[pageRefOffset] = QTreeLeaf.create(this.pageRef.context, this.pageRef.stem, newVersion, Value.absent(), (Slot[])slots11).pageRef();
            }
            ++pageRefOffset;
        }
        BitInterval.sort((Object[])pageRefs, QTreePage.PAGE_REF_ORDERING);
        if (slotCountXY == 0) {
            slotsXY = QTreePage.EMPTY_SLOTS;
        } else if (slotCountXY < slotCount) {
            Slot[] newSlotsXY = new Slot[slotCountXY];
            System.arraycopy(slotsXY, 0, newSlotsXY, 0, slotCountXY);
            slotsXY = newSlotsXY;
        }
        BitInterval.sort((Object[])slotsXY, QTreePage.SLOT_ORDERING);
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, Value.absent(), (QTreePageRef[])pageRefs, (Slot[])slotsXY);
    }

    @Override
    void memoizeSize(QTreePageRef pageRef) {
        int pageSize = 12;
        pageSize += Recon.sizeOf((Item)Num.from((int)this.pageRef.stem));
        pageSize += 3;
        pageSize += Recon.sizeOf((Item)Num.from((long)this.version));
        ++pageSize;
        QTreePageRef[] childRefs = this.childRefs;
        int childCount = childRefs.length;
        int diffSize = 0;
        long treeSize = 0L;
        if (childCount > 0) {
            ++pageSize;
            for (int i = 0; i < childCount; ++i) {
                if (i > 0) {
                    ++pageSize;
                }
                QTreePageRef childRef = childRefs[i];
                pageSize += childRef.pageRefSize();
                if (this.version == childRef.softVersion()) {
                    diffSize += childRef.diffSize();
                }
                treeSize += childRef.treeSize();
            }
            Slot[] slots = this.slots;
            int slotCount = slots.length;
            for (int i = 0; i < slotCount; ++i) {
                ++pageSize;
                pageSize += Recon.sizeOf((Item)slots[i]);
            }
            ++pageSize;
            ++pageSize;
        }
        pageRef.pageSize = pageSize;
        pageRef.diffSize = diffSize += pageSize;
        pageRef.treeSize = treeSize += (long)pageSize;
    }

    @Override
    public Value toHeader() {
        Record header = Record.create((int)2).slot("stem", this.pageRef.stem).slot("v", this.version);
        return Record.create((int)1).attr("qnode", (Value)header);
    }

    @Override
    public Value toValue() {
        Record record = (Record)this.toHeader();
        QTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            record.add((Item)childRefs[i].toValue());
        }
        return record;
    }

    @Override
    public QTreeNode reduced(Value identity, CombinerFunction<? super Value, Value> accumulator, CombinerFunction<Value, Value> combiner, long newVersion) {
        QTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        QTreePageRef[] newChildRefs = new QTreePageRef[n];
        for (int i = 0; i < n; ++i) {
            newChildRefs[i] = oldChildRefs[i].reduced(identity, accumulator, combiner, newVersion);
        }
        Value fold = newChildRefs[0].fold();
        for (int i = 1; i < n; ++i) {
            fold = (Value)combiner.combine((Object)fold, (Object)newChildRefs[i].fold());
        }
        Slot[] slots = this.slots;
        int k = slots.length;
        for (int i = 0; i < k; ++i) {
            fold = (Value)accumulator.combine((Object)fold, (Object)slots[i].value());
        }
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, newVersion, this.pageRef.span, this.pageRef.x, this.pageRef.y, fold, newChildRefs, slots);
    }

    @Override
    public QTreeNode evacuated(int post, long version) {
        int oldPost = this.pageRef.post;
        if (oldPost != 0 && oldPost < post) {
            QTreePageRef[] oldChildRefs = this.childRefs;
            int n = oldChildRefs.length;
            QTreePageRef[] newChildRefs = new QTreePageRef[n];
            for (int i = 0; i < n; ++i) {
                QTreePageRef newChildRef;
                QTreePageRef oldChildRef = oldChildRefs[i];
                newChildRefs[i] = newChildRef = oldChildRef.evacuated(post, version);
                if (oldChildRef == newChildRef) continue;
                if (++i < n) {
                    System.arraycopy(oldChildRefs, i, newChildRefs, i, n - i);
                }
                return QTreeNode.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.span, this.pageRef.x, this.pageRef.y, this.pageRef.fold, newChildRefs, this.slots);
            }
        }
        return this;
    }

    @Override
    public QTreeNode committed(int zone, long base, long version) {
        QTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        QTreePageRef[] newChildRefs = new QTreePageRef[n];
        long step = base;
        for (int i = 0; i < n; ++i) {
            QTreePageRef oldChildRef = oldChildRefs[i];
            if (!oldChildRef.isCommitted()) {
                QTreePageRef newChildRef;
                newChildRefs[i] = newChildRef = oldChildRef.committed(zone, step, version);
                step += (long)newChildRef.diffSize();
                continue;
            }
            newChildRefs[i] = oldChildRef;
        }
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, version, zone, step, this.pageRef.span, this.pageRef.x, this.pageRef.y, this.pageRef.fold, newChildRefs, this.slots);
    }

    @Override
    public QTreeNode uncommitted(long version) {
        QTreePageRef[] oldChildRefs = this.childRefs;
        int n = oldChildRefs.length;
        QTreePageRef[] newChildRefs = new QTreePageRef[n];
        for (int i = 0; i < n; ++i) {
            newChildRefs[i] = oldChildRefs[i].uncommitted(version);
        }
        return QTreeNode.create(this.pageRef.context, this.pageRef.stem, version, this.pageRef.span, this.pageRef.x, this.pageRef.y, this.pageRef.fold, newChildRefs, this.slots);
    }

    @Override
    public void writePage(Output<?> output) {
        Recon.write(output, (Item)this.toHeader());
        this.writePageContent(output);
        output.write(10);
    }

    void writePageContent(Output<?> output) {
        QTreePageRef[] childRefs = this.childRefs;
        int childCount = childRefs.length;
        if (childCount > 0) {
            output.write(123);
            for (int i = 0; i < childCount; ++i) {
                if (i > 0) {
                    output.write(44);
                }
                childRefs[i].writePageRef(output);
            }
            Slot[] slots = this.slots;
            int slotCount = slots.length;
            for (int i = 0; i < slotCount; ++i) {
                output.write(44);
                Recon.write(output, (Item)slots[i]);
            }
            output.write(125);
        }
    }

    @Override
    public void writeDiff(Output<?> output) {
        for (QTreePageRef childRef : this.childRefs) {
            if (this.version != childRef.softVersion()) continue;
            childRef.writeDiff(output);
        }
        this.writePage(output);
    }

    @Override
    public void buildDiff(Builder<Page, ?> builder) {
        for (QTreePageRef childRef : this.childRefs) {
            if (this.version != childRef.softVersion()) continue;
            childRef.buildDiff(builder);
        }
        builder.add((Object)this);
    }

    @Override
    public QTreePage loadTree(PageLoader pageLoader) {
        QTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            childRefs[i].loadTree(pageLoader);
        }
        return this;
    }

    @Override
    public void soften(long version) {
        QTreePageRef[] childRefs = this.childRefs;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            childRefs[i].soften(version);
        }
    }

    @Override
    public Cursor<Slot> cursor(long x, long y) {
        return new QTreeNodeDepthCursor(this, x, y, Integer.MAX_VALUE);
    }

    @Override
    public Cursor<Slot> depthCursor(long x, long y, int maxDepth) {
        return new QTreeNodeDepthCursor(this, x, y, maxDepth);
    }

    @Override
    public Cursor<Slot> deltaCursor(long x, long y, long sinceVersion) {
        return new QTreeNodeDeltaCursor(this, x, y, sinceVersion);
    }

    @Override
    public Cursor<Slot> tileCursor(long x, long y) {
        return new QTreeNodeTileCursor(this, x, y);
    }

    public String toString() {
        Output output = Unicode.stringOutput((int)(this.pageSize() - 1));
        Recon.write((Output)output, (Item)this.toHeader());
        this.writePageContent(output);
        return (String)output.bind();
    }

    public static QTreeNode create(PageContext context, int stem, long version, int post, int zone, long base, long span, long x, long y, Value fold, QTreePageRef[] childRefs, Slot[] slots) {
        QTreePageRef pageRef = new QTreePageRef(context, PageType.NODE, stem, post, zone, base, span, x, y, fold);
        QTreeNode page = new QTreeNode(pageRef, version, childRefs, slots);
        pageRef.page = page;
        return page;
    }

    public static QTreeNode create(PageContext context, int stem, long version, int zone, long base, long span, long x, long y, Value fold, QTreePageRef[] childRefs, Slot[] slots) {
        int post = zone;
        int n = childRefs.length;
        for (int i = 0; i < n; ++i) {
            int childPost = childRefs[i].post;
            if (childPost == 0) continue;
            post = post == 0 ? childPost : Math.min(post, childPost);
        }
        return QTreeNode.create(context, stem, version, post, zone, base, span, x, y, fold, childRefs, slots);
    }

    public static QTreeNode create(PageContext context, int stem, long version, long span, long x, long y, Value fold, QTreePageRef[] childRefs, Slot[] slots) {
        return QTreeNode.create(context, stem, version, 0, 0L, span, x, y, fold, childRefs, slots);
    }

    public static QTreeNode create(PageContext context, int stem, long version, long span, Value fold, QTreePageRef[] childRefs, Slot[] slots) {
        int i;
        int xRank = 0;
        int yRank = 0;
        long xBase = 0L;
        long yBase = 0L;
        long xMask = -1L;
        long yMask = -1L;
        int post = 0;
        int childCount = childRefs.length;
        for (i = 0; i < childCount; ++i) {
            QTreePageRef childRef = childRefs[i];
            long cx = childRef.x;
            long cy = childRef.y;
            int cxRank = Long.numberOfLeadingZeros(cx ^ 0xFFFFFFFFFFFFFFFFL);
            int cyRank = Long.numberOfLeadingZeros(cy ^ 0xFFFFFFFFFFFFFFFFL);
            long cxBase = cx << cxRank;
            long cyBase = cy << cyRank;
            xRank = Math.max(xRank, cxRank);
            yRank = Math.max(yRank, cyRank);
            xBase |= cxBase;
            yBase |= cyBase;
            xMask &= cxBase;
            yMask &= cyBase;
            int childPost = childRef.post;
            if (childPost == 0) continue;
            post = post == 0 ? childPost : Math.min(post, childPost);
        }
        int slotCount = slots.length;
        for (i = 0; i < slotCount; ++i) {
            Value tile = slots[i].toValue().header("tile");
            long tx = tile.getItem(0).longValue();
            long ty = tile.getItem(1).longValue();
            int txRank = Long.numberOfLeadingZeros(tx ^ 0xFFFFFFFFFFFFFFFFL);
            int tyRank = Long.numberOfLeadingZeros(ty ^ 0xFFFFFFFFFFFFFFFFL);
            long txBase = tx << txRank;
            long tyBase = ty << tyRank;
            xRank = Math.max(xRank, txRank);
            yRank = Math.max(yRank, tyRank);
            xBase |= txBase;
            yBase |= tyBase;
            xMask &= txBase;
            yMask &= tyBase;
        }
        xRank = Math.max(xRank, 64 - Long.numberOfLeadingZeros(xMask ^= xBase));
        yRank = Math.max(yRank, 64 - Long.numberOfLeadingZeros(yMask ^= yBase));
        xMask = (1L << xRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        yMask = (1L << yRank) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        long x = BitInterval.from((int)xRank, (long)(xBase &= xMask));
        long y = BitInterval.from((int)yRank, (long)(yBase &= yMask));
        return QTreeNode.create(context, stem, version, post, 0, 0L, span, x, y, fold, childRefs, slots);
    }

    public static QTreeNode fromValue(QTreePageRef pageRef, Value value) {
        Throwable cause = null;
        try {
            Value header = value.header("qnode");
            long version = header.get("v").longValue();
            Record tail = value.tail();
            int n = tail.size();
            QTreePageRef[] childRefs = new QTreePageRef[n];
            Slot[] slots = null;
            int childCount = 0;
            int slotCount = 0;
            for (int i = 0; i < n; ++i) {
                Item item = tail.get(i);
                if (item instanceof Slot) {
                    if (slots == null) {
                        slots = new Slot[n];
                    }
                    slots[slotCount] = (Slot)item;
                    ++slotCount;
                    continue;
                }
                childRefs[childCount] = QTreePageRef.fromValue(pageRef.context, pageRef.stem, item.toValue());
                ++childCount;
            }
            if (childCount < n) {
                QTreePageRef[] newChildRefs = new QTreePageRef[childCount];
                System.arraycopy(childRefs, 0, newChildRefs, 0, childCount);
                childRefs = newChildRefs;
            }
            if (slotCount == 0) {
                slots = QTreePage.EMPTY_SLOTS;
            } else if (slotCount < n) {
                Slot[] newSlots = new Slot[slotCount];
                System.arraycopy(slots, 0, newSlots, 0, slotCount);
                slots = newSlots;
            }
            return new QTreeNode(pageRef, version, childRefs, slots);
        }
        catch (Throwable error) {
            if (!Cont.isNonFatal((Throwable)error)) {
                throw error;
            }
            cause = error;
            Output message = Unicode.stringOutput((String)"Malformed qnode: ");
            Recon.write((Output)message, (Item)value);
            throw new StoreException((String)message.bind(), cause);
        }
    }
}

