/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.concurrent.Stage;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.StoreContext;
import swim.db.StoreSettings;
import swim.db.Tree;
import swim.db.TreeDelegate;
import swim.db.Zone;

public abstract class Store {
    public abstract StoreContext storeContext();

    public StoreSettings settings() {
        return this.storeContext().settings;
    }

    public abstract Database database();

    public abstract Stage stage();

    public abstract long size();

    public abstract boolean isCommitting();

    public abstract boolean isCompacting();

    public abstract boolean open();

    public abstract boolean close();

    public abstract int oldestZoneId();

    public abstract int newestZoneId();

    public abstract Zone zone();

    public abstract Zone zone(int var1);

    public abstract Zone openZone(int var1);

    public abstract void deletePost(int var1);

    public abstract Database openDatabase();

    public abstract PageLoader openPageLoader(TreeDelegate var1, boolean var2);

    public abstract void commitAsync(Commit var1);

    public abstract Zone shiftZone();

    boolean pageShouldSplit(Database database, Page page) {
        return this.storeContext().pageShouldSplit(this, database, page);
    }

    boolean pageShouldMerge(Database database, Page page) {
        return this.storeContext().pageShouldMerge(this, database, page);
    }

    void hitPage(Database database, Page page) {
        this.storeContext().hitPage(this, database, page);
    }

    void treeDidOpen(Database database, Tree tree) {
        this.storeContext().treeDidOpen(this, database, tree);
    }

    void treeDidClose(Database database, Tree tree) {
        this.storeContext().treeDidClose(this, database, tree);
    }

    void treeDidChange(Database database, Tree newTree, Tree oldTree) {
        this.storeContext().treeDidChange(this, database, newTree, oldTree);
    }

    void databaseWillOpen(Database database) {
        this.storeContext().databaseWillOpen(this, database);
    }

    void databaseDidOpen(Database database) {
        this.storeContext().databaseDidOpen(this, database);
    }

    void databaseWillClose(Database database) {
        this.storeContext().databaseWillClose(this, database);
    }

    void databaseDidClose(Database database) {
        this.storeContext().databaseDidClose(this, database);
    }

    Commit databaseWillCommit(Database database, Commit commit) {
        return this.storeContext().databaseWillCommit(this, database, commit);
    }

    void databaseDidCommit(Database database, Chunk chunk) {
        this.storeContext().databaseDidCommit(this, database, chunk);
    }

    void databaseCommitDidFail(Database database, Throwable error) {
        this.storeContext().databaseCommitDidFail(this, database, error);
    }

    void databaseWillCompact(Database database, int post) {
        this.storeContext().databaseWillCompact(this, database, post);
    }

    void databaseDidCompact(Database database, int post) {
        this.storeContext().databaseDidCompact(this, database, post);
    }

    void databaseCompactDidFail(Database database, Throwable error) {
        this.storeContext().databaseCompactDidFail(this, database, error);
    }
}

