/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.db.Page;
import swim.db.PageRef;
import swim.db.Seed;
import swim.db.StoreSettings;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.TreeType;
import swim.structure.Value;
import swim.util.Builder;
import swim.util.Cursor;

public abstract class Tree {
    Tree() {
    }

    public abstract TreeType treeType();

    public abstract TreeContext treeContext();

    public StoreSettings settings() {
        return this.treeContext().settings();
    }

    public TreeDelegate treeDelegate() {
        return this.treeContext().treeDelegate();
    }

    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.treeContext().setTreeDelegate(treeDelegate);
    }

    public abstract PageRef rootRef();

    public abstract Page rootPage();

    public abstract Seed seed();

    public int stem() {
        return this.seed().stem;
    }

    public int post() {
        return this.rootRef().post();
    }

    public long span() {
        return this.rootRef().span();
    }

    public Value fold() {
        return this.rootRef().fold();
    }

    public abstract boolean isResident();

    public abstract Tree isResident(boolean var1);

    public abstract boolean isTransient();

    public abstract Tree isTransient(boolean var1);

    public abstract boolean isEmpty();

    public abstract int diffSize(long var1);

    public abstract long treeSize();

    public abstract Tree evacuated(int var1, long var2);

    public abstract Tree committed(int var1, long var2, long var4, long var6);

    public abstract Tree uncommitted(long var1);

    public abstract void writeDiff(Output<?> var1, long var2);

    public abstract void buildDiff(long var1, Builder<Page, ?> var3);

    public FingerTrieSeq<Page> toDiff(long version) {
        Builder builder = FingerTrieSeq.builder();
        this.buildDiff(version, builder);
        return (FingerTrieSeq)builder.bind();
    }

    public abstract Tree load();

    public abstract void soften(long var1);

    public abstract Cursor<? extends Object> cursor();
}

