/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import swim.concurrent.Cont;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.TreeContext;
import swim.db.TreeDelegate;
import swim.db.Trunk;
import swim.db.UTree;
import swim.structure.Value;

public class UTreeValue {
    final Trunk<UTree> trunk;

    public UTreeValue(Trunk<UTree> trunk) {
        this.trunk = trunk;
    }

    public final Trunk<UTree> trunk() {
        return this.trunk;
    }

    public final StoreSettings settings() {
        return this.trunk.settings();
    }

    public final Database database() {
        return this.trunk.database;
    }

    public final Value name() {
        return this.trunk.name;
    }

    public final UTree tree() {
        return (UTree)Trunk.TREE.get(this.trunk);
    }

    public final TreeDelegate treeDelegate() {
        return this.tree().treeDelegate();
    }

    public void setTreeDelegate(TreeDelegate treeDelegate) {
        this.tree().setTreeDelegate(treeDelegate);
    }

    public boolean isResident() {
        return this.tree().isResident();
    }

    public UTreeValue isResident(boolean isResident) {
        long newVersion;
        UTree newTree;
        UTree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isResident(isResident)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public boolean isTransient() {
        return this.tree().isTransient();
    }

    public UTreeValue isTransient(boolean isTransient) {
        long newVersion;
        UTree newTree;
        UTree oldTree;
        do {
            newVersion = this.trunk.version();
        } while ((oldTree = this.tree()) != (newTree = oldTree.isTransient(isTransient)) && !this.trunk.updateTree(oldTree, newTree, newVersion));
        return this;
    }

    public Value get() {
        int retries = 0;
        while (true) {
            try {
                return this.tree().get();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public Value set(Value newValue) {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            int newPost = this.trunk.post();
            try {
                UTree oldTree = this.tree();
                UTree newTree = oldTree.updated(newValue, newVersion, newPost);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    Value oldValue = oldTree.get();
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.utreeDidUpdate(newTree, oldTree, newValue, oldValue);
                    treeContext.treeDidChange(newTree, oldTree);
                    return oldValue;
                }
                return oldTree.get();
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                if (retries == this.settings().maxRetries) {
                    ++retries;
                    this.didFail(error);
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    public void clear() {
        int retries = 0;
        while (true) {
            long newVersion = this.trunk.version();
            try {
                UTree oldTree = this.tree();
                UTree newTree = oldTree.cleared(newVersion);
                if (oldTree != newTree) {
                    if (!this.trunk.updateTree(oldTree, newTree, newVersion)) continue;
                    TreeContext treeContext = newTree.treeContext();
                    treeContext.treeDidClear(newTree, oldTree);
                    treeContext.treeDidChange(newTree, oldTree);
                    return;
                }
                return;
            }
            catch (StoreException error) {
                if (retries < this.settings().maxRetries) {
                    ++retries;
                    continue;
                }
                throw error;
            }
            break;
        }
    }

    protected void didFail(StoreException error) {
        System.err.println(error.getMessage());
        error.printStackTrace();
        this.clear();
    }

    public UTreeValue load() {
        this.tree().load();
        return this;
    }

    public void commitAsync(Commit commit) {
        try {
            this.trunk.commitAsync(commit);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    public Chunk commit(Commit commit) throws InterruptedException {
        return this.trunk.commit(commit);
    }
}

