// Copyright 2015-2024 Nstream, inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package swim.db;

import swim.structure.Slot;
import swim.util.Cursor;

final class QTreeNodeDepthCursor extends QTreeNodeCursor {

  final int depth;

  QTreeNodeDepthCursor(QTreeNode page, long x, long y, long index, int slotIndex,
                       int childIndex, int depth) {
    super(page, x, y, index, slotIndex, childIndex);
    this.depth = depth;
  }

  QTreeNodeDepthCursor(QTreeNode page, long x, long y, int depth) {
    this(page, x, y, 0L, 0, 0, depth);
  }

  @Override
  Cursor<Slot> childCursor(QTreePageRef childRef) {
    return childRef.depthCursor(this.x, this.y, this.depth - 1);
  }

}
