/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import swim.collections.HashTrieMap;
import swim.concurrent.Cont;
import swim.concurrent.Stage;
import swim.concurrent.TaskFunction;
import swim.db.Commit;
import swim.db.Database;
import swim.db.FilePageLoader;
import swim.db.FileStoreCommitter;
import swim.db.FileStoreZoneFilter;
import swim.db.FileZone;
import swim.db.Page;
import swim.db.PageLoader;
import swim.db.Store;
import swim.db.StoreContext;
import swim.db.StoreException;
import swim.db.TreeDelegate;
import swim.db.Zone;
import swim.util.HashGenCacheSet;

public class FileStore
extends Store {
    final StoreContext context;
    final File directory;
    final String baseName;
    final String zoneFileExt;
    final Stage stage;
    final HashGenCacheSet<Page> pageCache;
    final FileStoreCommitter committer;
    final Pattern zonePattern;
    final FilenameFilter zoneFilter;
    volatile HashTrieMap<Integer, FileZone> zones;
    volatile FileZone zone;
    volatile int status;
    static final int INITIAL_STATE = 0;
    static final int OPENING_STATE = 1;
    static final int OPENED_STATE = 2;
    static final int CLOSING_STATE = 3;
    static final int CLOSED_STATE = 4;
    static final int STATE_BITS = 3;
    static final int STATE_MASK = 7;
    static final int COMMITTING_FLAG = 8;
    static final int COMPACTING_FLAG = 16;
    static final AtomicReferenceFieldUpdater<FileStore, HashTrieMap<Integer, FileZone>> ZONES = AtomicReferenceFieldUpdater.newUpdater(FileStore.class, HashTrieMap.class, "zones");
    static final AtomicReferenceFieldUpdater<FileStore, FileZone> ZONE = AtomicReferenceFieldUpdater.newUpdater(FileStore.class, FileZone.class, "zone");
    static final AtomicIntegerFieldUpdater<FileStore> STATUS = AtomicIntegerFieldUpdater.newUpdater(FileStore.class, "status");

    public FileStore(StoreContext context, File directory, String baseName, Stage stage) {
        this.context = context;
        this.directory = directory != null ? directory : new File("");
        int lastDotIndex = baseName.lastIndexOf(46);
        if (lastDotIndex >= 0) {
            this.baseName = baseName.substring(0, lastDotIndex);
            this.zoneFileExt = baseName.substring(lastDotIndex + 1);
        } else {
            this.baseName = baseName;
            this.zoneFileExt = "swimdb";
        }
        this.stage = stage;
        this.pageCache = new HashGenCacheSet(context.settings.pageCacheSize);
        this.committer = new FileStoreCommitter(this);
        stage.task((TaskFunction)this.committer);
        this.zonePattern = Pattern.compile(Pattern.quote(this.baseName) + "-([0-9]+)\\." + Pattern.quote(this.zoneFileExt));
        this.zoneFilter = new FileStoreZoneFilter(this.zonePattern);
        this.zones = HashTrieMap.empty();
        this.status = 0;
    }

    public FileStore(StoreContext context, File basePath, Stage stage) {
        this(context, basePath.getParentFile(), basePath.getName(), stage);
    }

    public FileStore(StoreContext context, String basePath, Stage stage) {
        this(context, new File(basePath), stage);
    }

    public FileStore(File directory, String baseName, Stage stage) {
        this(new StoreContext(), directory, baseName, stage);
    }

    public FileStore(File basePath, Stage stage) {
        this(new StoreContext(), basePath, stage);
    }

    public FileStore(String basePath, Stage stage) {
        this(new StoreContext(), new File(basePath), stage);
    }

    @Override
    public final StoreContext storeContext() {
        return this.context;
    }

    @Override
    public final Database database() {
        FileZone zone = this.zone;
        if (zone != null) {
            return zone.database();
        }
        return null;
    }

    public final File directory() {
        return this.directory;
    }

    public final String baseName() {
        return this.baseName;
    }

    public final String zoneFileExt() {
        return this.zoneFileExt;
    }

    @Override
    public final Stage stage() {
        return this.stage;
    }

    public final HashGenCacheSet<Page> pageCache() {
        return this.pageCache;
    }

    @Override
    public final long size() {
        long size = 0L;
        Iterator zoneIterator = this.zones.valueIterator();
        while (zoneIterator.hasNext()) {
            size += ((FileZone)zoneIterator.next()).size();
        }
        return size;
    }

    @Override
    public final boolean isCommitting() {
        return (this.status & 8) != 0;
    }

    @Override
    public final boolean isCompacting() {
        return (this.status & 0x10) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean open() {
        StoreException error;
        boolean interrupted;
        boolean opened;
        block35: {
            int status = STATUS.get(this);
            int state = status & 7;
            opened = false;
            interrupted = false;
            error = null;
            while (true) {
                if (state == 2) {
                    if (!opened) break block35;
                    try {
                        this.didOpen();
                    }
                    catch (Throwable cause2) {
                        if (!Cont.isNonFatal((Throwable)cause2)) {
                            throw cause2;
                        }
                        if (error == null) {
                            error = new StoreException("lifecycle callback failure", cause2);
                        }
                        break block35;
                    }
                }
                if (state == 1) {
                    int newStatus;
                    int oldStatus;
                    FileStore cause2;
                    block36: {
                        if (!opened) {
                            FileStore cause2 = this;
                            synchronized (cause2) {
                            }
                        } else {
                            try {
                                this.onOpen();
                                cause2 = this;
                                break block36;
                            }
                            catch (Throwable cause3) {
                                try {
                                    if (!Cont.isNonFatal((Throwable)cause3)) {
                                        throw cause3;
                                    }
                                    if (error == null) {
                                        error = new StoreException("lifecycle callback failure", cause3);
                                    }
                                    cause2 = this;
                                }
                                catch (Throwable throwable) {
                                    FileStore fileStore = this;
                                    synchronized (fileStore) {
                                        int newStatus2;
                                        int oldStatus2;
                                        while ((state = (status = STATUS.compareAndSet(this, oldStatus2 = status, newStatus2 = oldStatus2 & 0xFFFFFFF8 | 2) ? oldStatus2 : STATUS.get(this)) & 7) != oldStatus2) {
                                        }
                                        this.notifyAll();
                                        throw throwable;
                                    }
                                }
                                synchronized (cause2) {
                                    while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 2) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                                    }
                                    this.notifyAll();
                                    continue;
                                }
                            }
                        }
                        {
                            while ((state = (status = STATUS.get(this)) & 7) == 1) {
                                try {
                                    this.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                            }
                            continue;
                        }
                    }
                    synchronized (cause2) {
                        while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 2) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                        }
                        this.notifyAll();
                        continue;
                    }
                }
                if (state != 0) break;
                int oldStatus = status;
                int newStatus = oldStatus & 0xFFFFFFF8 | 1;
                status = STATUS.compareAndSet(this, oldStatus, newStatus) ? oldStatus : STATUS.get(this);
                state = status & 7;
                if (status != oldStatus) continue;
                opened = true;
                try {
                    this.willOpen();
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    error = new StoreException("lifecycle callback failure", cause);
                }
            }
            if (state != 3 && state != 4) {
                throw new AssertionError((Object)Integer.toString(state));
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error != null) {
            this.close();
            throw error;
        }
        return opened;
    }

    protected void willOpen() {
    }

    protected void onOpen() {
        this.openZone();
    }

    protected void didOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        StoreException error;
        boolean interrupted;
        boolean closed;
        block39: {
            int status = STATUS.get(this);
            int state = status & 7;
            closed = false;
            interrupted = false;
            error = null;
            while (true) {
                if (state == 4) {
                    if (!closed) break block39;
                    try {
                        this.didClose();
                        break block39;
                    }
                    catch (Throwable cause) {
                        if (Cont.isNonFatal((Throwable)cause)) {
                            if (error == null) {
                                error = new StoreException("lifecycle callback failure", cause);
                            }
                            break block39;
                        }
                        throw cause;
                    }
                }
                if (state == 3 || state == 1) {
                    int newStatus;
                    int oldStatus;
                    FileStore fileStore;
                    int oldState = state;
                    if (!closed) {
                        FileStore fileStore2 = this;
                        synchronized (fileStore2) {
                            while ((state = (status = STATUS.get(this)) & 7) == oldState) {
                                try {
                                    this.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                            }
                        }
                    }
                    try {
                        this.onClose();
                        fileStore = this;
                    }
                    catch (Throwable cause2) {
                        FileStore cause2;
                        try {
                            if (Cont.isNonFatal((Throwable)cause2)) {
                                if (error == null) {
                                    error = new StoreException("lifecycle callback failure", cause2);
                                }
                            } else {
                                throw cause2;
                            }
                            cause2 = this;
                        }
                        catch (Throwable throwable) {
                            FileStore fileStore3 = this;
                            synchronized (fileStore3) {
                                int newStatus2;
                                int oldStatus2;
                                while ((state = (status = STATUS.compareAndSet(this, oldStatus2 = status, newStatus2 = oldStatus2 & 0xFFFFFFF8 | 4) ? oldStatus2 : STATUS.get(this)) & 7) != oldStatus2) {
                                }
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (cause2) {
                            while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 4) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                            }
                            this.notifyAll();
                            continue;
                        }
                    }
                    synchronized (fileStore) {
                        while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 4) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                        }
                        this.notifyAll();
                    }
                }
                if (state == 2) {
                    int oldStatus = status;
                    int newStatus = oldStatus & 0xFFFFFFF8 | 3;
                    status = STATUS.compareAndSet(this, oldStatus, newStatus) ? oldStatus : STATUS.get(this);
                    state = status & 7;
                    if (status != oldStatus) continue;
                    closed = true;
                    try {
                        this.willClose();
                    }
                    catch (Throwable cause) {
                        if (Cont.isNonFatal((Throwable)cause)) {
                            error = new StoreException("lifecycle callback failure", cause);
                        }
                        throw cause;
                    }
                }
                if (state != 0) break;
                this.open();
            }
            throw new AssertionError((Object)Integer.toString(state));
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error != null) {
            throw error;
        }
        return closed;
    }

    protected void willClose() {
    }

    protected void onClose() {
        this.closeZones();
    }

    protected void didClose() {
    }

    @Override
    public int oldestZoneId() {
        TreeMap<Integer, File> zoneFiles = this.zoneFiles();
        if (!zoneFiles.isEmpty()) {
            return zoneFiles.firstKey();
        }
        return 1;
    }

    @Override
    public int newestZoneId() {
        TreeMap<Integer, File> zoneFiles = this.zoneFiles();
        if (!zoneFiles.isEmpty()) {
            return zoneFiles.lastKey();
        }
        return 1;
    }

    @Override
    public FileZone zone() {
        return this.zone;
    }

    @Override
    public FileZone zone(int zoneId) {
        return (FileZone)this.zones.get((Object)zoneId);
    }

    protected Zone openZone() {
        this.directory.mkdirs();
        TreeMap<Integer, File> zoneFiles = this.zoneFiles();
        while (true) {
            int zoneId;
            if (!zoneFiles.isEmpty()) {
                zoneId = zoneFiles.lastKey();
                zoneFiles.remove(zoneId);
            } else {
                zoneId = 1;
            }
            FileZone zone = this.openZone(zoneId);
            if (zoneFiles.isEmpty() || zone.germ().seedRefValue().isDefined()) {
                ZONE.set(this, zone);
                return zone;
            }
            this.closeZone(zone.id);
            File oldFile = zone.file;
            if (!oldFile.exists()) continue;
            if (oldFile.length() == 0L) {
                oldFile.delete();
                continue;
            }
            String newFileName = "~" + oldFile.getName() + "-" + System.currentTimeMillis();
            File newFile = new File(oldFile.getParent(), newFileName);
            oldFile.renameTo(newFile);
        }
    }

    @Override
    public FileZone openZone(int zoneId) {
        FileZone newZone;
        block5: {
            HashTrieMap<Integer, FileZone> oldZones;
            FileZone oldZone;
            newZone = null;
            while ((oldZone = (FileZone)(oldZones = this.zones).get((Object)zoneId)) == null) {
                HashTrieMap newZones;
                if (newZone == null) {
                    File zoneFile = this.zoneFile(zoneId);
                    FileZone zone = this.zone;
                    if (zone == null || zoneId > zone.id || zoneFile.exists()) {
                        newZone = new FileZone(this, zoneId, zoneFile, this.stage);
                    } else {
                        throw new StoreException("failed to open deleted zone " + zoneFile);
                    }
                }
                if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)(newZones = oldZones.updated((Object)zoneId, (Object)newZone)))) continue;
                break block5;
            }
            if (newZone != null) {
                newZone.close();
            }
            newZone = oldZone;
        }
        newZone.open();
        return newZone;
    }

    void closeZone(int zoneId) {
        HashTrieMap newZones;
        HashTrieMap<Integer, FileZone> oldZones;
        while ((oldZones = this.zones) != (newZones = oldZones.removed((Object)zoneId))) {
            if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)newZones)) continue;
            ((FileZone)oldZones.get((Object)zoneId)).close();
            break;
        }
    }

    void closeZones() {
        HashTrieMap newZones;
        HashTrieMap<Integer, FileZone> oldZones;
        while ((oldZones = this.zones) != (newZones = HashTrieMap.empty())) {
            if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)newZones)) continue;
            Iterator zoneIterator = oldZones.valueIterator();
            while (zoneIterator.hasNext()) {
                ((FileZone)zoneIterator.next()).close();
            }
            break block0;
        }
    }

    @Override
    public void deletePost(int post) {
        int oldestZone;
        Database database = this.openDatabase();
        TreeMap<Integer, File> zoneFiles = this.zoneFiles();
        while (!zoneFiles.isEmpty() && (oldestZone = zoneFiles.firstKey().intValue()) < post) {
            boolean deleted = zoneFiles.get(oldestZone).delete();
            zoneFiles.remove(oldestZone);
            this.closeZone(oldestZone);
            if (!deleted) continue;
            this.context.databaseDidDeleteZone(this, database, oldestZone);
        }
    }

    public boolean delete() {
        boolean deleted = false;
        File[] files = this.directory.listFiles(this.zoneFilter);
        if (files != null) {
            deleted = true;
            for (File file : files) {
                deleted = file.delete() && deleted;
            }
        }
        return deleted;
    }

    @Override
    public Database openDatabase() {
        this.open();
        return this.zone.openDatabase();
    }

    @Override
    public PageLoader openPageLoader(TreeDelegate treeDelegate, boolean isResident) {
        return new FilePageLoader(this, treeDelegate, isResident);
    }

    @Override
    public void commitAsync(Commit commit) {
        try {
            this.committer.commitAsync(commit);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                commit.trap(cause);
            }
            throw cause;
        }
    }

    @Override
    public synchronized FileZone shiftZone() {
        FileZone newZone;
        block3: {
            HashTrieMap<Integer, FileZone> oldZones;
            FileZone zone;
            this.open();
            FileZone oldZone = this.zone;
            int oldZoneId = oldZone.id;
            int newZoneId = oldZoneId + 1;
            newZone = null;
            while ((zone = (FileZone)(oldZones = this.zones).get((Object)newZoneId)) == null) {
                HashTrieMap newZones;
                if (newZone == null) {
                    newZone = new FileZone(this, newZoneId, this.zoneFile(newZoneId), this.stage, oldZone.database, oldZone.germ());
                    newZone.open();
                }
                if (!ZONES.compareAndSet(this, oldZones, (HashTrieMap<Integer, FileZone>)(newZones = oldZones.updated((Object)newZoneId, (Object)newZone)))) continue;
                ZONE.set(this, newZone);
                this.context.databaseDidShiftZone(this, newZone.database, newZone);
                break block3;
            }
            if (newZone != null) {
                newZone.close();
            }
            newZone = zone;
        }
        return newZone;
    }

    protected File zoneFile(int zone) {
        return new File(this.directory, this.baseName + "-" + zone + "." + this.zoneFileExt);
    }

    protected TreeMap<Integer, File> zoneFiles() {
        this.directory.mkdirs();
        File[] files = this.directory.listFiles(this.zoneFilter);
        if (files == null) {
            throw new StoreException("failed to access directory " + this.directory.getPath());
        }
        TreeMap<Integer, File> zoneFiles = new TreeMap<Integer, File>();
        for (File file : files) {
            String name = file.getName();
            Matcher matcher = this.zonePattern.matcher(name);
            if (!matcher.matches()) continue;
            int zone = Integer.parseInt(matcher.group(1));
            zoneFiles.put(zone, file);
        }
        return zoneFiles;
    }

    @Override
    void hitPage(Database database, Page page) {
        this.pageCache.put((Object)page);
        super.hitPage(database, page);
    }
}

