/*
 * Decompiled with CFR 0.152.
 */
package swim.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.codec.Binary;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Cont;
import swim.concurrent.Stage;
import swim.db.Chunk;
import swim.db.Commit;
import swim.db.Database;
import swim.db.Germ;
import swim.db.Page;
import swim.db.PageRef;
import swim.db.Store;
import swim.db.StoreException;
import swim.db.StoreSettings;
import swim.db.TreeDelegate;
import swim.db.Zone;
import swim.recon.Recon;
import swim.structure.Value;

public class FileZone
extends Zone {
    final Store store;
    final int id;
    final File file;
    final Stage stage;
    volatile Database database;
    volatile Germ germ;
    volatile long size;
    volatile int status;
    static final int INITIAL_STATE = 0;
    static final int OPENING_STATE = 1;
    static final int OPENED_STATE = 2;
    static final int CLOSING_STATE = 3;
    static final int CLOSED_STATE = 4;
    static final int STATE_BITS = 3;
    static final int STATE_MASK = 7;
    static final boolean WINDOWS = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    static final AtomicReferenceFieldUpdater<FileZone, Database> DATABASE = AtomicReferenceFieldUpdater.newUpdater(FileZone.class, Database.class, "database");
    static final AtomicIntegerFieldUpdater<FileZone> STATUS = AtomicIntegerFieldUpdater.newUpdater(FileZone.class, "status");

    public FileZone(Store store, int id, File file, Stage stage, Database database, Germ germ) {
        if (database == null || germ == null) {
            throw new NullPointerException();
        }
        this.store = store;
        this.id = id;
        this.file = file;
        this.stage = stage;
        this.database = database;
        this.germ = germ;
        this.status = 2;
    }

    public FileZone(Store store, int id, File file, Stage stage) {
        this.store = store;
        this.id = id;
        this.file = file;
        this.stage = stage;
    }

    public final Store store() {
        return this.store;
    }

    @Override
    public final int id() {
        return this.id;
    }

    public final File file() {
        return this.file;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final Database database() {
        return this.database;
    }

    @Override
    public final Germ germ() {
        return this.germ;
    }

    @Override
    public final StoreSettings settings() {
        return this.store.settings();
    }

    @Override
    public final long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean open() {
        StoreException error;
        boolean interrupted;
        boolean opened;
        block35: {
            int status = STATUS.get(this);
            int state = status & 7;
            opened = false;
            interrupted = false;
            error = null;
            while (true) {
                if (state == 2) {
                    if (!opened) break block35;
                    try {
                        this.didOpen();
                    }
                    catch (Throwable cause2) {
                        if (!Cont.isNonFatal((Throwable)cause2)) {
                            throw cause2;
                        }
                        if (error == null) {
                            error = new StoreException("lifecycle callback failure", cause2);
                        }
                        break block35;
                    }
                }
                if (state == 1) {
                    int newStatus;
                    int oldStatus;
                    FileZone cause2;
                    block36: {
                        if (!opened) {
                            FileZone cause2 = this;
                            synchronized (cause2) {
                            }
                        } else {
                            try {
                                this.onOpen();
                                cause2 = this;
                                break block36;
                            }
                            catch (Throwable cause3) {
                                try {
                                    if (!Cont.isNonFatal((Throwable)cause3)) {
                                        throw cause3;
                                    }
                                    if (error == null) {
                                        error = new StoreException("lifecycle callback failure", cause3);
                                    }
                                    cause2 = this;
                                }
                                catch (Throwable throwable) {
                                    FileZone fileZone = this;
                                    synchronized (fileZone) {
                                        int newStatus2;
                                        int oldStatus2;
                                        while ((state = (status = STATUS.compareAndSet(this, oldStatus2 = status, newStatus2 = oldStatus2 & 0xFFFFFFF8 | 2) ? oldStatus2 : STATUS.get(this)) & 7) != oldStatus2) {
                                        }
                                        this.notifyAll();
                                        throw throwable;
                                    }
                                }
                                synchronized (cause2) {
                                    while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 2) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                                    }
                                    this.notifyAll();
                                    continue;
                                }
                            }
                        }
                        {
                            while ((state = (status = STATUS.get(this)) & 7) == 1) {
                                try {
                                    this.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                            }
                            continue;
                        }
                    }
                    synchronized (cause2) {
                        while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 2) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                        }
                        this.notifyAll();
                        continue;
                    }
                }
                if (state != 0) break;
                int oldStatus = status;
                int newStatus = oldStatus & 0xFFFFFFF8 | 1;
                status = STATUS.compareAndSet(this, oldStatus, newStatus) ? oldStatus : STATUS.get(this);
                state = status & 7;
                if (status != oldStatus) continue;
                opened = true;
                try {
                    this.willOpen();
                }
                catch (Throwable cause) {
                    if (!Cont.isNonFatal((Throwable)cause)) {
                        throw cause;
                    }
                    error = new StoreException("lifecycle callback failure", cause);
                }
            }
            if (state != 3 && state != 4) {
                throw new AssertionError((Object)Integer.toString(state));
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error != null) {
            this.close();
            throw error;
        }
        return opened;
    }

    protected void willOpen() {
    }

    protected void onOpen() {
        this.loadGerm();
    }

    protected void didOpen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        StoreException error;
        boolean interrupted;
        boolean closed;
        block39: {
            int status = STATUS.get(this);
            int state = status & 7;
            closed = false;
            interrupted = false;
            error = null;
            while (true) {
                if (state == 4) {
                    if (!closed) break block39;
                    try {
                        this.didClose();
                        break block39;
                    }
                    catch (Throwable cause) {
                        if (Cont.isNonFatal((Throwable)cause)) {
                            if (error == null) {
                                error = new StoreException("lifecycle callback failure", cause);
                            }
                            break block39;
                        }
                        throw cause;
                    }
                }
                if (state == 3 || state == 1) {
                    int newStatus;
                    int oldStatus;
                    FileZone fileZone;
                    int oldState = state;
                    if (!closed) {
                        FileZone fileZone2 = this;
                        synchronized (fileZone2) {
                            while ((state = (status = STATUS.get(this)) & 7) == oldState) {
                                try {
                                    this.wait(100L);
                                }
                                catch (InterruptedException e) {
                                    interrupted = true;
                                }
                            }
                        }
                    }
                    try {
                        this.onClose();
                        fileZone = this;
                    }
                    catch (Throwable cause2) {
                        FileZone cause2;
                        try {
                            if (Cont.isNonFatal((Throwable)cause2)) {
                                if (error == null) {
                                    error = new StoreException("lifecycle callback failure", cause2);
                                }
                            } else {
                                throw cause2;
                            }
                            cause2 = this;
                        }
                        catch (Throwable throwable) {
                            FileZone fileZone3 = this;
                            synchronized (fileZone3) {
                                int newStatus2;
                                int oldStatus2;
                                while ((state = (status = STATUS.compareAndSet(this, oldStatus2 = status, newStatus2 = oldStatus2 & 0xFFFFFFF8 | 4) ? oldStatus2 : STATUS.get(this)) & 7) != oldStatus2) {
                                }
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (cause2) {
                            while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 4) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                            }
                            this.notifyAll();
                            continue;
                        }
                    }
                    synchronized (fileZone) {
                        while ((state = (status = STATUS.compareAndSet(this, oldStatus = status, newStatus = oldStatus & 0xFFFFFFF8 | 4) ? oldStatus : STATUS.get(this)) & 7) != oldStatus) {
                        }
                        this.notifyAll();
                    }
                }
                if (state == 2) {
                    int oldStatus = status;
                    int newStatus = oldStatus & 0xFFFFFFF8 | 3;
                    status = STATUS.compareAndSet(this, oldStatus, newStatus) ? oldStatus : STATUS.get(this);
                    state = status & 7;
                    if (status != oldStatus) continue;
                    closed = true;
                    try {
                        this.willClose();
                    }
                    catch (Throwable cause) {
                        if (Cont.isNonFatal((Throwable)cause)) {
                            error = new StoreException("lifecycle callback failure", cause);
                        }
                        throw cause;
                    }
                }
                if (state != 0) break;
                this.open();
            }
            throw new AssertionError((Object)Integer.toString(state));
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (error != null) {
            throw error;
        }
        return closed;
    }

    protected void willClose() {
    }

    protected void onClose() {
    }

    protected void didClose() {
    }

    protected Germ loadGerm() {
        Germ germ;
        try (FileChannel channel = this.openReadChannel();){
            this.size = channel.size();
            long offset = 0L;
            int size = 8192;
            if (8192L <= this.size) {
                ByteBuffer buffer = ByteBuffer.allocate(8192);
                long position = 0L;
                int k = 0;
                do {
                    k = channel.read(buffer, position);
                    position += (long)k;
                } while (k >= 0 && buffer.hasRemaining());
                if (buffer.hasRemaining()) {
                    throw new StoreException("incomplete header read from " + this.file.getPath() + ":0-" + position);
                }
                ((Buffer)buffer).position(0).limit(4096);
                Germ germ0 = this.parseGerm(Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer)));
                ((Buffer)buffer).position(4096).limit(8192);
                Germ germ1 = this.parseGerm(Utf8.decodedInput((Input)Binary.inputBuffer((ByteBuffer)buffer)));
                if (germ0 != null && germ1 != null) {
                    germ = germ0.updated() < germ1.updated() ? germ1 : germ0;
                } else if (germ1 != null) {
                    germ = germ1;
                } else if (germ0 != null) {
                    germ = germ0;
                } else {
                    long time = System.currentTimeMillis();
                    germ = new Germ(10, 1L, time, time, Value.absent());
                }
            } else {
                long time = System.currentTimeMillis();
                germ = new Germ(10, 1L, time, time, Value.absent());
            }
        }
        catch (FileNotFoundException cause) {
            long time = System.currentTimeMillis();
            germ = new Germ(10, 1L, time, time, Value.absent());
        }
        catch (IOException cause) {
            throw new StoreException("failed to load header from " + this.file.getPath(), cause);
        }
        this.germ = germ;
        return germ;
    }

    protected Germ parseGerm(Input input) {
        try {
            Parser parser = Recon.structureParser().parseBlock(input);
            if (parser.isDone()) {
                return Germ.fromValue((Value)parser.bind());
            }
            return null;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                return null;
            }
            throw cause;
        }
    }

    @Override
    public Database openDatabase() {
        Database oldDatabase;
        this.open();
        Database newDatabase = null;
        do {
            if ((oldDatabase = DATABASE.get(this)) != null) {
                newDatabase = oldDatabase;
                break;
            }
            if (newDatabase != null) continue;
            newDatabase = new Database(this.store, this.germ);
        } while (!DATABASE.compareAndSet(this, oldDatabase, newDatabase));
        newDatabase.open();
        return newDatabase;
    }

    public FileChannel openReadChannel() throws IOException {
        return new RandomAccessFile(this.file, "r").getChannel();
    }

    public FileChannel openWriteChannel() throws IOException {
        return new RandomAccessFile(this.file, "rw").getChannel();
    }

    Page loadPage(FileChannel channel, PageRef pageRef, TreeDelegate treeDelegate, boolean isResident) {
        long offset = pageRef.base();
        int size = pageRef.pageSize();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        long position = offset;
        try {
            int k = 0;
            do {
                k = channel.read(buffer, position);
                position += (long)k;
            } while (k >= 0 && buffer.hasRemaining());
        }
        catch (IOException cause) {
            throw new StoreException("failed to read page from " + this.file.getPath() + ":" + offset + "-" + size, cause);
        }
        if (buffer.hasRemaining()) {
            throw new StoreException("incomplete page read from " + this.file.getPath() + ":" + offset + "-" + position);
        }
        ((Buffer)buffer).flip();
        try {
            Parser parser = Utf8.parseDecoded((Input)Binary.inputBuffer((ByteBuffer)buffer), (Parser)Recon.structureParser().blockParser());
            Value value = (Value)parser.bind();
            Page page = pageRef.setPageValue(value, isResident);
            if (treeDelegate != null) {
                treeDelegate.treeDidLoadPage(page);
            }
            return page;
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                throw new StoreException("failed to decode page from " + this.file.getPath() + ":" + offset + "-" + size, cause);
            }
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public Chunk commitAndWriteChunk(Commit commit) {
        Database database = this.database;
        Chunk chunk = null;
        try (FileChannel channel = this.openWriteChannel();){
            Chunk chunk2;
            block23: {
                FileLock fileLock = null;
                if (!WINDOWS) {
                    fileLock = channel.lock();
                }
                try {
                    long base = Math.max(this.size, Math.max(8192L, channel.size()));
                    chunk = database.commitChunk(commit, this.id, base);
                    if (chunk != null) {
                        long expectedSize;
                        long actualSize;
                        long step = base;
                        FingerTrieSeq<Page> pages = chunk.pages;
                        for (int i = 0; i < pages.size(); ++i) {
                            Page page = (Page)pages.get(i);
                            int pageSize = page.pageSize();
                            OutputBuffer output = Binary.outputBuffer((byte[])new byte[pageSize]);
                            Output encoder = Utf8.encodedOutput((Output)output);
                            page.writePage(encoder);
                            ByteBuffer pageBuffer = (ByteBuffer)output.bind();
                            if (pageBuffer.remaining() != pageSize) {
                                throw new StoreException("serialized page size of " + pageBuffer.remaining() + " bytes does not match expected page size of " + pageSize + " bytes");
                            }
                            this.write(channel, pageBuffer, step);
                            step += (long)pageSize;
                        }
                        if (commit.isForced()) {
                            channel.force(true);
                        }
                        if ((actualSize = channel.size()) != (expectedSize = base + chunk.size())) {
                            throw new StoreException("inconsistent size detected for file " + this.file.getPath() + " after chunk write; expected length of " + expectedSize + " bytes, but found length of " + actualSize + " bytes");
                        }
                        Germ germ = chunk.germ();
                        ByteBuffer germBuffer = germ.toByteBuffer();
                        this.write(channel, germBuffer, 0L);
                        ((Buffer)germBuffer).flip();
                        this.write(channel, germBuffer, 4096L);
                        if (commit.isForced()) {
                            channel.force(true);
                        }
                        this.size = actualSize;
                    }
                    chunk2 = chunk;
                    if (fileLock == null) break block23;
                }
                catch (Throwable throwable) {
                    if (fileLock != null) {
                        fileLock.release();
                    }
                    throw throwable;
                }
                fileLock.release();
            }
            return chunk2;
        }
        catch (IOException cause) {
            if (chunk != null) {
                database.uncommit(chunk.germ.version);
            }
            throw new StoreException(cause);
        }
        catch (Throwable cause) {
            if (Cont.isNonFatal((Throwable)cause)) {
                if (chunk != null) {
                    database.uncommit(chunk.germ.version);
                }
                throw new StoreException(cause);
            }
            throw cause;
        }
    }

    void write(FileChannel channel, ByteBuffer buffer, long position) throws IOException {
        long base = position;
        do {
            position += (long)channel.write(buffer, position);
        } while (buffer.hasRemaining());
        if (buffer.hasRemaining()) {
            throw new StoreException("wrote incomplete chunk to " + this.file.getPath());
        }
    }
}

